/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.iterator;

import com.google.common.io.Closeables;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.mahout.clustering.classify.ClusterClassifier;
import org.apache.mahout.clustering.iterator.CIMapper;
import org.apache.mahout.clustering.iterator.CIReducer;
import org.apache.mahout.clustering.iterator.ClusterWritable;
import org.apache.mahout.clustering.iterator.ClusteringPolicy;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirValueIterable;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileValueIterator;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public final class ClusterIterator {
    public static final String PRIOR_PATH_KEY = "org.apache.mahout.clustering.prior.path";

    private ClusterIterator() {
    }

    public static ClusterClassifier iterate(Iterable<Vector> data, ClusterClassifier classifier, int numIterations) {
        ClusteringPolicy policy = classifier.getPolicy();
        for (int iteration = 1; iteration <= numIterations; ++iteration) {
            for (Vector vector : data) {
                policy.update(classifier);
                Vector probabilities = classifier.classify(vector);
                Vector weights = policy.select(probabilities);
                for (Vector.Element e : weights.nonZeroes()) {
                    int index = e.index();
                    classifier.train(index, vector, weights.get(index));
                }
            }
            classifier.close();
        }
        return classifier;
    }

    public static void iterateSeq(Configuration conf, Path inPath, Path priorPath, Path outPath, int numIterations) throws IOException {
        int iteration;
        ClusterClassifier classifier = new ClusterClassifier();
        classifier.readFromSeqFiles(conf, priorPath);
        Path clustersOut = null;
        for (iteration = 1; iteration <= numIterations; ++iteration) {
            for (VectorWritable vw : new SequenceFileDirValueIterable(inPath, PathType.LIST, PathFilters.logsCRCFilter(), conf)) {
                Vector vector = vw.get();
                Vector probabilities = classifier.classify(vector);
                Vector weights = classifier.getPolicy().select(probabilities);
                for (Vector.Element e : weights.nonZeroes()) {
                    int index = e.index();
                    classifier.train(index, vector, weights.get(index));
                }
            }
            classifier.close();
            classifier.getPolicy().update(classifier);
            clustersOut = new Path(outPath, "clusters-" + iteration);
            classifier.writeToSeqFiles(clustersOut);
            FileSystem fs = FileSystem.get((URI)outPath.toUri(), (Configuration)conf);
            if (!ClusterIterator.isConverged(clustersOut, conf, fs)) continue;
            break;
        }
        Path finalClustersIn = new Path(outPath, "clusters-" + (iteration - 1) + "-final");
        FileSystem.get((URI)clustersOut.toUri(), (Configuration)conf).rename(clustersOut, finalClustersIn);
    }

    public static void iterateMR(Configuration conf, Path inPath, Path priorPath, Path outPath, int numIterations) throws IOException, InterruptedException, ClassNotFoundException {
        int iteration;
        ClusteringPolicy policy = ClusterClassifier.readPolicy(priorPath);
        Path clustersOut = null;
        for (iteration = 1; iteration <= numIterations; ++iteration) {
            conf.set(PRIOR_PATH_KEY, priorPath.toString());
            String jobName = "Cluster Iterator running iteration " + iteration + " over priorPath: " + priorPath;
            Job job = new Job(conf, jobName);
            job.setMapOutputKeyClass(IntWritable.class);
            job.setMapOutputValueClass(ClusterWritable.class);
            job.setOutputKeyClass(IntWritable.class);
            job.setOutputValueClass(ClusterWritable.class);
            job.setInputFormatClass(SequenceFileInputFormat.class);
            job.setOutputFormatClass(SequenceFileOutputFormat.class);
            job.setMapperClass(CIMapper.class);
            job.setReducerClass(CIReducer.class);
            FileInputFormat.addInputPath((Job)job, (Path)inPath);
            priorPath = clustersOut = new Path(outPath, "clusters-" + iteration);
            FileOutputFormat.setOutputPath((Job)job, (Path)clustersOut);
            job.setJarByClass(ClusterIterator.class);
            if (!job.waitForCompletion(true)) {
                throw new InterruptedException("Cluster Iteration " + iteration + " failed processing " + priorPath);
            }
            ClusterClassifier.writePolicy(policy, clustersOut);
            FileSystem fs = FileSystem.get((URI)outPath.toUri(), (Configuration)conf);
            if (!ClusterIterator.isConverged(clustersOut, conf, fs)) continue;
            break;
        }
        Path finalClustersIn = new Path(outPath, "clusters-" + (iteration - 1) + "-final");
        FileSystem.get((URI)clustersOut.toUri(), (Configuration)conf).rename(clustersOut, finalClustersIn);
    }

    private static boolean isConverged(Path filePath, Configuration conf, FileSystem fs) throws IOException {
        for (FileStatus part : fs.listStatus(filePath, PathFilters.partFilter())) {
            SequenceFileValueIterator iterator = new SequenceFileValueIterator(part.getPath(), true, conf);
            while (iterator.hasNext()) {
                ClusterWritable value = (ClusterWritable)iterator.next();
                if (value.getValue().isConverged()) continue;
                Closeables.close(iterator, true);
                return false;
            }
        }
        return true;
    }
}

