/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.iterator;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.clustering.Cluster;
import org.apache.mahout.clustering.classify.ClusterClassifier;
import org.apache.mahout.clustering.iterator.ClusterWritable;
import org.apache.mahout.clustering.iterator.ClusteringPolicy;

public class CIReducer
extends Reducer<IntWritable, ClusterWritable, IntWritable, ClusterWritable> {
    private ClusterClassifier classifier;
    private ClusteringPolicy policy;

    protected void reduce(IntWritable key, Iterable<ClusterWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        Iterator<ClusterWritable> iter = values.iterator();
        Cluster first = iter.next().getValue();
        while (iter.hasNext()) {
            Cluster cluster = iter.next().getValue();
            first.observe(cluster);
        }
        ArrayList<Cluster> models = Lists.newArrayList();
        models.add(first);
        this.classifier = new ClusterClassifier(models, this.policy);
        this.classifier.close();
        context.write((Object)key, (Object)new ClusterWritable(first));
    }

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        String priorClustersPath = conf.get("org.apache.mahout.clustering.prior.path");
        this.classifier = new ClusterClassifier();
        this.classifier.readFromSeqFiles(conf, new Path(priorClustersPath));
        this.policy = this.classifier.getPolicy();
        this.policy.update(this.classifier);
        super.setup(context);
    }
}

