/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.canopy;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.clustering.canopy.Canopy;
import org.apache.mahout.clustering.canopy.CanopyClusterer;
import org.apache.mahout.math.VectorWritable;

class CanopyMapper
extends Mapper<WritableComparable<?>, VectorWritable, Text, VectorWritable> {
    private final Collection<Canopy> canopies = Lists.newArrayList();
    private CanopyClusterer canopyClusterer;
    private int clusterFilter;

    CanopyMapper() {
    }

    protected void map(WritableComparable<?> key, VectorWritable point, Mapper.Context context) throws IOException, InterruptedException {
        this.canopyClusterer.addPointToCanopies(point.get(), this.canopies);
    }

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.canopyClusterer = new CanopyClusterer(context.getConfiguration());
        this.clusterFilter = Integer.parseInt(context.getConfiguration().get("org.apache.mahout.clustering.canopy.canopyFilter"));
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        for (Canopy canopy : this.canopies) {
            canopy.computeParameters();
            if (canopy.getNumObservations() <= (long)this.clusterFilter) continue;
            context.write((Object)new Text("centroid"), (Object)new VectorWritable(canopy.getCenter()));
        }
        super.cleanup(context);
    }
}

