/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.model.jdbc;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.jdbc.AbstractJDBCComponent;
import org.apache.mahout.cf.taste.impl.model.jdbc.AbstractJDBCDataModel;
import org.apache.mahout.common.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQL92JDBCDataModel
extends AbstractJDBCDataModel {
    private static final Logger log = LoggerFactory.getLogger(SQL92JDBCDataModel.class);
    private final String updatePreferenceSQL;
    private final String verifyPreferenceSQL;

    public SQL92JDBCDataModel() throws TasteException {
        this("jdbc/taste");
    }

    public SQL92JDBCDataModel(String dataSourceName) throws TasteException {
        this(AbstractJDBCComponent.lookupDataSource(dataSourceName), "taste_preferences", "user_id", "item_id", "preference", "timestamp");
    }

    public SQL92JDBCDataModel(DataSource dataSource) {
        this(dataSource, "taste_preferences", "user_id", "item_id", "preference", "timestamp");
    }

    public SQL92JDBCDataModel(DataSource dataSource, String preferenceTable, String userIDColumn, String itemIDColumn, String preferenceColumn, String timestampColumn) {
        super(dataSource, preferenceTable, userIDColumn, itemIDColumn, preferenceColumn, "SELECT " + preferenceColumn + " FROM " + preferenceTable + " WHERE " + userIDColumn + "=? AND " + itemIDColumn + "=?", "SELECT " + timestampColumn + " FROM " + preferenceTable + " WHERE " + userIDColumn + "=? AND " + itemIDColumn + "=?", "SELECT DISTINCT " + userIDColumn + ", " + itemIDColumn + ", " + preferenceColumn + " FROM " + preferenceTable + " WHERE " + userIDColumn + "=? ORDER BY " + itemIDColumn, "SELECT DISTINCT " + userIDColumn + ", " + itemIDColumn + ", " + preferenceColumn + " FROM " + preferenceTable + " ORDER BY " + userIDColumn + ", " + itemIDColumn, "SELECT COUNT(DISTINCT " + itemIDColumn + ") FROM " + preferenceTable, "SELECT COUNT(DISTINCT " + userIDColumn + ") FROM " + preferenceTable, "INSERT INTO " + preferenceTable + '(' + userIDColumn + ',' + itemIDColumn + ',' + preferenceColumn + ") VALUES (?,?,?)", "DELETE FROM " + preferenceTable + " WHERE " + userIDColumn + "=? AND " + itemIDColumn + "=?", "SELECT DISTINCT " + userIDColumn + " FROM " + preferenceTable + " ORDER BY " + userIDColumn, "SELECT DISTINCT " + itemIDColumn + " FROM " + preferenceTable + " ORDER BY " + itemIDColumn, "SELECT DISTINCT " + userIDColumn + ", " + itemIDColumn + ", " + preferenceColumn + " FROM " + preferenceTable + " WHERE " + itemIDColumn + "=? ORDER BY " + userIDColumn, "SELECT COUNT(1) FROM " + preferenceTable + " WHERE " + itemIDColumn + "=?", "SELECT COUNT(1) FROM " + preferenceTable + " tp1 JOIN " + preferenceTable + " tp2 " + "USING (" + userIDColumn + ") WHERE tp1." + itemIDColumn + "=? and tp2." + itemIDColumn + "=?", "SELECT MAX(" + preferenceColumn + ") FROM " + preferenceTable, "SELECT MIN(" + preferenceColumn + ") FROM " + preferenceTable);
        this.updatePreferenceSQL = "UPDATE " + preferenceTable + " SET " + preferenceColumn + "=? WHERE " + userIDColumn + "=? AND " + itemIDColumn + "=?";
        this.verifyPreferenceSQL = "SELECT " + preferenceColumn + " FROM " + preferenceTable + " WHERE " + userIDColumn + "=? AND " + itemIDColumn + "=?";
    }

    protected String getUpdatePreferenceSQL() {
        return this.updatePreferenceSQL;
    }

    protected String getVerifyPreferenceSQL() {
        return this.verifyPreferenceSQL;
    }

    @Override
    public void setPreference(long userID, long itemID, float value) throws TasteException {
        ResultSet rs;
        PreparedStatement stmt3;
        PreparedStatement stmt2;
        PreparedStatement stmt1;
        Connection conn;
        block5: {
            Preconditions.checkArgument(!Float.isNaN(value), "NaN value");
            log.debug("Setting preference for user {}, item {}", (Object)userID, (Object)itemID);
            String setPreferenceSQL = this.getSetPreferenceSQL();
            conn = null;
            stmt1 = null;
            stmt2 = null;
            stmt3 = null;
            rs = null;
            try {
                conn = this.getDataSource().getConnection();
                stmt1 = conn.prepareStatement(this.verifyPreferenceSQL, 1003, 1007);
                this.setLongParameter(stmt1, 1, userID);
                this.setLongParameter(stmt1, 2, itemID);
                rs = stmt1.executeQuery();
                if (rs.first()) {
                    stmt2 = conn.prepareStatement(this.updatePreferenceSQL);
                    stmt2.setDouble(1, value);
                    this.setLongParameter(stmt2, 2, userID);
                    this.setLongParameter(stmt2, 3, itemID);
                    log.debug("Executing SQL update: {}", (Object)this.updatePreferenceSQL);
                    stmt2.executeUpdate();
                    break block5;
                }
                stmt3 = conn.prepareStatement(setPreferenceSQL);
                this.setLongParameter(stmt3, 1, userID);
                this.setLongParameter(stmt3, 2, itemID);
                stmt3.setDouble(3, value);
                log.debug("Executing SQL update: {}", (Object)setPreferenceSQL);
                stmt3.executeUpdate();
            }
            catch (SQLException sqle) {
                try {
                    log.warn("Exception while setting preference", (Throwable)sqle);
                    throw new TasteException(sqle);
                }
                catch (Throwable throwable) {
                    IOUtils.quietClose(rs);
                    IOUtils.quietClose(stmt1);
                    IOUtils.quietClose(stmt2);
                    IOUtils.quietClose(stmt3);
                    IOUtils.quietClose(conn);
                    throw throwable;
                }
            }
        }
        IOUtils.quietClose(rs);
        IOUtils.quietClose(stmt1);
        IOUtils.quietClose(stmt2);
        IOUtils.quietClose(stmt3);
        IOUtils.quietClose(conn);
    }
}

