/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.example.kddcup.track2;

import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.mahout.cf.taste.example.kddcup.DataFileIterable;
import org.apache.mahout.cf.taste.example.kddcup.KDDCupDataModel;
import org.apache.mahout.cf.taste.example.kddcup.track2.Track2Callable;
import org.apache.mahout.cf.taste.example.kddcup.track2.Track2Recommender;
import org.apache.mahout.cf.taste.example.kddcup.track2.UserResult;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.common.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Track2Runner {
    private static final Logger log = LoggerFactory.getLogger(Track2Runner.class);

    private Track2Runner() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        File dataFileDirectory = new File(args[0]);
        if (!dataFileDirectory.exists() || !dataFileDirectory.isDirectory()) {
            throw new IllegalArgumentException("Bad data file directory: " + dataFileDirectory);
        }
        long start = System.currentTimeMillis();
        KDDCupDataModel model = new KDDCupDataModel(KDDCupDataModel.getTrainingFile(dataFileDirectory));
        Track2Recommender recommender = new Track2Recommender(model, dataFileDirectory);
        long end = System.currentTimeMillis();
        log.info("Loaded model in {}s", (Object)((end - start) / 1000L));
        start = end;
        ArrayList<Track2Callable> callables = Lists.newArrayList();
        for (Pair<PreferenceArray, long[]> tests : new DataFileIterable(KDDCupDataModel.getTestFile(dataFileDirectory))) {
            PreferenceArray userTest = tests.getFirst();
            callables.add(new Track2Callable(recommender, userTest));
        }
        int cores = Runtime.getRuntime().availableProcessors();
        log.info("Running on {} cores", (Object)cores);
        ExecutorService executor = Executors.newFixedThreadPool(cores);
        List futures = executor.invokeAll(callables);
        executor.shutdown();
        end = System.currentTimeMillis();
        log.info("Ran recommendations in {}s", (Object)((end - start) / 1000L));
        start = end;
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(args[1])));
        try {
            long lastUserID = Long.MIN_VALUE;
            for (Future future : futures) {
                UserResult result = (UserResult)future.get();
                long userID = result.getUserID();
                if (userID <= lastUserID) {
                    throw new IllegalStateException();
                }
                lastUserID = userID;
                ((OutputStream)out).write(result.getResultBytes());
            }
        }
        finally {
            Closeables.close(out, false);
        }
        end = System.currentTimeMillis();
        log.info("Wrote output in {}s", (Object)((end - start) / 1000L));
    }
}

