/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.example.email;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileIterable;
import org.apache.mahout.math.map.OpenObjectIntHashMap;

public final class EmailUtility {
    public static final String SEPARATOR = "separator";
    public static final String MSG_IDS_PREFIX = "msgIdsPrefix";
    public static final String FROM_PREFIX = "fromPrefix";
    public static final String MSG_ID_DIMENSION = "msgIdDim";
    public static final String FROM_INDEX = "fromIdx";
    public static final String REFS_INDEX = "refsIdx";
    private static final String[] EMPTY = new String[0];
    private static final Pattern ADDRESS_CLEANUP = Pattern.compile("mailto:|<|>|\\[|\\]|\\=20");
    private static final Pattern ANGLE_BRACES = Pattern.compile("<|>");
    private static final Pattern SPACE_OR_CLOSE_ANGLE = Pattern.compile(">|\\s+");
    public static final Pattern WHITESPACE = Pattern.compile("\\s*");

    private EmailUtility() {
    }

    public static String cleanUpEmailAddress(CharSequence address) {
        return ADDRESS_CLEANUP.matcher(address).replaceAll("");
    }

    public static void loadDictionaries(Configuration conf, String fromPrefix, OpenObjectIntHashMap<String> fromDictionary, String msgIdPrefix, OpenObjectIntHashMap<String> msgIdDictionary) throws IOException {
        Path[] localFiles = HadoopUtil.getCachedFiles(conf);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        for (Path dictionaryFile : localFiles) {
            OpenObjectIntHashMap<String> dictionary = null;
            if (dictionaryFile.getName().startsWith(fromPrefix)) {
                dictionary = fromDictionary;
            } else if (dictionaryFile.getName().startsWith(msgIdPrefix)) {
                dictionary = msgIdDictionary;
            }
            if (dictionary == null) continue;
            dictionaryFile = fs.makeQualified(dictionaryFile);
            for (Pair record : new SequenceFileIterable(dictionaryFile, true, conf)) {
                dictionary.put(((Writable)record.getFirst()).toString(), ((IntWritable)record.getSecond()).get());
            }
        }
    }

    public static String[] parseReferences(CharSequence rawRefs) {
        String[] splits;
        if (rawRefs != null && rawRefs.length() > 0) {
            splits = SPACE_OR_CLOSE_ANGLE.split(rawRefs);
            for (int i = 0; i < splits.length; ++i) {
                splits[i] = ANGLE_BRACES.matcher(splits[i]).replaceAll("");
            }
        } else {
            splits = EMPTY;
        }
        return splits;
    }

    public static enum Counters {
        NO_MESSAGE_ID,
        NO_FROM_ADDRESS;

    }
}

