/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.example.bookcrossing;

import java.util.Collection;
import java.util.List;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.neighborhood.NearestNUserNeighborhood;
import org.apache.mahout.cf.taste.impl.recommender.GenericBooleanPrefUserBasedRecommender;
import org.apache.mahout.cf.taste.impl.similarity.CachingUserSimilarity;
import org.apache.mahout.cf.taste.impl.similarity.LogLikelihoodSimilarity;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.recommender.IDRescorer;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.cf.taste.recommender.Recommender;
import org.apache.mahout.cf.taste.similarity.UserSimilarity;

public final class BookCrossingBooleanRecommender
implements Recommender {
    private final Recommender recommender;

    public BookCrossingBooleanRecommender(DataModel bcModel) throws TasteException {
        CachingUserSimilarity similarity = new CachingUserSimilarity((UserSimilarity)new LogLikelihoodSimilarity(bcModel), bcModel);
        NearestNUserNeighborhood neighborhood = new NearestNUserNeighborhood(10, Double.NEGATIVE_INFINITY, similarity, bcModel, 1.0);
        this.recommender = new GenericBooleanPrefUserBasedRecommender(bcModel, neighborhood, similarity);
    }

    @Override
    public List<RecommendedItem> recommend(long userID, int howMany) throws TasteException {
        return this.recommender.recommend(userID, howMany);
    }

    @Override
    public List<RecommendedItem> recommend(long userID, int howMany, IDRescorer rescorer) throws TasteException {
        return this.recommender.recommend(userID, howMany, rescorer);
    }

    @Override
    public float estimatePreference(long userID, long itemID) throws TasteException {
        return this.recommender.estimatePreference(userID, itemID);
    }

    @Override
    public void setPreference(long userID, long itemID, float value) throws TasteException {
        this.recommender.setPreference(userID, itemID, value);
    }

    @Override
    public void removePreference(long userID, long itemID) throws TasteException {
        this.recommender.removePreference(userID, itemID);
    }

    @Override
    public DataModel getDataModel() {
        return this.recommender.getDataModel();
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        this.recommender.refresh(alreadyRefreshed);
    }

    public String toString() {
        return "BookCrossingBooleanRecommender[recommender:" + this.recommender + ']';
    }
}

