/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.benchmark;

import org.apache.mahout.benchmark.BenchmarkRunner;
import org.apache.mahout.benchmark.VectorBenchmarks;

public class DotBenchmark {
    private static final String DOT_PRODUCT = "DotProduct";
    private static final String NORM1 = "Norm1";
    private static final String NORM2 = "Norm2";
    private static final String LOG_NORMALIZE = "LogNormalize";
    private final VectorBenchmarks mark;

    public DotBenchmark(VectorBenchmarks mark) {
        this.mark = mark;
    }

    public void benchmark() {
        this.benchmarkDot();
        this.benchmarkNorm1();
        this.benchmarkNorm2();
        this.benchmarkLogNormalize();
    }

    private void benchmarkLogNormalize() {
        this.mark.printStats(this.mark.getRunner().benchmark(new BenchmarkRunner.BenchmarkFn(){

            @Override
            public Boolean apply(Integer i) {
                return this.depends(((DotBenchmark)DotBenchmark.this).mark.vectors[0][DotBenchmark.this.mark.vIndex(i)].logNormalize());
            }
        }), LOG_NORMALIZE, "DenseVector");
        this.mark.printStats(this.mark.getRunner().benchmark(new BenchmarkRunner.BenchmarkFn(){

            @Override
            public Boolean apply(Integer i) {
                return this.depends(((DotBenchmark)DotBenchmark.this).mark.vectors[1][DotBenchmark.this.mark.vIndex(i)].logNormalize());
            }
        }), LOG_NORMALIZE, "RandSparseVector");
        this.mark.printStats(this.mark.getRunner().benchmark(new BenchmarkRunner.BenchmarkFn(){

            @Override
            public Boolean apply(Integer i) {
                return this.depends(((DotBenchmark)DotBenchmark.this).mark.vectors[2][DotBenchmark.this.mark.vIndex(i)].logNormalize());
            }
        }), LOG_NORMALIZE, "SeqSparseVector");
    }

    private void benchmarkNorm1() {
        this.mark.printStats(this.mark.getRunner().benchmarkD(new BenchmarkRunner.BenchmarkFnD(){

            @Override
            public Double apply(Integer i) {
                return ((DotBenchmark)DotBenchmark.this).mark.vectors[0][DotBenchmark.this.mark.vIndex(i)].norm(1.0);
            }
        }), NORM1, "DenseVector");
        this.mark.printStats(this.mark.getRunner().benchmarkD(new BenchmarkRunner.BenchmarkFnD(){

            @Override
            public Double apply(Integer i) {
                return ((DotBenchmark)DotBenchmark.this).mark.vectors[1][DotBenchmark.this.mark.vIndex(i)].norm(1.0);
            }
        }), NORM1, "RandSparseVector");
        this.mark.printStats(this.mark.getRunner().benchmarkD(new BenchmarkRunner.BenchmarkFnD(){

            @Override
            public Double apply(Integer i) {
                return ((DotBenchmark)DotBenchmark.this).mark.vectors[2][DotBenchmark.this.mark.vIndex(i)].norm(1.0);
            }
        }), NORM1, "SeqSparseVector");
    }

    private void benchmarkNorm2() {
        this.mark.printStats(this.mark.getRunner().benchmarkD(new BenchmarkRunner.BenchmarkFnD(){

            @Override
            public Double apply(Integer i) {
                return ((DotBenchmark)DotBenchmark.this).mark.vectors[0][DotBenchmark.this.mark.vIndex(i)].norm(2.0);
            }
        }), NORM2, "DenseVector");
        this.mark.printStats(this.mark.getRunner().benchmarkD(new BenchmarkRunner.BenchmarkFnD(){

            @Override
            public Double apply(Integer i) {
                return ((DotBenchmark)DotBenchmark.this).mark.vectors[1][DotBenchmark.this.mark.vIndex(i)].norm(2.0);
            }
        }), NORM2, "RandSparseVector");
        this.mark.printStats(this.mark.getRunner().benchmarkD(new BenchmarkRunner.BenchmarkFnD(){

            @Override
            public Double apply(Integer i) {
                return ((DotBenchmark)DotBenchmark.this).mark.vectors[2][DotBenchmark.this.mark.vIndex(i)].norm(2.0);
            }
        }), NORM2, "SeqSparseVector");
    }

    private void benchmarkDot() {
        this.mark.printStats(this.mark.getRunner().benchmarkD(new BenchmarkRunner.BenchmarkFnD(){

            @Override
            public Double apply(Integer i) {
                return ((DotBenchmark)DotBenchmark.this).mark.vectors[0][DotBenchmark.this.mark.vIndex(i)].dot(((DotBenchmark)DotBenchmark.this).mark.vectors[0][DotBenchmark.this.mark.vIndex(this.randIndex())]);
            }
        }), DOT_PRODUCT, "DenseVector");
        this.mark.printStats(this.mark.getRunner().benchmarkD(new BenchmarkRunner.BenchmarkFnD(){

            @Override
            public Double apply(Integer i) {
                return ((DotBenchmark)DotBenchmark.this).mark.vectors[1][DotBenchmark.this.mark.vIndex(i)].dot(((DotBenchmark)DotBenchmark.this).mark.vectors[1][DotBenchmark.this.mark.vIndex(this.randIndex())]);
            }
        }), DOT_PRODUCT, "RandSparseVector");
        this.mark.printStats(this.mark.getRunner().benchmarkD(new BenchmarkRunner.BenchmarkFnD(){

            @Override
            public Double apply(Integer i) {
                return ((DotBenchmark)DotBenchmark.this).mark.vectors[2][DotBenchmark.this.mark.vIndex(i)].dot(((DotBenchmark)DotBenchmark.this).mark.vectors[2][DotBenchmark.this.mark.vIndex(this.randIndex())]);
            }
        }), DOT_PRODUCT, "SeqSparseVector");
        this.mark.printStats(this.mark.getRunner().benchmarkD(new BenchmarkRunner.BenchmarkFnD(){

            @Override
            public Double apply(Integer i) {
                return ((DotBenchmark)DotBenchmark.this).mark.vectors[0][DotBenchmark.this.mark.vIndex(i)].dot(((DotBenchmark)DotBenchmark.this).mark.vectors[1][DotBenchmark.this.mark.vIndex(this.randIndex())]);
            }
        }), DOT_PRODUCT, "Dense.fn(Rand)");
        this.mark.printStats(this.mark.getRunner().benchmarkD(new BenchmarkRunner.BenchmarkFnD(){

            @Override
            public Double apply(Integer i) {
                return ((DotBenchmark)DotBenchmark.this).mark.vectors[0][DotBenchmark.this.mark.vIndex(i)].dot(((DotBenchmark)DotBenchmark.this).mark.vectors[2][DotBenchmark.this.mark.vIndex(this.randIndex())]);
            }
        }), DOT_PRODUCT, "Dense.fn(Seq)");
        this.mark.printStats(this.mark.getRunner().benchmarkD(new BenchmarkRunner.BenchmarkFnD(){

            @Override
            public Double apply(Integer i) {
                return ((DotBenchmark)DotBenchmark.this).mark.vectors[1][DotBenchmark.this.mark.vIndex(i)].dot(((DotBenchmark)DotBenchmark.this).mark.vectors[0][DotBenchmark.this.mark.vIndex(this.randIndex())]);
            }
        }), DOT_PRODUCT, "Rand.fn(Dense)");
        this.mark.printStats(this.mark.getRunner().benchmarkD(new BenchmarkRunner.BenchmarkFnD(){

            @Override
            public Double apply(Integer i) {
                return ((DotBenchmark)DotBenchmark.this).mark.vectors[1][DotBenchmark.this.mark.vIndex(i)].dot(((DotBenchmark)DotBenchmark.this).mark.vectors[2][DotBenchmark.this.mark.vIndex(this.randIndex())]);
            }
        }), DOT_PRODUCT, "Rand.fn(Seq)");
        this.mark.printStats(this.mark.getRunner().benchmarkD(new BenchmarkRunner.BenchmarkFnD(){

            @Override
            public Double apply(Integer i) {
                return ((DotBenchmark)DotBenchmark.this).mark.vectors[2][DotBenchmark.this.mark.vIndex(i)].dot(((DotBenchmark)DotBenchmark.this).mark.vectors[0][DotBenchmark.this.mark.vIndex(this.randIndex())]);
            }
        }), DOT_PRODUCT, "Seq.fn(Dense)");
        this.mark.printStats(this.mark.getRunner().benchmarkD(new BenchmarkRunner.BenchmarkFnD(){

            @Override
            public Double apply(Integer i) {
                return ((DotBenchmark)DotBenchmark.this).mark.vectors[2][DotBenchmark.this.mark.vIndex(i)].dot(((DotBenchmark)DotBenchmark.this).mark.vectors[1][DotBenchmark.this.mark.vIndex(this.randIndex())]);
            }
        }), DOT_PRODUCT, "Seq.fn(Rand)");
    }

    public static void main(String[] args) {
        VectorBenchmarks mark = new VectorBenchmarks(1000000, 100, 1000, 10, 1);
        mark.createData();
        new DotBenchmark(mark).benchmarkNorm2();
        System.out.println(mark);
    }
}

