/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.sortedset;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.facet.index.DrillDownStream;
import org.apache.lucene.facet.index.FacetFields;
import org.apache.lucene.facet.params.CategoryListParams;
import org.apache.lucene.facet.params.FacetIndexingParams;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.util.BytesRef;

public class SortedSetDocValuesFacetFields
extends FacetFields {
    public SortedSetDocValuesFacetFields() {
        this(FacetIndexingParams.DEFAULT);
    }

    public SortedSetDocValuesFacetFields(FacetIndexingParams fip) {
        super(null, fip);
        if (fip.getPartitionSize() != Integer.MAX_VALUE) {
            throw new IllegalArgumentException("partitions are not supported");
        }
    }

    @Override
    public void addFields(Document doc, Iterable<CategoryPath> categories) throws IOException {
        if (categories == null) {
            throw new IllegalArgumentException("categories should not be null");
        }
        Map<CategoryListParams, Iterable<CategoryPath>> categoryLists = this.createCategoryListMapping(categories);
        for (Map.Entry<CategoryListParams, Iterable<CategoryPath>> e : categoryLists.entrySet()) {
            CategoryListParams clp = e.getKey();
            String dvField = clp.field + "_sorted_doc_values";
            for (CategoryPath cp : e.getValue()) {
                if (cp.length != 2) {
                    throw new IllegalArgumentException("only flat facets (dimension + label) are currently supported; got " + cp);
                }
                doc.add(new SortedSetDocValuesField(dvField, new BytesRef(cp.toString(this.indexingParams.getFacetDelimChar()))));
            }
            DrillDownStream drillDownStream = this.getDrillDownStream(e.getValue());
            Field drillDown = new Field(clp.field, (TokenStream)drillDownStream, this.drillDownFieldType());
            doc.add(drillDown);
        }
    }
}

