/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.lucene.facet.encoding.IntDecoder;
import org.apache.lucene.facet.params.CategoryListParams;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.RamUsageEstimator;

public class OrdinalsCache {
    private static final Map<Object, Map<String, CachedOrds>> ordsCache = new WeakHashMap<Object, Map<String, CachedOrds>>();

    public static synchronized CachedOrds getCachedOrds(AtomicReaderContext context, CategoryListParams clp) throws IOException {
        CachedOrds co;
        BinaryDocValues dv = context.reader().getBinaryDocValues(clp.field);
        if (dv == null) {
            return null;
        }
        Map<String, CachedOrds> fieldCache = ordsCache.get(context.reader().getCoreCacheKey());
        if (fieldCache == null) {
            fieldCache = new HashMap<String, CachedOrds>();
            ordsCache.put(context.reader().getCoreCacheKey(), fieldCache);
        }
        if ((co = fieldCache.get(clp.field)) == null) {
            co = new CachedOrds(dv, context.reader().maxDoc(), clp);
            fieldCache.put(clp.field, co);
        }
        return co;
    }

    public static synchronized long ramBytesUsed() {
        long size = 0L;
        for (Map<String, CachedOrds> e : ordsCache.values()) {
            for (CachedOrds co : e.values()) {
                size += (long)(RamUsageEstimator.NUM_BYTES_OBJECT_REF + RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + RamUsageEstimator.NUM_BYTES_ARRAY_HEADER * 2 + RamUsageEstimator.NUM_BYTES_OBJECT_REF * 2 + 4 * co.offsets.length + 4 * co.ordinals.length);
            }
        }
        return size;
    }

    public static synchronized void clear() {
        ordsCache.clear();
    }

    public static final class CachedOrds {
        public final int[] offsets;
        public final int[] ordinals;

        public CachedOrds(BinaryDocValues dv, int maxDoc, CategoryListParams clp) {
            BytesRef buf = new BytesRef();
            this.offsets = new int[maxDoc + 1];
            int[] ords = new int[maxDoc];
            int totOrds = 0;
            IntDecoder decoder = clp.createEncoder().createMatchingDecoder();
            IntsRef values = new IntsRef(32);
            for (int docID = 0; docID < maxDoc; ++docID) {
                this.offsets[docID] = totOrds;
                dv.get(docID, buf);
                if (buf.length <= 0) continue;
                decoder.decode(buf, values);
                if (totOrds + values.length >= ords.length) {
                    ords = ArrayUtil.grow(ords, totOrds + values.length + 1);
                }
                for (int i = 0; i < values.length; ++i) {
                    ords[totOrds++] = values.ints[i];
                }
            }
            this.offsets[maxDoc] = totOrds;
            if ((double)totOrds / (double)ords.length < 0.9) {
                this.ordinals = new int[totOrds];
                System.arraycopy(ords, 0, this.ordinals, 0, totOrds);
            } else {
                this.ordinals = ords;
            }
        }
    }
}

