/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.facet.params.FacetSearchParams;
import org.apache.lucene.facet.search.DrillDownQuery;
import org.apache.lucene.facet.search.DrillSidewaysCollector;
import org.apache.lucene.facet.search.DrillSidewaysQuery;
import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.search.FacetResult;
import org.apache.lucene.facet.search.FacetsAccumulator;
import org.apache.lucene.facet.search.FacetsCollector;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesReaderState;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.Weight;

public class DrillSideways {
    protected final IndexSearcher searcher;
    protected final TaxonomyReader taxoReader;
    protected final SortedSetDocValuesReaderState state;

    public DrillSideways(IndexSearcher searcher, TaxonomyReader taxoReader) {
        this.searcher = searcher;
        this.taxoReader = taxoReader;
        this.state = null;
    }

    public DrillSideways(IndexSearcher searcher, SortedSetDocValuesReaderState state) {
        this.searcher = searcher;
        this.taxoReader = null;
        this.state = state;
    }

    private static DrillDownQuery moveDrillDownOnlyClauses(DrillDownQuery in, FacetSearchParams fsp) {
        int startClause;
        HashSet<String> facetDims = new HashSet<String>();
        for (FacetRequest fr : fsp.facetRequests) {
            if (fr.categoryPath.length == 0) {
                throw new IllegalArgumentException("all FacetRequests must have CategoryPath with length > 0");
            }
            facetDims.add(fr.categoryPath.components[0]);
        }
        BooleanClause[] clauses = in.getBooleanQuery().getClauses();
        Map<String, Integer> drillDownDims = in.getDims();
        String[] dimsByIndex = new String[drillDownDims.size()];
        for (Map.Entry<String, Integer> ent : drillDownDims.entrySet()) {
            dimsByIndex[ent.getValue().intValue()] = ent.getKey();
        }
        if (clauses.length == drillDownDims.size()) {
            startClause = 0;
        } else {
            assert (clauses.length == 1 + drillDownDims.size());
            startClause = 1;
        }
        ArrayList<Query> nonFacetClauses = new ArrayList<Query>();
        ArrayList<Query> facetClauses = new ArrayList<Query>();
        LinkedHashMap<String, Integer> dimToIndex = new LinkedHashMap<String, Integer>();
        for (int i = startClause; i < clauses.length; ++i) {
            Query q = clauses[i].getQuery();
            String dim = dimsByIndex[i - startClause];
            if (!facetDims.contains(dim)) {
                nonFacetClauses.add(q);
                continue;
            }
            facetClauses.add(q);
            dimToIndex.put(dim, dimToIndex.size());
        }
        if (!nonFacetClauses.isEmpty()) {
            BooleanQuery newBaseQuery = new BooleanQuery(true);
            if (startClause == 1) {
                newBaseQuery.add(clauses[0].getQuery(), BooleanClause.Occur.MUST);
            }
            for (Query q : nonFacetClauses) {
                newBaseQuery.add(q, BooleanClause.Occur.MUST);
            }
            return new DrillDownQuery(fsp.indexingParams, newBaseQuery, facetClauses, dimToIndex);
        }
        return in;
    }

    public DrillSidewaysResult search(DrillDownQuery query, Collector hitCollector, FacetSearchParams fsp) throws IOException {
        int startClause;
        Query baseQuery;
        if (query.fip != fsp.indexingParams) {
            throw new IllegalArgumentException("DrillDownQuery's FacetIndexingParams should match FacetSearchParams'");
        }
        Map<String, Integer> drillDownDims = (query = DrillSideways.moveDrillDownOnlyClauses(query, fsp)).getDims();
        if (drillDownDims.isEmpty()) {
            FacetsCollector c = FacetsCollector.create(this.getDrillDownAccumulator(fsp));
            this.searcher.search((Query)query, MultiCollector.wrap(hitCollector, c));
            return new DrillSidewaysResult(c.getFacetResults(), null);
        }
        ArrayList<FacetRequest> ddRequests = new ArrayList<FacetRequest>();
        for (FacetRequest fr : fsp.facetRequests) {
            assert (fr.categoryPath.length > 0);
            if (drillDownDims.containsKey(fr.categoryPath.components[0])) continue;
            ddRequests.add(fr);
        }
        FacetSearchParams fsp2 = !ddRequests.isEmpty() ? new FacetSearchParams(fsp.indexingParams, ddRequests) : null;
        BooleanQuery ddq = query.getBooleanQuery();
        BooleanClause[] clauses = ddq.getClauses();
        if (clauses.length == drillDownDims.size()) {
            baseQuery = new MatchAllDocsQuery();
            startClause = 0;
        } else {
            assert (clauses.length == 1 + drillDownDims.size());
            baseQuery = clauses[0].getQuery();
            startClause = 1;
        }
        FacetsCollector drillDownCollector = fsp2 == null ? null : FacetsCollector.create(this.getDrillDownAccumulator(fsp2));
        Collector[] drillSidewaysCollectors = new FacetsCollector[drillDownDims.size()];
        int idx = 0;
        for (String dim : drillDownDims.keySet()) {
            ArrayList<FacetRequest> requests = new ArrayList<FacetRequest>();
            for (FacetRequest fr : fsp.facetRequests) {
                assert (fr.categoryPath.length > 0);
                if (!fr.categoryPath.components[0].equals(dim)) continue;
                requests.add(fr);
            }
            assert (!requests.isEmpty());
            drillSidewaysCollectors[idx++] = FacetsCollector.create(this.getDrillSidewaysAccumulator(dim, new FacetSearchParams(fsp.indexingParams, requests)));
        }
        boolean useCollectorMethod = this.scoreSubDocsAtOnce();
        Term[][] drillDownTerms = null;
        if (!useCollectorMethod) {
            drillDownTerms = new Term[clauses.length - startClause][];
            block3: for (int i = startClause; i < clauses.length; ++i) {
                Query q = clauses[i].getQuery();
                assert (q instanceof ConstantScoreQuery);
                if ((q = ((ConstantScoreQuery)q).getQuery()) instanceof TermQuery) {
                    drillDownTerms[i - startClause] = new Term[]{((TermQuery)q).getTerm()};
                    continue;
                }
                if (q instanceof BooleanQuery) {
                    BooleanQuery q2 = (BooleanQuery)q;
                    BooleanClause[] clauses2 = q2.getClauses();
                    drillDownTerms[i - startClause] = new Term[clauses2.length];
                    for (int j = 0; j < clauses2.length; ++j) {
                        if (!(clauses2[j].getQuery() instanceof TermQuery)) {
                            useCollectorMethod = true;
                            continue block3;
                        }
                        drillDownTerms[i - startClause][j] = ((TermQuery)clauses2[j].getQuery()).getTerm();
                    }
                    continue;
                }
                useCollectorMethod = true;
            }
        }
        if (useCollectorMethod) {
            this.collectorMethod(query, baseQuery, startClause, hitCollector, drillDownCollector, drillSidewaysCollectors);
        } else {
            DrillSidewaysQuery dsq = new DrillSidewaysQuery(baseQuery, drillDownCollector, drillSidewaysCollectors, drillDownTerms);
            this.searcher.search((Query)dsq, hitCollector);
        }
        int numDims = drillDownDims.size();
        List[] drillSidewaysResults = new List[numDims];
        List<FacetResult> drillDownResults = null;
        ArrayList<FacetResult> mergedResults = new ArrayList<FacetResult>();
        int[] requestUpto = new int[drillDownDims.size()];
        int ddUpto = 0;
        for (int i = 0; i < fsp.facetRequests.size(); ++i) {
            FacetRequest fr = fsp.facetRequests.get(i);
            assert (fr.categoryPath.length > 0);
            Integer dimIndex = drillDownDims.get(fr.categoryPath.components[0]);
            if (dimIndex == null) {
                if (drillDownResults == null) {
                    drillDownResults = drillDownCollector.getFacetResults();
                }
                mergedResults.add(drillDownResults.get(ddUpto++));
                continue;
            }
            int dim = dimIndex;
            List<FacetResult> sidewaysResult = drillSidewaysResults[dim];
            if (sidewaysResult == null) {
                drillSidewaysResults[dim] = sidewaysResult = ((FacetsCollector)drillSidewaysCollectors[dim]).getFacetResults();
            }
            mergedResults.add(sidewaysResult.get(requestUpto[dim]));
            int n = dim;
            requestUpto[n] = requestUpto[n] + 1;
        }
        return new DrillSidewaysResult(mergedResults, null);
    }

    private void collectorMethod(DrillDownQuery ddq, Query baseQuery, int startClause, Collector hitCollector, Collector drillDownCollector, Collector[] drillSidewaysCollectors) throws IOException {
        BooleanClause[] clauses = ddq.getBooleanQuery().getClauses();
        Map<String, Integer> drillDownDims = ddq.getDims();
        BooleanQuery topQuery = new BooleanQuery(true);
        final DrillSidewaysCollector collector = new DrillSidewaysCollector(hitCollector, drillDownCollector, drillSidewaysCollectors, drillDownDims);
        topQuery.add(baseQuery, BooleanClause.Occur.MUST);
        BooleanQuery subQuery = new BooleanQuery(true);
        QueryWrapper wrappedSubQuery = new QueryWrapper(subQuery, new SetWeight(){

            @Override
            public void set(Weight w) {
                collector.setWeight(w, -1);
            }
        });
        ConstantScoreQuery constantScoreSubQuery = new ConstantScoreQuery(wrappedSubQuery);
        constantScoreSubQuery.setBoost(0.0f);
        topQuery.add(constantScoreSubQuery, BooleanClause.Occur.MUST);
        int dimIndex = 0;
        for (int i = startClause; i < clauses.length; ++i) {
            Query q = clauses[i].getQuery();
            assert (q instanceof ConstantScoreQuery);
            q = ((ConstantScoreQuery)q).getQuery();
            final int finalDimIndex = dimIndex++;
            subQuery.add(new QueryWrapper(q, new SetWeight(){

                @Override
                public void set(Weight w) {
                    collector.setWeight(w, finalDimIndex);
                }
            }), BooleanClause.Occur.SHOULD);
        }
        int minShouldMatch = drillDownDims.size() - 1;
        if (minShouldMatch == 0) {
            MatchAllDocsQuery end = new MatchAllDocsQuery();
            end.setBoost(0.0f);
            subQuery.add(end, BooleanClause.Occur.SHOULD);
            ++minShouldMatch;
        }
        subQuery.setMinimumNumberShouldMatch(minShouldMatch);
        this.searcher.search((Query)topQuery, collector);
    }

    public DrillSidewaysResult search(DrillDownQuery query, Filter filter, FieldDoc after, int topN, Sort sort, boolean doDocScores, boolean doMaxScore, FacetSearchParams fsp) throws IOException {
        if (filter != null) {
            query = new DrillDownQuery(filter, query);
        }
        if (sort != null) {
            int limit = this.searcher.getIndexReader().maxDoc();
            if (limit == 0) {
                limit = 1;
            }
            topN = Math.min(topN, limit);
            TopFieldCollector hitCollector = TopFieldCollector.create(sort, topN, after, true, doDocScores, doMaxScore, true);
            DrillSidewaysResult r = this.search(query, hitCollector, fsp);
            return new DrillSidewaysResult(r.facetResults, hitCollector.topDocs());
        }
        return this.search(after, query, topN, fsp);
    }

    public DrillSidewaysResult search(ScoreDoc after, DrillDownQuery query, int topN, FacetSearchParams fsp) throws IOException {
        int limit = this.searcher.getIndexReader().maxDoc();
        if (limit == 0) {
            limit = 1;
        }
        topN = Math.min(topN, limit);
        TopScoreDocCollector hitCollector = TopScoreDocCollector.create(topN, after, true);
        DrillSidewaysResult r = this.search(query, hitCollector, fsp);
        return new DrillSidewaysResult(r.facetResults, hitCollector.topDocs());
    }

    protected FacetsAccumulator getDrillDownAccumulator(FacetSearchParams fsp) throws IOException {
        if (this.taxoReader != null) {
            return FacetsAccumulator.create(fsp, this.searcher.getIndexReader(), this.taxoReader, null);
        }
        return FacetsAccumulator.create(fsp, this.state, null);
    }

    protected FacetsAccumulator getDrillSidewaysAccumulator(String dim, FacetSearchParams fsp) throws IOException {
        if (this.taxoReader != null) {
            return FacetsAccumulator.create(fsp, this.searcher.getIndexReader(), this.taxoReader, null);
        }
        return FacetsAccumulator.create(fsp, this.state, null);
    }

    protected boolean scoreSubDocsAtOnce() {
        return false;
    }

    private static class QueryWrapper
    extends Query {
        private final Query originalQuery;
        private final SetWeight setter;

        public QueryWrapper(Query originalQuery, SetWeight setter) {
            this.originalQuery = originalQuery;
            this.setter = setter;
        }

        @Override
        public Weight createWeight(IndexSearcher searcher) throws IOException {
            Weight w = this.originalQuery.createWeight(searcher);
            this.setter.set(w);
            return w;
        }

        @Override
        public Query rewrite(IndexReader reader) throws IOException {
            Query rewritten = this.originalQuery.rewrite(reader);
            if (rewritten != this.originalQuery) {
                return new QueryWrapper(rewritten, this.setter);
            }
            return this;
        }

        @Override
        public String toString(String s) {
            return this.originalQuery.toString(s);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof QueryWrapper)) {
                return false;
            }
            QueryWrapper other = (QueryWrapper)o;
            return super.equals(o) && this.originalQuery.equals(other.originalQuery);
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 31 + this.originalQuery.hashCode();
        }
    }

    private static interface SetWeight {
        public void set(Weight var1);
    }

    public static class DrillSidewaysResult {
        public final List<FacetResult> facetResults;
        public final TopDocs hits;

        public DrillSidewaysResult(List<FacetResult> facetResults, TopDocs hits) {
            this.facetResults = facetResults;
            this.hits = hits;
        }
    }
}

