/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.sampling;

import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.facet.old.ScoredDocIDs;
import org.apache.lucene.facet.old.ScoredDocIDsIterator;
import org.apache.lucene.facet.old.ScoredDocIdsUtils;
import org.apache.lucene.facet.sampling.Sampler;
import org.apache.lucene.facet.sampling.SamplingParams;
import org.apache.lucene.util.PriorityQueue;

public class RepeatableSampler
extends Sampler {
    private static final Logger logger = Logger.getLogger(RepeatableSampler.class.getName());
    private static final int N_PRIMES = 4000;
    private static int[] primes = new int[4000];
    private static final long PHI_32 = 2654435769L;
    private static final long PHI_32I = 340573321L;
    private static boolean returnTimings;

    public RepeatableSampler(SamplingParams params) {
        super(params);
    }

    @Override
    protected Sampler.SampleResult createSample(ScoredDocIDs docids, int actualSize, int sampleSetSize) throws IOException {
        int[] sampleSet = null;
        try {
            sampleSet = RepeatableSampler.repeatableSample(docids, actualSize, sampleSetSize);
        }
        catch (IOException e) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "sampling failed: " + e.getMessage() + " - falling back to no sampling!", e);
            }
            return new Sampler.SampleResult(docids, 1.0);
        }
        ScoredDocIDs sampled = ScoredDocIdsUtils.createScoredDocIDsSubset(docids, sampleSet);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("******************** " + sampled.size());
        }
        return new Sampler.SampleResult(sampled, (double)sampled.size() / (double)docids.size());
    }

    private static int[] repeatableSample(ScoredDocIDs collection, int collectionSize, int sampleSize) throws IOException {
        return RepeatableSampler.repeatableSample(collection, collectionSize, sampleSize, Algorithm.HASHING, Sorted.NO);
    }

    private static int[] repeatableSample(ScoredDocIDs collection, int collectionSize, int sampleSize, Algorithm algorithm, Sorted sorted) throws IOException {
        if (collection == null) {
            throw new IOException("docIdSet is null");
        }
        if (sampleSize < 1) {
            throw new IOException("sampleSize < 1 (" + sampleSize + ")");
        }
        if (collectionSize < sampleSize) {
            throw new IOException("collectionSize (" + collectionSize + ") less than sampleSize (" + sampleSize + ")");
        }
        int[] sample = new int[sampleSize];
        long[] times = new long[4];
        if (algorithm == Algorithm.TRAVERSAL) {
            RepeatableSampler.sample1(collection, collectionSize, sample, times);
        } else if (algorithm == Algorithm.HASHING) {
            RepeatableSampler.sample2(collection, collectionSize, sample, times);
        } else {
            throw new IllegalArgumentException("Invalid algorithm selection");
        }
        if (sorted == Sorted.YES) {
            Arrays.sort(sample);
        }
        if (returnTimings) {
            times[3] = System.currentTimeMillis();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Times: " + (times[1] - times[0]) + "ms, " + (times[2] - times[1]) + "ms, " + (times[3] - times[2]) + "ms");
            }
        }
        return sample;
    }

    private static void sample1(ScoredDocIDs collection, int collectionSize, int[] sample, long[] times) throws IOException {
        ScoredDocIDsIterator it = collection.iterator();
        if (returnTimings) {
            times[0] = System.currentTimeMillis();
        }
        int sampleSize = sample.length;
        int prime = RepeatableSampler.findGoodStepSize(collectionSize, sampleSize);
        int mod = prime % collectionSize;
        if (returnTimings) {
            times[1] = System.currentTimeMillis();
        }
        int sampleCount = 0;
        int index = 0;
        while (sampleCount < sampleSize) {
            int i;
            if (index + mod < collectionSize) {
                i = 0;
                while (i < mod) {
                    it.next();
                    ++i;
                    ++index;
                }
            } else {
                index = index + mod - collectionSize;
                it = collection.iterator();
                for (i = 0; i < index; ++i) {
                    it.next();
                }
            }
            sample[sampleCount++] = it.getDocID();
        }
        if (returnTimings) {
            times[2] = System.currentTimeMillis();
        }
    }

    private static int findGoodStepSize(int collectionSize, int sampleSize) {
        int i = (int)Math.sqrt(collectionSize);
        if (sampleSize < i) {
            i = collectionSize / sampleSize;
        }
        while (collectionSize % (i = RepeatableSampler.findNextPrimeAfter(i)) == 0) {
        }
        return i;
    }

    private static int findNextPrimeAfter(int n) {
        n += n % 2 == 0 ? 1 : 2;
        while (true) {
            block6: {
                int sri = (int)Math.sqrt(n);
                for (int primeIndex = 0; primeIndex < 4000; ++primeIndex) {
                    int p = primes[primeIndex];
                    if (p > sri) {
                        return n;
                    }
                    if (n % p != 0) {
                        continue;
                    }
                    break block6;
                }
                int p = primes[3999] + 2;
                while (true) {
                    if (p > sri) {
                        return n;
                    }
                    if (n % p == 0) break;
                    p += 2;
                }
            }
            n += 2;
        }
    }

    private static void sample2(ScoredDocIDs collection, int collectionSize, int[] sample, long[] times) throws IOException {
        if (returnTimings) {
            times[0] = System.currentTimeMillis();
        }
        int sampleSize = sample.length;
        IntPriorityQueue pq = new IntPriorityQueue(sampleSize);
        ScoredDocIDsIterator it = collection.iterator();
        MI mi = null;
        while (it.next()) {
            if (mi == null) {
                mi = new MI();
            }
            mi.value = (int)((long)it.getDocID() * 2654435769L) & Integer.MAX_VALUE;
            mi = pq.insertWithOverflow(mi);
        }
        if (returnTimings) {
            times[1] = System.currentTimeMillis();
        }
        Object[] heap = pq.getHeap();
        for (int si = 0; si < sampleSize; ++si) {
            sample[si] = (int)((long)((MI)heap[si + 1]).value * 340573321L) & Integer.MAX_VALUE;
        }
        if (returnTimings) {
            times[2] = System.currentTimeMillis();
        }
    }

    static {
        RepeatableSampler.primes[0] = 3;
        for (int count = 1; count < 4000; ++count) {
            RepeatableSampler.primes[count] = RepeatableSampler.findNextPrimeAfter(primes[count - 1]);
        }
        returnTimings = false;
    }

    private static enum Sorted {
        YES,
        NO;

    }

    private static enum Algorithm {
        TRAVERSAL,
        HASHING;

    }

    private static class IntPriorityQueue
    extends PriorityQueue<MI> {
        public IntPriorityQueue(int size) {
            super(size);
        }

        public Object[] getHeap() {
            return this.getHeapArray();
        }

        @Override
        public boolean lessThan(MI o1, MI o2) {
            return o1.value < o2.value;
        }
    }

    private static class MI {
        public int value;

        MI() {
        }
    }
}

