/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.old;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.facet.old.OldFacetsAccumulator;
import org.apache.lucene.facet.old.ScoredDocIDs;
import org.apache.lucene.facet.params.FacetSearchParams;
import org.apache.lucene.facet.sampling.RandomSampler;
import org.apache.lucene.facet.sampling.Sampler;
import org.apache.lucene.facet.sampling.SamplingAccumulator;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.FacetResult;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.IndexReader;

public final class AdaptiveFacetsAccumulator
extends OldFacetsAccumulator {
    private Sampler sampler = new RandomSampler();

    public AdaptiveFacetsAccumulator(FacetSearchParams searchParams, IndexReader indexReader, TaxonomyReader taxonomyReader) {
        super(searchParams, indexReader, taxonomyReader);
    }

    public AdaptiveFacetsAccumulator(FacetSearchParams searchParams, IndexReader indexReader, TaxonomyReader taxonomyReader, FacetArrays facetArrays) {
        super(searchParams, indexReader, taxonomyReader, facetArrays);
    }

    public void setSampler(Sampler sampler) {
        this.sampler = sampler;
    }

    @Override
    public List<FacetResult> accumulate(ScoredDocIDs docids) throws IOException {
        OldFacetsAccumulator delegee = this.appropriateFacetCountingAccumulator(docids);
        if (delegee == this) {
            return super.accumulate(docids);
        }
        return delegee.accumulate(docids);
    }

    private OldFacetsAccumulator appropriateFacetCountingAccumulator(ScoredDocIDs docids) {
        if (!this.mayComplement()) {
            return this;
        }
        if (this.sampler == null || !this.sampler.shouldSample(docids)) {
            return this;
        }
        SamplingAccumulator samplingAccumulator = new SamplingAccumulator(this.sampler, this.searchParams, this.indexReader, this.taxonomyReader);
        samplingAccumulator.setComplementThreshold(this.getComplementThreshold());
        return samplingAccumulator;
    }

    public final Sampler getSampler() {
        return this.sampler;
    }
}

