/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.util.Version;

public class NewCollationAnalyzerTask
extends PerfTask {
    private Implementation impl = Implementation.JDK;

    public NewCollationAnalyzerTask(PerfRunData runData) {
        super(runData);
    }

    static Analyzer createAnalyzer(Locale locale, Implementation impl) throws Exception {
        Class<?> collatorClazz = Class.forName(impl.collatorClassName);
        Method collatorMethod = collatorClazz.getMethod("getInstance", Locale.class);
        Object collator = collatorMethod.invoke(null, locale);
        Class<Analyzer> clazz = Class.forName(impl.className).asSubclass(Analyzer.class);
        Constructor<Analyzer> ctor = clazz.getConstructor(Version.class, collatorClazz);
        return ctor.newInstance(new Object[]{Version.LUCENE_CURRENT, collator});
    }

    @Override
    public int doLogic() throws Exception {
        try {
            Locale locale = this.getRunData().getLocale();
            if (locale == null) {
                throw new RuntimeException("Locale must be set with the NewLocale task!");
            }
            Analyzer analyzer = NewCollationAnalyzerTask.createAnalyzer(locale, this.impl);
            this.getRunData().setAnalyzer(analyzer);
            System.out.println("Changed Analyzer to: " + analyzer.getClass().getName() + "(" + locale + ")");
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating Analyzer: impl=" + (Object)((Object)this.impl), e);
        }
        return 1;
    }

    @Override
    public void setParams(String params) {
        super.setParams(params);
        StringTokenizer st = new StringTokenizer(params, ",");
        while (st.hasMoreTokens()) {
            String param = st.nextToken();
            StringTokenizer expr = new StringTokenizer(param, ":");
            String key = expr.nextToken();
            String value = expr.nextToken();
            if (key.equals("impl")) {
                if (value.equalsIgnoreCase("icu")) {
                    this.impl = Implementation.ICU;
                    continue;
                }
                if (value.equalsIgnoreCase("jdk")) {
                    this.impl = Implementation.JDK;
                    continue;
                }
                throw new RuntimeException("Unknown parameter " + param);
            }
            throw new RuntimeException("Unknown parameter " + param);
        }
    }

    @Override
    public boolean supportsParams() {
        return true;
    }

    public static enum Implementation {
        JDK("org.apache.lucene.collation.CollationKeyAnalyzer", "java.text.Collator"),
        ICU("org.apache.lucene.collation.ICUCollationKeyAnalyzer", "com.ibm.icu.text.Collator");

        String className;
        String collatorClassName;

        private Implementation(String className, String collatorClassName) {
            this.className = className;
            this.collatorClassName = collatorClassName;
        }
    }
}

