/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.SearchTravTask;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DocumentStoredFieldVisitor;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.StoredFieldVisitor;

public class SearchTravRetLoadFieldSelectorTask
extends SearchTravTask {
    protected Set<String> fieldsToLoad;

    public SearchTravRetLoadFieldSelectorTask(PerfRunData runData) {
        super(runData);
    }

    @Override
    public boolean withRetrieve() {
        return true;
    }

    @Override
    protected Document retrieveDoc(IndexReader ir, int id) throws IOException {
        if (this.fieldsToLoad == null) {
            return ir.document(id);
        }
        DocumentStoredFieldVisitor visitor = new DocumentStoredFieldVisitor(this.fieldsToLoad);
        ir.document(id, (StoredFieldVisitor)visitor);
        return visitor.getDocument();
    }

    @Override
    public void setParams(String params) {
        this.params = params;
        this.fieldsToLoad = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(params, ",");
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            this.fieldsToLoad.add(s);
        }
    }

    @Override
    public boolean supportsParams() {
        return true;
    }
}

