/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.clustering;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.mahout.clustering.Cluster;
import org.apache.mahout.clustering.classify.WeightedPropertyVectorWritable;
import org.apache.mahout.clustering.iterator.ClusterWritable;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.math.NamedVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.utils.clustering.AbstractClusterWriter;

public class CSVClusterWriter
extends AbstractClusterWriter {
    private static final Pattern VEC_PATTERN = Pattern.compile("\\{|\\:|\\,|\\}");

    public CSVClusterWriter(Writer writer, Map<Integer, List<WeightedPropertyVectorWritable>> clusterIdToPoints, DistanceMeasure measure) {
        super(writer, clusterIdToPoints, measure);
    }

    @Override
    public void write(ClusterWritable clusterWritable) throws IOException {
        StringBuilder line = new StringBuilder();
        Cluster cluster = clusterWritable.getValue();
        line.append(cluster.getId());
        List<WeightedPropertyVectorWritable> points = this.getClusterIdToPoints().get(cluster.getId());
        if (points != null) {
            for (WeightedPropertyVectorWritable point : points) {
                Vector theVec = point.getVector();
                line.append(',');
                if (theVec instanceof NamedVector) {
                    line.append(((NamedVector)theVec).getName());
                    continue;
                }
                String vecStr = theVec.asFormatString();
                vecStr = VEC_PATTERN.matcher(vecStr).replaceAll("_");
                line.append(vecStr);
            }
            this.getWriter().append(line).append("\n");
        }
    }
}

