/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.text;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.cli2.Option;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.text.LuceneStorageConfiguration;
import org.apache.mahout.text.SequenceFilesFromLuceneStorage;
import org.apache.mahout.text.SequenceFilesFromLuceneStorageMRJob;

public class SequenceFilesFromLuceneStorageDriver
extends AbstractJob {
    static final String OPTION_ID_FIELD = "idField";
    static final String OPTION_FIELD = "fields";
    static final String OPTION_QUERY = "query";
    static final String OPTION_MAX_HITS = "maxHits";
    static final Query DEFAULT_QUERY = new MatchAllDocsQuery();
    static final int DEFAULT_MAX_HITS = Integer.MAX_VALUE;
    static final String SEPARATOR_FIELDS = ",";
    static final String QUERY_DELIMITER = "'";
    private static final Pattern COMPILE = Pattern.compile("'");

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new SequenceFilesFromLuceneStorageDriver(), (String[])args);
    }

    public int run(String[] args) throws Exception {
        this.addOutputOption();
        this.addInputOption();
        this.addOption(OPTION_ID_FIELD, "id", "The field in the index containing the id", true);
        this.addOption(OPTION_FIELD, "f", "The stored field(s) in the index containing text", true);
        this.addOption(OPTION_QUERY, "q", "(Optional) Lucene query. Defaults to " + DEFAULT_QUERY.getClass().getSimpleName());
        this.addOption(OPTION_MAX_HITS, "n", "(Optional) Max hits. Defaults to 2147483647");
        this.addOption((Option)DefaultOptionCreator.methodOption().create());
        if (this.parseArguments(args) == null) {
            return -1;
        }
        Configuration configuration = this.getConf();
        String[] paths = this.getInputPath().toString().split(SEPARATOR_FIELDS);
        ArrayList indexPaths = Lists.newArrayList();
        for (String path : paths) {
            indexPaths.add(new Path(path));
        }
        Path sequenceFilesOutputPath = this.getOutputPath();
        String idField = this.getOption(OPTION_ID_FIELD);
        String fields = this.getOption(OPTION_FIELD);
        LuceneStorageConfiguration lucene2SeqConf = this.newLucene2SeqConfiguration(configuration, indexPaths, sequenceFilesOutputPath, idField, Arrays.asList(fields.split(SEPARATOR_FIELDS)));
        Query query = DEFAULT_QUERY;
        if (this.hasOption(OPTION_QUERY)) {
            try {
                String queryString = COMPILE.matcher(this.getOption(OPTION_QUERY)).replaceAll("");
                QueryParser queryParser = new QueryParser(Version.LUCENE_46, queryString, (Analyzer)new StandardAnalyzer(Version.LUCENE_46));
                query = queryParser.parse(queryString);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        lucene2SeqConf.setQuery(query);
        int maxHits = Integer.MAX_VALUE;
        if (this.hasOption(OPTION_MAX_HITS)) {
            String maxHitsString = this.getOption(OPTION_MAX_HITS);
            maxHits = Integer.valueOf(maxHitsString);
        }
        lucene2SeqConf.setMaxHits(maxHits);
        if (this.hasOption("method") && this.getOption("method").equals("sequential")) {
            new SequenceFilesFromLuceneStorage().run(lucene2SeqConf);
        } else {
            new SequenceFilesFromLuceneStorageMRJob().run(lucene2SeqConf);
        }
        return 0;
    }

    public LuceneStorageConfiguration newLucene2SeqConfiguration(Configuration configuration, List<Path> indexPaths, Path sequenceFilesOutputPath, String idField, List<String> fields) {
        return new LuceneStorageConfiguration(configuration, indexPaths, sequenceFilesOutputPath, idField, fields);
    }
}

