/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import org.apache.lucene.facet.encoding.IntDecoder;
import org.apache.lucene.facet.search.CategoryListIterator;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;

public class DocValuesCategoryListIterator
implements CategoryListIterator {
    private final IntDecoder decoder;
    private final String field;
    private final int hashCode;
    private final BytesRef bytes = new BytesRef(32);
    private BinaryDocValues current;

    public DocValuesCategoryListIterator(String field, IntDecoder decoder) {
        this.field = field;
        this.decoder = decoder;
        this.hashCode = field.hashCode();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DocValuesCategoryListIterator)) {
            return false;
        }
        DocValuesCategoryListIterator other = (DocValuesCategoryListIterator)o;
        if (this.hashCode != other.hashCode) {
            return false;
        }
        return this.field.equals(other.field);
    }

    @Override
    public boolean setNextReader(AtomicReaderContext context) throws IOException {
        this.current = context.reader().getBinaryDocValues(this.field);
        return this.current != null;
    }

    @Override
    public void getOrdinals(int docID, IntsRef ints) throws IOException {
        assert (this.current != null) : "don't call this if setNextReader returned false";
        this.current.get(docID, this.bytes);
        ints.length = 0;
        if (this.bytes.length > 0) {
            this.decoder.decode(this.bytes, ints);
        }
    }

    public String toString() {
        return this.field;
    }
}

