/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.encoding;

import org.apache.lucene.facet.encoding.IntDecoder;
import org.apache.lucene.facet.encoding.IntEncoder;
import org.apache.lucene.facet.encoding.VInt8IntDecoder;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;

public final class VInt8IntEncoder
extends IntEncoder {
    @Override
    public void encode(IntsRef values, BytesRef buf) {
        buf.length = 0;
        buf.offset = 0;
        int maxBytesNeeded = 5 * values.length;
        if (buf.bytes.length < maxBytesNeeded) {
            buf.grow(maxBytesNeeded);
        }
        int upto = values.offset + values.length;
        for (int i = values.offset; i < upto; ++i) {
            int value = values.ints[i];
            if ((value & 0xFFFFFF80) == 0) {
                buf.bytes[buf.length] = (byte)value;
                ++buf.length;
                continue;
            }
            if ((value & 0xFFFFC000) == 0) {
                buf.bytes[buf.length] = (byte)(0x80 | (value & 0x3F80) >> 7);
                buf.bytes[buf.length + 1] = (byte)(value & 0x7F);
                buf.length += 2;
                continue;
            }
            if ((value & 0xFFE00000) == 0) {
                buf.bytes[buf.length] = (byte)(0x80 | (value & 0x1FC000) >> 14);
                buf.bytes[buf.length + 1] = (byte)(0x80 | (value & 0x3F80) >> 7);
                buf.bytes[buf.length + 2] = (byte)(value & 0x7F);
                buf.length += 3;
                continue;
            }
            if ((value & 0xF0000000) == 0) {
                buf.bytes[buf.length] = (byte)(0x80 | (value & 0xFE00000) >> 21);
                buf.bytes[buf.length + 1] = (byte)(0x80 | (value & 0x1FC000) >> 14);
                buf.bytes[buf.length + 2] = (byte)(0x80 | (value & 0x3F80) >> 7);
                buf.bytes[buf.length + 3] = (byte)(value & 0x7F);
                buf.length += 4;
                continue;
            }
            buf.bytes[buf.length] = (byte)(0x80 | (value & 0xF0000000) >> 28);
            buf.bytes[buf.length + 1] = (byte)(0x80 | (value & 0xFE00000) >> 21);
            buf.bytes[buf.length + 2] = (byte)(0x80 | (value & 0x1FC000) >> 14);
            buf.bytes[buf.length + 3] = (byte)(0x80 | (value & 0x3F80) >> 7);
            buf.bytes[buf.length + 4] = (byte)(value & 0x7F);
            buf.length += 5;
        }
    }

    @Override
    public IntDecoder createMatchingDecoder() {
        return new VInt8IntDecoder();
    }

    public String toString() {
        return "VInt8";
    }
}

