/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer.common;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.math.NamedVector;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.function.Functions;

public class PartialVectorMergeReducer
extends Reducer<WritableComparable<?>, VectorWritable, WritableComparable<?>, VectorWritable> {
    private double normPower;
    private int dimension;
    private boolean sequentialAccess;
    private boolean namedVector;
    private boolean logNormalize;

    protected void reduce(WritableComparable<?> key, Iterable<VectorWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        RandomAccessSparseVector vector = new RandomAccessSparseVector(this.dimension, 10);
        for (VectorWritable value : values) {
            vector.assign(value.get(), Functions.PLUS);
        }
        if (this.normPower != -1.0) {
            vector = this.logNormalize ? vector.logNormalize(this.normPower) : vector.normalize(this.normPower);
        }
        if (this.sequentialAccess) {
            vector = new SequentialAccessSparseVector((Vector)vector);
        }
        if (this.namedVector) {
            vector = new NamedVector((Vector)vector, key.toString());
        }
        if (vector.getNumNondefaultElements() > 0) {
            VectorWritable vectorWritable = new VectorWritable((Vector)vector);
            context.write(key, (Object)vectorWritable);
        }
    }

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration conf = context.getConfiguration();
        this.normPower = conf.getFloat("normalization.power", -1.0f);
        this.dimension = conf.getInt("vector.dimension", Integer.MAX_VALUE);
        this.sequentialAccess = conf.getBoolean("vector.sequentialAccess", false);
        this.namedVector = conf.getBoolean("vector.named", false);
        this.logNormalize = conf.getBoolean("vector.lognormalize", false);
    }
}

