/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.stochasticsvd;

import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.text.NumberFormat;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.regex.Matcher;
import org.apache.commons.lang3.Validate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.IOUtils;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirIterator;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.hadoop.stochasticsvd.DenseBlockWritable;
import org.apache.mahout.math.hadoop.stochasticsvd.SSVDHelper;
import org.apache.mahout.math.hadoop.stochasticsvd.SplitPartitionedWritable;
import org.apache.mahout.math.hadoop.stochasticsvd.qr.QRFirstStep;

public final class ABtDenseOutJob {
    public static final String PROP_BT_PATH = "ssvd.Bt.path";
    public static final String PROP_BT_BROADCAST = "ssvd.Bt.broadcast";
    public static final String PROP_SB_PATH = "ssvdpca.sb.path";
    public static final String PROP_SQ_PATH = "ssvdpca.sq.path";
    public static final String PROP_XI_PATH = "ssvdpca.xi.path";

    private ABtDenseOutJob() {
    }

    public static void run(Configuration conf, Path[] inputAPaths, Path inputBtGlob, Path xiPath, Path sqPath, Path sbPath, Path outputPath, int aBlockRows, int minSplitSize, int k, int p, int outerProdBlockHeight, int numReduceTasks, boolean broadcastBInput) throws ClassNotFoundException, InterruptedException, IOException {
        JobConf oldApiJob = new JobConf(conf);
        Job job = new Job((Configuration)oldApiJob);
        job.setJobName("ABt-job");
        job.setJarByClass(ABtDenseOutJob.class);
        job.setInputFormatClass(SequenceFileInputFormat.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])inputAPaths);
        if (minSplitSize > 0) {
            FileInputFormat.setMinInputSplitSize((Job)job, (long)minSplitSize);
        }
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        SequenceFileOutputFormat.setOutputCompressionType((Job)job, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
        job.setMapOutputKeyClass(SplitPartitionedWritable.class);
        job.setMapOutputValueClass(DenseBlockWritable.class);
        job.setOutputKeyClass(SplitPartitionedWritable.class);
        job.setOutputValueClass(VectorWritable.class);
        job.setMapperClass(ABtMapper.class);
        job.setReducerClass(QRReducer.class);
        job.getConfiguration().setInt("ssvd.arowblock.size", aBlockRows);
        job.getConfiguration().setInt("ssvd.outerProdBlockHeight", outerProdBlockHeight);
        job.getConfiguration().setInt("ssvd.k", k);
        job.getConfiguration().setInt("ssvd.p", p);
        job.getConfiguration().set(PROP_BT_PATH, inputBtGlob.toString());
        if (xiPath != null) {
            job.getConfiguration().set(PROP_XI_PATH, xiPath.toString());
            job.getConfiguration().set(PROP_SB_PATH, sbPath.toString());
            job.getConfiguration().set(PROP_SQ_PATH, sqPath.toString());
        }
        job.setNumReduceTasks(numReduceTasks);
        if (broadcastBInput) {
            job.getConfiguration().set(PROP_BT_BROADCAST, "y");
            FileSystem fs = FileSystem.get((URI)inputBtGlob.toUri(), (Configuration)conf);
            FileStatus[] fstats = fs.globStatus(inputBtGlob);
            if (fstats != null) {
                for (FileStatus fstat : fstats) {
                    DistributedCache.addCacheFile((URI)fstat.getPath().toUri(), (Configuration)job.getConfiguration());
                }
            }
        }
        job.submit();
        job.waitForCompletion(false);
        if (!job.isSuccessful()) {
            throw new IOException("ABt job unsuccessful.");
        }
    }

    public static class QRReducer
    extends Reducer<SplitPartitionedWritable, DenseBlockWritable, SplitPartitionedWritable, VectorWritable> {
        private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();
        private final Deque<Closeable> closeables = Lists.newLinkedList();
        protected int blockHeight;
        protected int accumSize;
        protected int lastTaskId = -1;
        protected OutputCollector<Writable, DenseBlockWritable> qhatCollector;
        protected OutputCollector<Writable, VectorWritable> rhatCollector;
        protected QRFirstStep qr;
        protected Vector yiRow;
        protected Vector sb;

        protected void setup(Reducer.Context context) throws IOException, InterruptedException {
            Configuration conf = context.getConfiguration();
            this.blockHeight = conf.getInt("ssvd.outerProdBlockHeight", -1);
            String sbPathStr = conf.get(ABtDenseOutJob.PROP_SB_PATH);
            if (sbPathStr != null) {
                this.sb = SSVDHelper.loadAndSumUpVectors(new Path(sbPathStr), conf);
            }
        }

        protected void setupBlock(Reducer.Context context, SplitPartitionedWritable spw) throws InterruptedException, IOException {
            IOUtils.close(this.closeables);
            this.qhatCollector = this.createOutputCollector("QHat", spw, context, DenseBlockWritable.class);
            this.rhatCollector = this.createOutputCollector("R", spw, context, VectorWritable.class);
            this.qr = new QRFirstStep(context.getConfiguration(), this.qhatCollector, this.rhatCollector);
            this.closeables.addFirst(this.qr);
            this.lastTaskId = spw.getTaskId();
        }

        protected void reduce(SplitPartitionedWritable key, Iterable<DenseBlockWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            if (key.getTaskId() != this.lastTaskId) {
                this.setupBlock(context, key);
            }
            Iterator<DenseBlockWritable> iter = values.iterator();
            DenseBlockWritable dbw = iter.next();
            double[][] yiCols = dbw.getBlock();
            if (iter.hasNext()) {
                throw new IOException("Unexpected extra Y_i block in reducer input.");
            }
            long blockBase = key.getTaskItemOrdinal() * (long)this.blockHeight;
            int bh = yiCols[0].length;
            if (this.yiRow == null) {
                this.yiRow = new DenseVector(yiCols.length);
            }
            for (int k = 0; k < bh; ++k) {
                for (int j = 0; j < yiCols.length; ++j) {
                    this.yiRow.setQuick(j, yiCols[j][k]);
                }
                key.setTaskItemOrdinal(blockBase + (long)k);
                if (this.sb != null) {
                    this.yiRow.assign(this.sb, Functions.MINUS);
                }
                this.qr.collect((Writable)key, this.yiRow);
            }
        }

        private Path getSplitFilePath(String name, SplitPartitionedWritable spw, Reducer.Context context) throws InterruptedException, IOException {
            String uniqueFileName = FileOutputFormat.getUniqueFile((TaskAttemptContext)context, (String)name, (String)"");
            uniqueFileName = uniqueFileName.replaceFirst("-r-", "-m-");
            uniqueFileName = uniqueFileName.replaceFirst("\\d+$", Matcher.quoteReplacement(NUMBER_FORMAT.format(spw.getTaskId())));
            return new Path(FileOutputFormat.getWorkOutputPath((TaskInputOutputContext)context), uniqueFileName);
        }

        private <K, V> OutputCollector<K, V> createOutputCollector(String name, final SplitPartitionedWritable spw, Reducer.Context ctx, Class<V> valueClass) throws IOException, InterruptedException {
            Path outputPath = this.getSplitFilePath(name, spw, ctx);
            final SequenceFile.Writer w = SequenceFile.createWriter((FileSystem)FileSystem.get((URI)outputPath.toUri(), (Configuration)ctx.getConfiguration()), (Configuration)ctx.getConfiguration(), (Path)outputPath, SplitPartitionedWritable.class, valueClass);
            this.closeables.addFirst((Closeable)w);
            return new OutputCollector<K, V>(){

                public void collect(K key, V val) throws IOException {
                    w.append((Object)spw, val);
                }
            };
        }

        protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
            IOUtils.close(this.closeables);
        }

        static {
            NUMBER_FORMAT.setMinimumIntegerDigits(5);
            NUMBER_FORMAT.setGroupingUsed(false);
        }
    }

    public static class ABtMapper
    extends Mapper<Writable, VectorWritable, SplitPartitionedWritable, DenseBlockWritable> {
        private SplitPartitionedWritable outKey;
        private final Deque<Closeable> closeables = new ArrayDeque<Closeable>();
        private SequenceFileDirIterator<IntWritable, VectorWritable> btInput;
        private Vector[] aCols;
        private double[][] yiCols;
        private int aRowCount;
        private int kp;
        private int blockHeight;
        private boolean distributedBt;
        private Path[] btLocalPath;
        private Configuration localFsConfig;
        protected Vector xi;
        protected Vector sq;

        protected void map(Writable key, VectorWritable value, Mapper.Context context) throws IOException, InterruptedException {
            Vector vec = value.get();
            int vecSize = vec.size();
            if (this.aCols == null) {
                this.aCols = new Vector[vecSize];
            } else if (this.aCols.length < vecSize) {
                this.aCols = Arrays.copyOf(this.aCols, vecSize);
            }
            if (vec.isDense()) {
                for (int i = 0; i < vecSize; ++i) {
                    this.extendAColIfNeeded(i, this.aRowCount + 1);
                    this.aCols[i].setQuick(this.aRowCount, vec.getQuick(i));
                }
            } else if (vec.size() > 0) {
                for (Vector.Element vecEl : vec.nonZeroes()) {
                    int i = vecEl.index();
                    this.extendAColIfNeeded(i, this.aRowCount + 1);
                    this.aCols[i].setQuick(this.aRowCount, vecEl.get());
                }
            }
            ++this.aRowCount;
        }

        private void extendAColIfNeeded(int col, int rowCount) {
            if (this.aCols[col] == null) {
                this.aCols[col] = new SequentialAccessSparseVector(rowCount < this.blockHeight ? this.blockHeight : rowCount, 1);
            } else if (this.aCols[col].size() < rowCount) {
                SequentialAccessSparseVector newVec = new SequentialAccessSparseVector(rowCount + this.blockHeight, this.aCols[col].getNumNondefaultElements() << 1);
                newVec.viewPart(0, this.aCols[col].size()).assign(this.aCols[col]);
                this.aCols[col] = newVec;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            try {
                this.yiCols = new double[this.kp][];
                for (int i = 0; i < this.kp; ++i) {
                    this.yiCols[i] = new double[Math.min(this.aRowCount, this.blockHeight)];
                }
                int numPasses = (this.aRowCount - 1) / this.blockHeight + 1;
                String propBtPathStr = context.getConfiguration().get(ABtDenseOutJob.PROP_BT_PATH);
                Validate.notNull((Object)propBtPathStr, (String)"Bt input is not set", (Object[])new Object[0]);
                Path btPath = new Path(propBtPathStr);
                DenseBlockWritable dbw = new DenseBlockWritable();
                int lastRowIndex = -1;
                for (int pass = 0; pass < numPasses; ++pass) {
                    this.btInput = this.distributedBt ? new SequenceFileDirIterator(this.btLocalPath, true, this.localFsConfig) : new SequenceFileDirIterator(btPath, PathType.GLOB, null, null, true, context.getConfiguration());
                    this.closeables.addFirst(this.btInput);
                    Validate.isTrue((boolean)this.btInput.hasNext(), (String)"Empty B' input!", (Object[])new Object[0]);
                    int aRowBegin = pass * this.blockHeight;
                    int bh = Math.min(this.blockHeight, this.aRowCount - aRowBegin);
                    if (pass > 0) {
                        int i;
                        if (bh == this.blockHeight) {
                            for (i = 0; i < this.kp; ++i) {
                                Arrays.fill(this.yiCols[i], 0.0);
                            }
                        } else {
                            for (i = 0; i < this.kp; ++i) {
                                this.yiCols[i] = null;
                            }
                            for (i = 0; i < this.kp; ++i) {
                                this.yiCols[i] = new double[bh];
                            }
                        }
                    }
                    while (this.btInput.hasNext()) {
                        Vector aCol;
                        Pair btRec = (Pair)this.btInput.next();
                        int btIndex = ((IntWritable)btRec.getFirst()).get();
                        Vector btVec = ((VectorWritable)((Object)btRec.getSecond())).get();
                        if (btIndex > this.aCols.length || (aCol = this.aCols[btIndex]) == null || aCol.size() == 0) continue;
                        int j = -1;
                        for (Vector.Element aEl : aCol.nonZeroes()) {
                            int s;
                            j = aEl.index();
                            if (j < aRowBegin) continue;
                            if (j >= aRowBegin + bh) break;
                            if (this.xi != null) {
                                for (s = 0; s < this.kp; ++s) {
                                    double xii = this.xi.size() > btIndex ? this.xi.get(btIndex) : 0.0;
                                    double[] dArray = this.yiCols[s];
                                    int n = j - aRowBegin;
                                    dArray[n] = dArray[n] + aEl.get() * (btVec.getQuick(s) - xii * this.sq.get(s));
                                }
                                continue;
                            }
                            for (s = 0; s < this.kp; ++s) {
                                double[] dArray = this.yiCols[s];
                                int n = j - aRowBegin;
                                dArray[n] = dArray[n] + aEl.get() * btVec.getQuick(s);
                            }
                        }
                        if (lastRowIndex >= j) continue;
                        lastRowIndex = j;
                    }
                    dbw.setBlock(this.yiCols);
                    this.outKey.setTaskItemOrdinal(pass);
                    context.write((Object)this.outKey, (Object)dbw);
                    this.closeables.remove(this.btInput);
                    this.btInput.close();
                }
            }
            finally {
                IOUtils.close(this.closeables);
            }
        }

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            String xiPathStr;
            Configuration conf = context.getConfiguration();
            int k = Integer.parseInt(conf.get("ssvd.k"));
            int p = Integer.parseInt(conf.get("ssvd.p"));
            this.kp = k + p;
            this.outKey = new SplitPartitionedWritable(context);
            this.blockHeight = conf.getInt("ssvd.outerProdBlockHeight", -1);
            boolean bl = this.distributedBt = conf.get(ABtDenseOutJob.PROP_BT_BROADCAST) != null;
            if (this.distributedBt) {
                this.btLocalPath = HadoopUtil.getCachedFiles(conf);
                this.localFsConfig = new Configuration();
                this.localFsConfig.set("fs.default.name", "file:///");
            }
            if ((xiPathStr = conf.get(ABtDenseOutJob.PROP_XI_PATH)) != null) {
                this.xi = SSVDHelper.loadAndSumUpVectors(new Path(xiPathStr), conf);
                this.sq = SSVDHelper.loadAndSumUpVectors(new Path(conf.get(ABtDenseOutJob.PROP_SQ_PATH)), conf);
            }
        }
    }
}

