/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.fpm.pfpgrowth.convertors.string;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.common.Pair;

public final class TopKStringPatterns
implements Writable {
    private final List<Pair<List<String>, Long>> frequentPatterns = Lists.newArrayList();

    public TopKStringPatterns() {
    }

    public TopKStringPatterns(Collection<Pair<List<String>, Long>> patterns) {
        this.frequentPatterns.addAll(patterns);
    }

    public Iterator<Pair<List<String>, Long>> iterator() {
        return this.frequentPatterns.iterator();
    }

    public List<Pair<List<String>, Long>> getPatterns() {
        return this.frequentPatterns;
    }

    public TopKStringPatterns merge(TopKStringPatterns pattern, int heapSize) {
        ArrayList patterns = Lists.newArrayList();
        Iterator<Pair<List<String>, Long>> myIterator = this.frequentPatterns.iterator();
        Iterator<Pair<List<String>, Long>> otherIterator = pattern.iterator();
        Pair<List<String>, Long> myItem = null;
        Pair<List<String>, Long> otherItem = null;
        for (int i = 0; i < heapSize; ++i) {
            if (myItem == null && myIterator.hasNext()) {
                myItem = myIterator.next();
            }
            if (otherItem == null && otherIterator.hasNext()) {
                otherItem = otherIterator.next();
            }
            if (myItem != null && otherItem != null) {
                int cmp = myItem.getSecond().compareTo(otherItem.getSecond());
                if (cmp == 0 && (cmp = myItem.getFirst().size() - otherItem.getFirst().size()) == 0) {
                    for (int j = 0; j < myItem.getFirst().size() && (cmp = myItem.getFirst().get(j).compareTo(otherItem.getFirst().get(j))) == 0; ++j) {
                    }
                }
                if (cmp <= 0) {
                    patterns.add(otherItem);
                    if (cmp == 0) {
                        myItem = null;
                    }
                    otherItem = null;
                    continue;
                }
                if (cmp <= 0) continue;
                patterns.add(myItem);
                myItem = null;
                continue;
            }
            if (myItem != null) {
                patterns.add(myItem);
                myItem = null;
                continue;
            }
            if (otherItem == null) break;
            patterns.add(otherItem);
            otherItem = null;
        }
        return new TopKStringPatterns(patterns);
    }

    public void readFields(DataInput in) throws IOException {
        this.frequentPatterns.clear();
        int length = in.readInt();
        for (int i = 0; i < length; ++i) {
            ArrayList items = Lists.newArrayList();
            int itemsetLength = in.readInt();
            long support = in.readLong();
            for (int j = 0; j < itemsetLength; ++j) {
                items.add(in.readUTF());
            }
            this.frequentPatterns.add(new Pair<ArrayList, Long>(items, support));
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.frequentPatterns.size());
        for (Pair<List<String>, Long> pattern : this.frequentPatterns) {
            out.writeInt(pattern.getFirst().size());
            out.writeLong(pattern.getSecond());
            for (String item : pattern.getFirst()) {
                out.writeUTF(item);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (Pair<List<String>, Long> pattern : this.frequentPatterns) {
            sb.append(sep);
            sb.append(pattern.toString());
            sep = ", ";
        }
        return sb.toString();
    }
}

