/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.ep;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.classifier.sgd.PolymorphicWritable;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.ep.Mapping;
import org.apache.mahout.ep.Payload;

public class State<T extends Payload<U>, U>
implements Comparable<State<T, U>>,
Writable {
    private static final AtomicInteger OBJECT_COUNT = new AtomicInteger();
    private int id = OBJECT_COUNT.getAndIncrement();
    private Random gen = RandomUtils.getRandom();
    private double[] params;
    private Mapping[] maps;
    private double omni;
    private double[] step;
    private double value;
    private T payload;

    public State() {
    }

    public State(double[] x0, double omni) {
        this.params = Arrays.copyOf(x0, x0.length);
        this.omni = omni;
        this.step = new double[this.params.length];
        this.maps = new Mapping[this.params.length];
    }

    public State<T, U> copy() {
        State<T, U> r = new State<T, U>();
        r.params = Arrays.copyOf(this.params, this.params.length);
        r.omni = this.omni;
        r.step = Arrays.copyOf(this.step, this.step.length);
        r.maps = Arrays.copyOf(this.maps, this.maps.length);
        if (this.payload != null) {
            r.payload = this.payload.copy();
        }
        r.gen = this.gen;
        return r;
    }

    public State<T, U> mutate() {
        double sum = 0.0;
        for (double v : this.step) {
            sum += v * v;
        }
        sum = Math.sqrt(sum);
        double lambda = 1.0 + this.gen.nextGaussian();
        State<T, U> r = this.copy();
        double magnitude = 0.9 * this.omni + sum / 10.0;
        r.omni = magnitude * -Math.log1p(-this.gen.nextDouble());
        for (int i = 0; i < this.step.length; ++i) {
            r.step[i] = lambda * this.step[i] + r.omni * this.gen.nextGaussian();
            int n = i;
            r.params[n] = r.params[n] + r.step[i];
        }
        if (this.payload != null) {
            r.payload.update(r.getMappedParams());
        }
        return r;
    }

    public void setMap(int i, Mapping m) {
        this.maps[i] = m;
    }

    public double get(int i) {
        Mapping m = this.maps[i];
        return m == null ? this.params[i] : m.apply(this.params[i]);
    }

    public int getId() {
        return this.id;
    }

    public double[] getParams() {
        return this.params;
    }

    public Mapping[] getMaps() {
        return this.maps;
    }

    public double[] getMappedParams() {
        double[] r = Arrays.copyOf(this.params, this.params.length);
        for (int i = 0; i < this.params.length; ++i) {
            r[i] = this.get(i);
        }
        return r;
    }

    public double getOmni() {
        return this.omni;
    }

    public double[] getStep() {
        return this.step;
    }

    public T getPayload() {
        return this.payload;
    }

    public double getValue() {
        return this.value;
    }

    public void setOmni(double omni) {
        this.omni = omni;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setStep(double[] step) {
        this.step = step;
    }

    public void setMaps(Mapping[] maps) {
        this.maps = maps;
    }

    public void setMaps(Iterable<Mapping> maps) {
        ArrayList list = Lists.newArrayList(maps);
        this.maps = list.toArray(new Mapping[list.size()]);
    }

    public void setValue(double v) {
        this.value = v;
    }

    public void setPayload(T payload) {
        this.payload = payload;
    }

    public boolean equals(Object o) {
        if (!(o instanceof State)) {
            return false;
        }
        State other = (State)o;
        return this.id == other.id && this.value == other.value;
    }

    public int hashCode() {
        return RandomUtils.hashDouble((double)this.value) ^ this.id;
    }

    @Override
    public int compareTo(State<T, U> other) {
        int r = Double.compare(other.value, this.value);
        if (r != 0) {
            return r;
        }
        if (this.id < other.id) {
            return -1;
        }
        if (this.id > other.id) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        double sum = 0.0;
        for (double v : this.step) {
            sum += v * v;
        }
        return String.format(Locale.ENGLISH, "<S/%s %.3f %.3f>", this.payload, this.omni + Math.sqrt(sum), this.value);
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.id);
        out.writeInt(this.params.length);
        for (double v : this.params) {
            out.writeDouble(v);
        }
        for (Mapping map : this.maps) {
            PolymorphicWritable.write(out, map);
        }
        out.writeDouble(this.omni);
        for (double v : this.step) {
            out.writeDouble(v);
        }
        out.writeDouble(this.value);
        PolymorphicWritable.write(out, this.payload);
    }

    public void readFields(DataInput input) throws IOException {
        int i;
        this.id = input.readInt();
        int n = input.readInt();
        this.params = new double[n];
        for (i = 0; i < n; ++i) {
            this.params[i] = input.readDouble();
        }
        this.maps = new Mapping[n];
        for (i = 0; i < n; ++i) {
            this.maps[i] = PolymorphicWritable.read(input, Mapping.class);
        }
        this.omni = input.readDouble();
        this.step = new double[n];
        for (i = 0; i < n; ++i) {
            this.step[i] = input.readDouble();
        }
        this.value = input.readDouble();
        this.payload = PolymorphicWritable.read(input, Payload.class);
    }
}

