/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.distance.EuclideanDistanceMeasure;
import org.apache.mahout.math.Centroid;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.WeightedVector;
import org.apache.mahout.math.neighborhood.BruteSearch;
import org.apache.mahout.math.neighborhood.ProjectionSearch;
import org.apache.mahout.math.neighborhood.Searcher;
import org.apache.mahout.math.random.WeightedThing;
import org.apache.mahout.math.stats.OnlineSummarizer;

public final class ClusteringUtils {
    private ClusteringUtils() {
    }

    public static List<OnlineSummarizer> summarizeClusterDistances(Iterable<? extends Vector> datapoints, Iterable<? extends Vector> centroids, DistanceMeasure distanceMeasure) {
        ProjectionSearch searcher = new ProjectionSearch(distanceMeasure, 3, 1);
        searcher.addAll(centroids);
        ArrayList summarizers = Lists.newArrayList();
        if (((Searcher)searcher).size() == 0) {
            return summarizers;
        }
        for (int i = 0; i < ((Searcher)searcher).size(); ++i) {
            summarizers.add(new OnlineSummarizer());
        }
        for (Vector vector : datapoints) {
            Centroid closest = (Centroid)((Searcher)searcher).search(vector, 1).get(0).getValue();
            OnlineSummarizer summarizer = (OnlineSummarizer)summarizers.get(closest.getIndex());
            summarizer.add(distanceMeasure.distance(vector, (Vector)closest));
        }
        return summarizers;
    }

    public static double totalClusterCost(Iterable<? extends Vector> datapoints, Iterable<? extends Vector> centroids) {
        EuclideanDistanceMeasure distanceMeasure = new EuclideanDistanceMeasure();
        ProjectionSearch searcher = new ProjectionSearch(distanceMeasure, 3, 1);
        searcher.addAll(centroids);
        return ClusteringUtils.totalClusterCost(datapoints, searcher);
    }

    public static double totalClusterCost(Iterable<? extends Vector> datapoints, Searcher centroids) {
        double totalCost = 0.0;
        for (Vector vector : datapoints) {
            totalCost += centroids.searchFirst(vector, false).getWeight();
        }
        return totalCost;
    }

    public static double estimateDistanceCutoff(List<? extends Vector> data, DistanceMeasure distanceMeasure) {
        BruteSearch searcher = new BruteSearch(distanceMeasure);
        searcher.addAll(data);
        double minDistance = Double.POSITIVE_INFINITY;
        for (Vector vector : data) {
            double closest = searcher.searchFirst(vector, true).getWeight();
            if (minDistance > 0.0 && closest < minDistance) {
                minDistance = closest;
            }
            searcher.add(vector);
        }
        return minDistance;
    }

    public static double estimateDistanceCutoff(Iterable<? extends Vector> data, DistanceMeasure distanceMeasure, int sampleLimit) {
        return ClusteringUtils.estimateDistanceCutoff(Lists.newArrayList((Iterable)Iterables.limit(data, (int)sampleLimit)), distanceMeasure);
    }

    public static double daviesBouldinIndex(List<? extends Vector> centroids, DistanceMeasure distanceMeasure, List<OnlineSummarizer> clusterDistanceSummaries) {
        Preconditions.checkArgument((centroids.size() == clusterDistanceSummaries.size() ? 1 : 0) != 0, (Object)"Number of centroids and cluster summaries differ.");
        int n = centroids.size();
        double totalDBIndex = 0.0;
        for (int i = 0; i < n; ++i) {
            double averageDistanceI = clusterDistanceSummaries.get(i).getMean();
            double maxDBIndex = 0.0;
            for (int j = 0; j < n; ++j) {
                double dbIndex;
                if (i == j || !((dbIndex = (averageDistanceI + clusterDistanceSummaries.get(j).getMean()) / distanceMeasure.distance(centroids.get(i), centroids.get(j))) > maxDBIndex)) continue;
                maxDBIndex = dbIndex;
            }
            totalDBIndex += maxDBIndex;
        }
        return totalDBIndex / (double)n;
    }

    public static double dunnIndex(List<? extends Vector> centroids, DistanceMeasure distanceMeasure, List<OnlineSummarizer> clusterDistanceSummaries) {
        Preconditions.checkArgument((centroids.size() == clusterDistanceSummaries.size() ? 1 : 0) != 0, (Object)"Number of centroids and cluster summaries differ.");
        int n = centroids.size();
        double maxIntraClusterDistance = 0.0;
        for (OnlineSummarizer summarizer : clusterDistanceSummaries) {
            double intraClusterDistance;
            if (summarizer.getCount() <= 0 || !(maxIntraClusterDistance < (intraClusterDistance = summarizer.getCount() == 1 ? summarizer.getMean() : summarizer.getMedian()))) continue;
            maxIntraClusterDistance = intraClusterDistance;
        }
        double minDunnIndex = Double.POSITIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                double dunnIndex = distanceMeasure.distance(centroids.get(i), centroids.get(j));
                if (!(minDunnIndex > dunnIndex)) continue;
                minDunnIndex = dunnIndex;
            }
        }
        return minDunnIndex / maxIntraClusterDistance;
    }

    public static double choose2(double n) {
        return n * (n - 1.0) / 2.0;
    }

    public static Matrix getConfusionMatrix(List<? extends Vector> rowCentroids, List<? extends Vector> columnCentroids, Iterable<? extends Vector> datapoints, DistanceMeasure distanceMeasure) {
        BruteSearch rowSearcher = new BruteSearch(distanceMeasure);
        rowSearcher.addAll(rowCentroids);
        BruteSearch columnSearcher = new BruteSearch(distanceMeasure);
        columnSearcher.addAll(columnCentroids);
        int numRows = rowCentroids.size();
        int numCols = columnCentroids.size();
        DenseMatrix confusionMatrix = new DenseMatrix(numRows, numCols);
        for (Vector vector : datapoints) {
            WeightedThing<Vector> closestRowCentroid = ((Searcher)rowSearcher).search(vector, 1).get(0);
            WeightedThing<Vector> closestColumnCentroid = ((Searcher)columnSearcher).search(vector, 1).get(0);
            int row = ((Centroid)closestRowCentroid.getValue()).getIndex();
            int column = ((Centroid)closestColumnCentroid.getValue()).getIndex();
            double vectorWeight = vector instanceof WeightedVector ? ((WeightedVector)vector).getWeight() : 1.0;
            confusionMatrix.set(row, column, confusionMatrix.get(row, column) + vectorWeight);
        }
        return confusionMatrix;
    }

    public static double getAdjustedRandIndex(Matrix confusionMatrix) {
        int numRows = confusionMatrix.numRows();
        int numCols = confusionMatrix.numCols();
        double rowChoiceSum = 0.0;
        double columnChoiceSum = 0.0;
        double totalChoiceSum = 0.0;
        double total = 0.0;
        for (int i = 0; i < numRows; ++i) {
            double rowSum = 0.0;
            for (int j = 0; j < numCols; ++j) {
                rowSum += confusionMatrix.get(i, j);
                totalChoiceSum += ClusteringUtils.choose2(confusionMatrix.get(i, j));
            }
            total += rowSum;
            rowChoiceSum += ClusteringUtils.choose2(rowSum);
        }
        for (int j = 0; j < numCols; ++j) {
            double columnSum = 0.0;
            for (int i = 0; i < numRows; ++i) {
                columnSum += confusionMatrix.get(i, j);
            }
            columnChoiceSum += ClusteringUtils.choose2(columnSum);
        }
        double rowColumnChoiceSumDivTotal = rowChoiceSum * columnChoiceSum / ClusteringUtils.choose2(total);
        return (totalChoiceSum - rowColumnChoiceSumDivTotal) / ((rowChoiceSum + columnChoiceSum) / 2.0 - rowColumnChoiceSumDivTotal);
    }

    public static double totalWeight(Iterable<? extends Vector> data) {
        double sum = 0.0;
        for (Vector vector : data) {
            Preconditions.checkNotNull((Object)vector);
            if (vector instanceof WeightedVector) {
                sum += ((WeightedVector)vector).getWeight();
                continue;
            }
            sum += 1.0;
        }
        return sum;
    }
}

