/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.naivebayes;

import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.SparseRowMatrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class NaiveBayesModel {
    private final Vector weightsPerLabel;
    private final Vector perlabelThetaNormalizer;
    private final Vector weightsPerFeature;
    private final Matrix weightsPerLabelAndFeature;
    private final float alphaI;
    private final double numFeatures;
    private final double totalWeightSum;

    public NaiveBayesModel(Matrix weightMatrix, Vector weightsPerFeature, Vector weightsPerLabel, Vector thetaNormalizer, float alphaI) {
        this.weightsPerLabelAndFeature = weightMatrix;
        this.weightsPerFeature = weightsPerFeature;
        this.weightsPerLabel = weightsPerLabel;
        this.perlabelThetaNormalizer = thetaNormalizer;
        this.numFeatures = weightsPerFeature.getNumNondefaultElements();
        this.totalWeightSum = weightsPerLabel.zSum();
        this.alphaI = alphaI;
    }

    public double labelWeight(int label) {
        return this.weightsPerLabel.getQuick(label);
    }

    public double featureWeight(int feature) {
        return this.weightsPerFeature.getQuick(feature);
    }

    public double weight(int label, int feature) {
        return this.weightsPerLabelAndFeature.getQuick(label, feature);
    }

    public float alphaI() {
        return this.alphaI;
    }

    public double numFeatures() {
        return this.numFeatures;
    }

    public double totalWeightSum() {
        return this.totalWeightSum;
    }

    public int numLabels() {
        return this.weightsPerLabel.size();
    }

    public Vector createScoringVector() {
        return this.weightsPerLabel.like();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NaiveBayesModel materialize(Path output, Configuration conf) throws IOException {
        SparseRowMatrix weightsPerLabelAndFeature;
        float alphaI;
        FileSystem fs = output.getFileSystem(conf);
        DenseVector weightsPerLabel = null;
        DenseVector perLabelThetaNormalizer = null;
        Vector weightsPerFeature = null;
        FSDataInputStream in = fs.open(new Path(output, "naiveBayesModel.bin"));
        try {
            alphaI = in.readFloat();
            weightsPerFeature = VectorWritable.readVector((DataInput)in);
            weightsPerLabel = new DenseVector(VectorWritable.readVector((DataInput)in));
            perLabelThetaNormalizer = new DenseVector(VectorWritable.readVector((DataInput)in));
            weightsPerLabelAndFeature = new SparseRowMatrix(weightsPerLabel.size(), weightsPerFeature.size());
            for (int label = 0; label < weightsPerLabelAndFeature.numRows(); ++label) {
                weightsPerLabelAndFeature.assignRow(label, VectorWritable.readVector((DataInput)in));
            }
        }
        finally {
            Closeables.close((Closeable)in, (boolean)true);
        }
        NaiveBayesModel model = new NaiveBayesModel((Matrix)weightsPerLabelAndFeature, weightsPerFeature, (Vector)weightsPerLabel, (Vector)perLabelThetaNormalizer, alphaI);
        model.validate();
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(Path output, Configuration conf) throws IOException {
        FileSystem fs = output.getFileSystem(conf);
        FSDataOutputStream out = fs.create(new Path(output, "naiveBayesModel.bin"));
        try {
            out.writeFloat(this.alphaI);
            VectorWritable.writeVector((DataOutput)out, this.weightsPerFeature);
            VectorWritable.writeVector((DataOutput)out, this.weightsPerLabel);
            VectorWritable.writeVector((DataOutput)out, this.perlabelThetaNormalizer);
            for (int row = 0; row < this.weightsPerLabelAndFeature.numRows(); ++row) {
                VectorWritable.writeVector((DataOutput)out, this.weightsPerLabelAndFeature.viewRow(row));
            }
        }
        finally {
            Closeables.close((Closeable)out, (boolean)false);
        }
    }

    public void validate() {
        Preconditions.checkState((this.alphaI > 0.0f ? 1 : 0) != 0, (Object)"alphaI has to be greater than 0!");
        Preconditions.checkArgument((this.numFeatures > 0.0 ? 1 : 0) != 0, (Object)"the vocab count has to be greater than 0!");
        Preconditions.checkArgument((this.totalWeightSum > 0.0 ? 1 : 0) != 0, (Object)"the totalWeightSum has to be greater than 0!");
        Preconditions.checkNotNull((Object)this.weightsPerLabel, (Object)"the number of labels has to be defined!");
        Preconditions.checkArgument((this.weightsPerLabel.getNumNondefaultElements() > 0 ? 1 : 0) != 0, (Object)"the number of labels has to be greater than 0!");
        Preconditions.checkArgument((this.perlabelThetaNormalizer != null ? 1 : 0) != 0, (Object)"the theta normalizers have to be defined");
        Preconditions.checkNotNull((Object)this.weightsPerFeature, (Object)"the feature sums have to be defined");
        Preconditions.checkArgument((this.weightsPerFeature.getNumNondefaultElements() > 0 ? 1 : 0) != 0, (Object)"the feature sums have to be greater than 0!");
    }
}

