/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.df.data;

import com.google.common.base.Preconditions;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.mahout.classifier.df.data.Dataset;
import org.apache.mahout.classifier.df.data.Instance;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;

public class DataConverter {
    private static final Pattern COMMA_SPACE = Pattern.compile("[, ]");
    private final Dataset dataset;

    public DataConverter(Dataset dataset) {
        this.dataset = dataset;
    }

    public Instance convert(CharSequence string) {
        int nball = this.dataset.nbAttributes() + this.dataset.getIgnored().length;
        String[] tokens = COMMA_SPACE.split(string);
        Preconditions.checkArgument((tokens.length == nball ? 1 : 0) != 0, (Object)("Wrong number of attributes in the string: " + tokens.length + ". Must be " + nball));
        int nbattrs = this.dataset.nbAttributes();
        DenseVector vector = new DenseVector(nbattrs);
        int aId = 0;
        for (int attr = 0; attr < nball; ++attr) {
            if (ArrayUtils.contains((int[])this.dataset.getIgnored(), (int)attr)) continue;
            String token = tokens[attr].trim();
            if ("?".equals(token)) {
                return null;
            }
            if (this.dataset.isNumerical(aId)) {
                vector.set(aId++, Double.parseDouble(token));
                continue;
            }
            vector.set(aId, (double)this.dataset.valueOf(aId, token));
            ++aId;
        }
        return new Instance((Vector)vector);
    }
}

