/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.item;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.cf.taste.hadoop.TasteHadoopUtils;
import org.apache.mahout.cf.taste.hadoop.item.VectorAndPrefsWritable;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.VarIntWritable;
import org.apache.mahout.math.VarLongWritable;
import org.apache.mahout.math.Vector;

public class ItemFilterAsVectorAndPrefsReducer
extends Reducer<VarLongWritable, VarLongWritable, VarIntWritable, VectorAndPrefsWritable> {
    private final VarIntWritable itemIDIndexWritable = new VarIntWritable();
    private final VectorAndPrefsWritable vectorAndPrefs = new VectorAndPrefsWritable();

    protected void reduce(VarLongWritable itemID, Iterable<VarLongWritable> values, Reducer.Context ctx) throws IOException, InterruptedException {
        int itemIDIndex = TasteHadoopUtils.idToIndex(itemID.get());
        RandomAccessSparseVector vector = new RandomAccessSparseVector(Integer.MAX_VALUE, 1);
        vector.set(itemIDIndex, Double.NaN);
        ArrayList userIDs = Lists.newArrayList();
        ArrayList prefValues = Lists.newArrayList();
        for (VarLongWritable userID : values) {
            userIDs.add(userID.get());
            prefValues.add(Float.valueOf(1.0f));
        }
        this.itemIDIndexWritable.set(itemIDIndex);
        this.vectorAndPrefs.set((Vector)vector, userIDs, prefValues);
        ctx.write((Object)this.itemIDIndexWritable, (Object)this.vectorAndPrefs);
    }
}

