#!/bin/sh

MKDIRS="mkdir -p"
AUTODOC=/usr/local/bin/autodoc
AUTODOC_FLAGS="-copydocs -timestamp -allclasses"
AUTODOC_FORMAT=html
export AD_COPYRIGHT="Mac GPG Project"

# Expects one argument, the install path
if [ ! $# -eq 2 ] ; then \
    echo "Needs 2 args: action and path where to install documentation"
    echo "If action is clean, deletes path and its content"
    exit 1
fi

PUBLIC_DOC_INSTALLDIR=$2

# We need to write down file names here
AUTODOC_FILES="GPGContext.h GPGData.h GPGEngine.h GPGExceptions.h GPGKey.h GPGKeyGroup.h GPGKeySignature.h GPGObject.h GPGOptions/GPGOptions.h GPGPrettyInfo.h GPGSignature.h GPGSubkey.h GPGTrustItem.h GPGUserID.h"
AUTODOC_DOCDIR="$PUBLIC_DOC_INSTALLDIR"
OTHER_FILES="IntroGPGME.html"

OTHER_AUTODOC_FLAGS="-typedirs -allclasses -combine -force -nosingles"

ALL_AUTODOC_FLAGS="$AUTODOC_FLAGS $OTHER_AUTODOC_FLAGS"

if [ "$1" = "clean" ] ; then \
    rm -rf $PUBLIC_DOC_INSTALLDIR ; \
    exit 0
fi

# If autodoc is not installed, we quit without any error
if [ ! -x $AUTODOC ] ; then \
    echo "$AUTODOC not found. Documentation can not been generated."
    exit 0
fi

$MKDIRS $PUBLIC_DOC_INSTALLDIR
$AUTODOC $ALL_AUTODOC_FLAGS -format $AUTODOC_FORMAT -dest $AUTODOC_DOCDIR $AUTODOC_FILES

# Let's also install files which are not generated by autodoc
cp -pR $OTHER_FILES $PUBLIC_DOC_INSTALLDIR/
