require"lfs"

exit = os.exit
cd = function(...) if #{...} == 0 then return lfs.chdir(HOME) else return lfs.chdir(...) end end
run = function (cmd)
	local fd = io.popen(cmd)
	local out = fd:read("*a")
	fd:close()
	return out
      end

function getargs(sep, ...)
  local params = {...}
  local res = ""
  local first = true
  for k, v in pairs(params) do
    if not first then
      res = res .. sep
    end
    first = false
    res = res .. tostring(v)
  end
  return res
end

function runner(cmd)
  local r = { cmd = cmd, done = false }
  setmetatable(r, { __call = 	function(func, out)
				  func.done = true
				  if out == true then
				    return run(cmd)
				  else
				    os.execute(cmd)
				  end
				end,
		    __div =	function(a, b)
				  return runner(a.cmd .. "|" .. b.cmd)
				end,
		    __tostring= function(e)
				  return e(true)
				end})
  rawset(_G, "_last_runner", r)
  return r
end

setmetatable(_G, { __index = 	function (t, key)
				  local h = rawget(t, key)
				  if h ~= nil then
				    return h
				  end
				  if type(rawget(t,"__shadow")) == "table" then
				    h = rawget(rawget(t,"__shadow"), key)
				    if h ~= nil then
				      return h
				    end
				  end
				  h = os.getenv(key)
				  if h ~= nil then
				    return h
				  end
				  if os.execute("which " .. key .. " &> /dev/null") == 0 then
				    return  function(...)
					      if #{...} == 0 then
						return runner(key)
					      else
						return runner(key .. " " .. getargs(" ", ...))
					      end
					    end
				  end
				  return key
				end,
		  __newindex =	function(t, k, v)
				  if type(rawget(t,"__shadow")) ~= "table" then
				    rawset(t,"__shadow", {})
				  end
				  if type(v) == "table" and type(v.cmd) == "string" then
				    local val = v(true)
				    rawset(rawget(t,"__shadow"), k, val)
				  else
				    rawset(rawget(t,"__shadow"), k, v)
				  end
				end} )

function _get_table(results, key, t, pref)
  local pos = key:find("%.")
  if pos ~= nil then
    t = t[key:sub(1, pos - 1)]
    if type(t) == "table" then
      _get_table(results, key:sub(pos + 1, -1), t, pref .. key:sub(1, pos))
    end
  else
    for k, v in pairs(t) do
      if k:sub(1, #key) == key then
	if type(v) == "table" then
	  table.insert(results, pref .. k .. ".")
	elseif type(v) == "function" then
	  table.insert(results, pref .. k .. "()")
	else
	  table.insert(results, pref .. k)
	end
      end
    end
    if type(rawget(t, "__shadow")) == "table" then
      _get_table(results, key, rawget(t, "__shadow"), pref)
    end
  end
end

function _auto_complete(key)
  local results = {}
  local n = 0
  -- look for available commands in PATH
  for path in string.gmatch(os.getenv("PATH"), "[^:]+") do
    if path:find("/$") == nil then
      path = path .. "/"
    end
    local fd = io.popen("ls " .. path .. key .. "* 2> /dev/null")
    for l in fd:lines() do
      table.insert(results, l:sub(#path + 1,-1))
    end
    fd:close()
  end
  -- look for available functions in _G
  _get_table(results, key, _G, "")
  table.sort(results)
  local tmp = {}
  local last = nil
  for k, v in pairs(results) do
    if last ~= v then
      last = v
      table.insert(tmp, v)
      n = n + 1
    end
  end

  if n > 1 then
    local big = tmp[1]
    for k, v in pairs(tmp) do
      while v:sub(1, #big) ~= big do
	big = big:sub(1, -2)
      end
    end
    table.insert(tmp, 1, big)
    n = n + 1
  end
  results = tmp

  return n, results
end

luashellcolor = false

local function color(cmd)
  if luashellcolor then
    return cmd
  end
  return ""
end

local prompt = nil
local last_luashellcolor = false

function getPrompt()
  if prompt == nil or luashellcolor ~= last_luashellcolor then
    last_luashellcolor = luashellcolor
    if whoami()(true):sub(1, -2) == "root" then
      prompt = color("\027[1;31m") .. "root"
    else
      prompt = color("\027[1;34m") .. whoami()(true):sub(1, -2)
    end
    prompt = prompt
	    .. color("\027[1;31m") .. "@"
	    .. color("\027[1;34m") .. hostname()(true):sub(1, -2) .. ":"
	    .. color("\027[0m");
  end
  local path = lfs.currentdir()
  if path:sub(1, #HOME) == HOME then
    path = "~" .. path:sub(#HOME + 1, -1)
  end
  return prompt .. color("\027[1;36m") .. path .. "$ " .. color("\027[0m")
end

function isLuaObject(token, t)
  if t == nil then
    t = _G
  end
  if token:find("[+%-*%%%/=<>]") ~= nil then
    return true
  end
  if token:find("[^%w%.%_%:]") ~= nil then
    return false
  end
  local pos = token:find("%.")
  if pos ~= nil then
    if type(t[token:sub(1, pos - 1)]) ~= "table" then
      return false
    end
    return isLuaObject(token:sub(pos + 1, -1), t[token:sub(1, pos - 1)])
  else
    return t[token] ~= nil
  end
  return true
end

function parseCode(code)
  if type(code) == "string" then
    local tokens = {}
    local cur = ""
    local mode = 0
    local escape = false
    for i = 1, #code do
      local c = code:sub(i,i)
      if mode == 0 then		-- outside a string
	if c == " " or c == "(" or c == ")" or c == "[" or c == "]" or c == ":" or c == "," or c == ";" then
	  if c == "(" then
	    cur = cur .. c
	  end
	  if cur ~= "" then
	    table.insert(tokens, cur)
	  end
	  if c ~= "(" and c ~= " " then
	    table.insert(tokens, c)
	  end
	  cur = ""
	  escape = false
	elseif c == "\\" then
	  cur = cur .. c
	  escape = true
	elseif c == "\"" and not escape then
	  escape = false
	  if cur ~= "" then
	    table.insert(tokens, cur)
	  end
	  cur = "\""
	  mode = 1
	elseif c == "{" then
	  escape = false
	  if cur ~= "" then
	    table.insert(tokens, cur)
	  end
	  cur = "{"
	  mode = 2
	else
	  escape = false
	  cur = cur .. c
	end
      elseif mode == 1 then
	cur = cur .. c
	if c == "\\" then
	  escape = true
	elseif c == "\"" and not escape then
	  escape = false
	  table.insert(tokens, cur)
	  cur = ""
	  mode = 0
	else
	  escape = false
	end
      elseif mode == 2 then
	cur = cur .. c
	if c == "}" then
	  table.insert(tokens, cur)
	  cur = ""
	  mode = 0
	end
      end
    end
    if cur ~= "" then
      table.insert(tokens, cur)
    end
    local res = ""
    for k, token in ipairs(tokens) do
      if k > 1 then
	res = res .. " "
      end
      if token:sub(1, 1) == "\"" and token:sub(-1,-1) ~= "\"" then
	token = token .. "\""
      elseif token:sub(1, 1) == "\"" or token == ")" or token:sub(-1, -1) == "(" then
      elseif token:sub(1, 1) == "{" and token:sub(-1,-1) == "}" then
      elseif token == "," or token == ";" then
      elseif token == "/" then
      elseif token:sub(1, 1) ~= "\"" and lfs.attributes(token, "mode") ~= nil then
	token = "\"" .. token .. "\""
      elseif not isLuaObject(token) then
	token = "\"" .. token .. "\""
      end
      res = res .. token
    end
--    print(res)
    return res
  end
  return code
end

if type(luashellhideintro) ~= "boolean" or not luashellhideintro then
  print()
  print("Lua Shell running " .. _VERSION)
  print("Copyright 2009 - Roland Brochard")
  print()
end

if type(luashellsafemode) ~= "boolean" or not luashellsafemode then
  -- global config file
  pcall(loadfile("/etc/luashellrc"))
  -- user config file
  os.execute("test -e ~/.luashellrc || touch ~/.luashellrc")
  pcall(loadfile(HOME .. "/.luashellrc"))
else
  luashellcolor = false
  print("Shell keeps crashing, starting in safe mode ...")
  print("Config files are being ignored")
end

local code = ""

while true do
  if code:len() == 0 then
    _PROMPT = getPrompt()
  else
    _PROMPT = ""
  end

  local input = readline()
  code = code .. parseCode(input)
  if input:find("\\$") == nil then
    _last_runner = nil
    local chunk = loadstring(code)
    if chunk == nil then
      chunk = loadstring(code .. "()")
    end
    local value, err = pcall(chunk)
    if value == false and err ~= nil then
      io.stderr:write("error : " .. err .. "\n")
    elseif type(_last_runner) == "table" and not _last_runner.done then
      _last_runner()
    end
    code = ""
  else
    code = code:sub(1, -2) .. "\n"
  end
end
