# Installation

LuaRadio can be installed from the Arch Linux AUR, macOS Homebrew, macOS
MacPorts, or from source.

Packaging for other distributions and platforms is a work in progress.

To try LuaRadio without installation, you can run it [directly from the
repository](../README.md#quickstart), provided LuaJIT is installed.

## Packages

### Arch Linux AUR

LuaRadio is available in the AUR: [`luaradio`](https://aur.archlinux.org/packages/luaradio)

### macOS Homebrew

LuaRadio is available in [Homebrew](http://brew.sh/):

```
brew install luaradio
```

### macOS MacPorts

LuaRadio is available in [MacPorts](https://www.macports.org/):

```
sudo port install luaradio
```

## Building from Source

### Prerequisites

Install LuaJIT 2.0.4 or greater and prerequisites:

* Arch Linux: `sudo pacman -S luajit`
* macOS (Homebrew): `brew install luajit pkg-config`
* macOS (MacPorts): `sudo port install luajit pkgconfig`
* Ubuntu/Debian/Rasbpian: `sudo apt-get install luajit libluajit-5.1-dev pkg-config`
* Fedora/CentOS: `sudo yum install luajit luajit-devel`

### Installation

Build and install LuaRadio:

```
git clone https://github.com/vsergeev/luaradio.git
cd luaradio/embed
make lib
sudo make install
```

### Real-time Dependencies

LuaRadio has no hard dependencies outside of LuaJIT, but is accelerated by the
optional libraries [liquid-dsp](https://github.com/jgaeddert/liquid-dsp),
[VOLK](http://libvolk.org/), and [fftw](http://www.fftw.org/). For best
real-time performance, install these libraries:

* Arch Linux: `sudo pacman -S liquid-dsp libvolk fftw`
* macOS (Homebrew): `brew install liquid-dsp fftw`
* macOS (MacPorts): `sudo port install liquid-dsp volk fftw-3`
* Ubuntu/Debian/Raspbian: `sudo apt-get install libliquid-dev libvolk1-dev libfftw3-dev`
* Fedora/CentOS: `sudo yum install liquid-dsp fftw`

### Optional Dependencies

Desktop users should also install the `gnuplot` package for plotting support.

Some I/O blocks, like SDR and audio sources/sinks, may require external
libraries. For example, the RTL-SDR requires the `librtlsdr` library.

### Check Installation

Check the installation by dumping the platform information:

```
$ luaradio --platform
luajit          LuaJIT 2.0.5
os              Linux
arch            x64
page size       4096
cpu count       4
cpu model       Intel(R) Core(TM) i5-4570T CPU @ 2.90GHz
features
    fftw3f      true    fftw-3.3.8-sse2-avx
    volk        true    2.1 (avx2_64_mmx_orc)
    liquid      true    1.3.2
$
```

The `liquid`, `volk`, and `fftw3f` features should be marked true, if the
respective libraries were found by LuaRadio.
