/*
 * Decompiled with CFR 0.152.
 */
package com.bfo.json;

import com.bfo.json.Json;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.TypeRef;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class JsonPathProviderBFO
implements JsonProvider {
    private static Configuration configuration;

    static Object read(String path, Json ctx) {
        return JsonPath.compile((String)path, (Predicate[])new Predicate[0]).read((Object)ctx, JsonPathProviderBFO.getConfiguration());
    }

    public Object createArray() {
        return new ArrayList();
    }

    public Object createMap() {
        return new HashMap();
    }

    public String toJson(Object o) {
        return o.toString();
    }

    public boolean isArray(Object o) {
        return o instanceof Json && ((Json)o).isList();
    }

    public boolean isMap(Object o) {
        return o instanceof Json && ((Json)o).isMap();
    }

    public int length(Object o) {
        if (o instanceof List) {
            return ((List)o).size();
        }
        if (o instanceof Json) {
            Json json = (Json)o;
            if (json.isList() || json.isMap()) {
                return json.size();
            }
            if (json.isString()) {
                return json.stringValue().length();
            }
        }
        return 0;
    }

    public Iterable toIterable(Object o) {
        return ((Json)o).listValue();
    }

    public Collection<String> getPropertyKeys(Object o) {
        return ((Json)o).mapValue().keySet();
    }

    public Object getArrayIndex(Object o, int idx) {
        if (o instanceof List) {
            return ((List)o).get(idx);
        }
        return ((Json)o).listValue().get(idx);
    }

    public Object getArrayIndex(Object o, int idx, boolean unwrap) {
        return this.getArrayIndex(o, idx);
    }

    public void setArrayIndex(Object o, int idx, Object v) {
        ((Json)o).put(idx, v);
    }

    public Object getMapValue(Object o, String key) {
        Object json = ((Json)o)._mapValue().get(key);
        if (json == null) {
            json = UNDEFINED;
        }
        return json;
    }

    private static String quoteKey(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '.' && c != '[' && c != ']') continue;
            StringBuilder sb = new StringBuilder(s.length());
            sb.append('\"');
            for (i = 0; i < s.length(); ++i) {
                c = s.charAt(i);
                if (c == '\"') {
                    sb.append("\\\"");
                    continue;
                }
                sb.append(c);
            }
            sb.append('\"');
            return sb.toString();
        }
        return s;
    }

    public void setProperty(Object o, Object key, Object v) {
        if (key instanceof Integer) {
            ((Json)o).put((Integer)key, v);
        } else {
            ((Json)o).put(JsonPathProviderBFO.quoteKey(key.toString()), v);
        }
    }

    public void removeProperty(Object o, Object key) {
        if (key instanceof Integer) {
            ((Json)o).remove((Integer)key);
        } else {
            ((Json)o).remove(JsonPathProviderBFO.quoteKey(key.toString()));
        }
    }

    public Object parse(InputStream in, String charset) throws InvalidJsonException {
        try {
            return Json.read(new InputStreamReader(in, charset), null);
        }
        catch (Exception e) {
            throw new InvalidJsonException((Throwable)e);
        }
    }

    public Object parse(String s) throws InvalidJsonException {
        try {
            return Json.read(s);
        }
        catch (Exception e) {
            throw new InvalidJsonException((Throwable)e);
        }
    }

    public Object unwrap(Object o) {
        return ((Json)o).value();
    }

    public static synchronized Configuration getConfiguration() {
        if (configuration == null) {
            MappingProvider prov = new MappingProvider(){

                public <T> T map(Object source, Class<T> targetType, Configuration configuration) {
                    return null;
                }

                public <T> T map(Object source, TypeRef<T> targetType, Configuration configuration) {
                    return null;
                }
            };
            configuration = new Configuration.ConfigurationBuilder().jsonProvider((JsonProvider)new JsonPathProviderBFO()).mappingProvider(prov).build();
        }
        return configuration;
    }
}

