/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ga;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;

public class IrishFGBEqReplaceRule
extends AbstractSimpleReplaceRule {
    private static final Map<String, List<String>> wrongWords = IrishFGBEqReplaceRule.loadFromPath((String)"/ga/replace-fgb-eq.txt");
    private static final Locale GA_LOCALE = new Locale("GA");

    protected Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public IrishFGBEqReplaceRule(ResourceBundle messages) throws IOException {
        super(messages);
        super.setCategory(Categories.TYPOS.getCategory(messages));
        super.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.addExamplePair(Example.wrong((String)"An bhfuil t\u00fa <marker>urlamh</marker>?"), Example.fixed((String)"An bhfuil t\u00fa <marker>ullamh</marker>?"));
        this.setCheckLemmas(false);
    }

    public final String getId() {
        return "GA_FGB_EQ_REPLACE";
    }

    public String getDescription() {
        return "Ceannfhocal FGB neamhchoitianta, m.sh., \"urlamh\" in \u00e1it \"ullamh\"";
    }

    public String getShort() {
        return "Neamhchoitianta";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return "Focal ceart ach t\u00e1 \"" + String.join((CharSequence)", ", replacements) + "\" n\u00edos coitianta.";
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Locale getLocale() {
        return GA_LOCALE;
    }
}

