/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.nl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.tagging.BaseTagger;
import org.languagetool.tools.StringTools;

public class DutchTagger
extends BaseTagger {
    public DutchTagger() {
        super("/nl/dutch.dict", new Locale("nl"));
    }

    public List<AnalyzedTokenReadings> tag(List<String> sentenceTokens) {
        ArrayList<AnalyzedTokenReadings> tokenReadings = new ArrayList<AnalyzedTokenReadings>();
        int pos = 0;
        for (String word : sentenceTokens) {
            boolean ignoreSpelling = false;
            String originalWord = word;
            word = word.replace("`", "'").replace("\u2019", "'").replace("\u2018", "'").replace("\u00b4", "'");
            ArrayList<AnalyzedToken> l = new ArrayList<AnalyzedToken>();
            String lowerWord = word.toLowerCase(this.locale);
            boolean isLowercase = word.equals(lowerWord);
            boolean isMixedCase = StringTools.isMixedCase((String)word);
            boolean isAllUpper = StringTools.isAllUppercase((String)word);
            List taggerTokens = this.asAnalyzedTokenListForTaggedWords(originalWord, this.getWordTagger().tag(word));
            this.addTokens(taggerTokens, l);
            if (!isLowercase && !isMixedCase) {
                List lowerTaggerTokens = this.asAnalyzedTokenListForTaggedWords(originalWord, this.getWordTagger().tag(lowerWord));
                this.addTokens(lowerTaggerTokens, l);
            }
            if (l.isEmpty() && isAllUpper) {
                String firstUpper = StringTools.uppercaseFirstChar((String)lowerWord);
                List firstupperTaggerTokens = this.asAnalyzedTokenListForTaggedWords(originalWord, this.getWordTagger().tag(firstUpper));
                this.addTokens(firstupperTaggerTokens, l);
            }
            if (l.isEmpty()) {
                Boolean activateUncompounder;
                List l2;
                String word2 = word;
                word2 = word2.replaceAll("([^aeiou\u00e1\u00e9\u00ed\u00f3\u00fa])(\u00e1)([^aeiou\u00e1\u00e9\u00ed\u00f3\u00fa])", "$1a$3");
                word2 = word2.replaceAll("([^aeiou\u00e1\u00e9\u00ed\u00f3\u00fa])(\u00e9)([^aeiou\u00e1\u00e9\u00ed\u00f3\u00fa])", "$1e$3");
                word2 = word2.replaceAll("([^aeiou\u00e1\u00e9\u00ed\u00f3\u00fa])(\u00ed)([^aeiou\u00e1\u00e9\u00ed\u00f3\u00fa])", "$1i$3");
                word2 = word2.replaceAll("([^aeiou\u00e1\u00e9\u00ed\u00f3\u00fa])(\u00f3)([^aeiou\u00e1\u00e9\u00ed\u00f3\u00fa])", "$1o$3");
                word2 = word2.replaceAll("([^aeiou\u00e1\u00e9\u00ed\u00f3\u00fa])(\u00fa)([^aeiou\u00e1\u00e9\u00ed\u00f3\u00fa])", "$1u$3");
                word2 = word2.replace("\u00e1\u00e1", "aa");
                word2 = word2.replace("\u00e1\u00e9", "ae");
                word2 = word2.replace("\u00e1\u00ed", "ai");
                word2 = word2.replace("\u00e1\u00fa", "au");
                word2 = word2.replace("\u00e9\u00e9", "ee");
                word2 = word2.replace("\u00e9\u00ed", "ei");
                word2 = word2.replace("\u00e9\u00fa", "eu");
                word2 = word2.replace("\u00ed\u00e9", "ie");
                word2 = word2.replace("\u00f3\u00e9", "oe");
                word2 = word2.replace("\u00f3\u00ed", "oi");
                word2 = word2.replace("\u00f3\u00f3", "oo");
                word2 = word2.replace("\u00f3\u00fa", "ou");
                word2 = word2.replace("\u00fa\u00ed", "ui");
                word2 = word2.replace("\u00fa\u00fa", "uu");
                word2 = word2.replace("\u00edj", "ij");
                word2 = word2.replaceAll("(^|[^aeiou])\u00e1([^aeiou]|$)", "$1a$2");
                word2 = word2.replaceAll("(^|[^aeiou])\u00e9([^aeiou]|$)", "$1e$2");
                word2 = word2.replaceAll("(^|[^aeiou])\u00ed([^aeiou]|$)", "$1i$2");
                word2 = word2.replaceAll("(^|[^aeiou])\u00f3([^aeiou]|$)", "$1o$2");
                if ((word2 = word2.replaceAll("(^|[^aeiou])\u00fa([^aeiou]|$)", "$1u$2")).contains("-")) {
                    String part2 = word2.replaceAll("(^.*)-(.*$)", "$2");
                    List p2 = this.asAnalyzedTokenListForTaggedWords(originalWord, this.getWordTagger().tag(part2));
                    if (!p2.isEmpty()) {
                        word2 = word2.replaceAll("([a-z])-([a-z])", "$1$2");
                    }
                }
                if (!word2.equals(word) && !(l2 = this.asAnalyzedTokenListForTaggedWords(originalWord, this.getWordTagger().tag(word2))).isEmpty()) {
                    this.addTokens(l2, l);
                    ignoreSpelling = true;
                }
                if ((activateUncompounder = Boolean.valueOf(false)).booleanValue() && l.isEmpty()) {
                    String wordExceptions = "translating|voorzittersschap|weerszijden|bijenkomst|stijlwestie";
                    String riskyParts = "vergoding|bijbel|tegens|rood|geel|groen|blauw|paars|oranje|bronzen|stat|westie|westies|barheid|douch|vrouwe|ellen|geluis|beroes|heep|hepen";
                    if (!word.matches(wordExceptions)) {
                        int size = word.length();
                        String trueCollisions = ".*(a~[ae\u00e9iu]|[e\u00e9]~[e\u00e9iu]|i~[e]|o~[eiou]|i~j|[A-Z]~[a-z]|[a-z]~[A-Z]|[0-9]~[a-zA-Z]|[a-zA-Z]~[0-9]).*";
                        trueCollisions = trueCollisions + "|(tegen|voor|achter|midden|open)~(s|s-)~.*|(af|aan|uit|op)?(rijd|snijd|glijd)~.*";
                        for (int i = 5; i <= size - 5; ++i) {
                            AnalyzedToken temp;
                            List o;
                            String otherPlural;
                            String tagCombi;
                            String fWord;
                            String fTag;
                            int k;
                            String eWord;
                            String eTag;
                            int j;
                            String option;
                            List f;
                            String end = word.substring(i);
                            if (end.matches(riskyParts)) continue;
                            List e = this.asAnalyzedTokenListForTaggedWords(originalWord, this.getWordTagger().tag(end));
                            String front = word.substring(0, i);
                            if (!(front.matches(riskyParts) || e.isEmpty() || (f = this.asAnalyzedTokenListForTaggedWords(originalWord, this.getWordTagger().tag(front))).isEmpty() || (option = front + "~" + end).matches(trueCollisions))) {
                                for (j = 0; j < e.size(); ++j) {
                                    eTag = ((AnalyzedToken)e.get(j)).getPOSTag();
                                    eWord = ((AnalyzedToken)e.get(j)).getLemma();
                                    for (k = 0; k < f.size(); ++k) {
                                        fTag = ((AnalyzedToken)f.get(k)).getPOSTag();
                                        fWord = ((AnalyzedToken)f.get(k)).getLemma();
                                        tagCombi = fTag + "~" + eTag;
                                        if (tagCombi.matches("^(ZNW:EKV|ZNW:EKV:DE_|ZNW:EKV:HET|ZNW:MRV:VRK:HET|WKW:TGW:1EP)~ZNW:.*$")) {
                                            l.add(new AnalyzedToken(word, eTag, front + eWord));
                                            ignoreSpelling = true;
                                            l.add(new AnalyzedToken(word, "LIKELY_SPELLING", word));
                                            continue;
                                        }
                                        if (!tagCombi.matches("^ZNW:MRV:DE_~ZNW:.*$") || !front.matches(".*en$")) continue;
                                        otherPlural = front.replaceAll("n$", "s");
                                        System.out.println(otherPlural);
                                        o = this.asAnalyzedTokenListForTaggedWords(otherPlural, this.getWordTagger().tag(otherPlural));
                                        if (!o.isEmpty()) continue;
                                        temp = new AnalyzedToken(word, eTag, front + eWord);
                                        l.add(new AnalyzedToken(word, eTag, front + eWord));
                                        l.add(new AnalyzedToken(word, "LIKELY_SPELLING", word));
                                        ignoreSpelling = true;
                                    }
                                }
                            }
                            if (word.substring(i - 2, i).equals("s-") && !(front = word.substring(0, i - 2)).matches(riskyParts) && !(f = this.asAnalyzedTokenListForTaggedWords(originalWord, this.getWordTagger().tag(front))).isEmpty()) {
                                option = front + "~s-~" + end;
                                for (j = 0; j < e.size(); ++j) {
                                    eTag = ((AnalyzedToken)e.get(j)).getPOSTag();
                                    eWord = ((AnalyzedToken)e.get(j)).getLemma();
                                    for (k = 0; k < f.size(); ++k) {
                                        fTag = ((AnalyzedToken)f.get(k)).getPOSTag();
                                        fWord = ((AnalyzedToken)f.get(k)).getLemma();
                                        tagCombi = fTag + "~s-~" + eTag;
                                        if (!tagCombi.matches("^(ZNW:EKV|ZNW:EKV:DE_|ZNW:EKV:HET|ZNW:MRV:VRK:HET)~s-~ZNW:.*$") || option.matches(".*e~s-~.*")) continue;
                                        l.add(new AnalyzedToken(word, eTag, front + "s-" + eWord));
                                        l.add(new AnalyzedToken(word, "LIKELY_SPELLING", word));
                                        ignoreSpelling = true;
                                    }
                                }
                            }
                            if (word.substring(i - 1, i).equals("s") && !(front = word.substring(0, i - 1)).matches(riskyParts) && !(f = this.asAnalyzedTokenListForTaggedWords(originalWord, this.getWordTagger().tag(front))).isEmpty() && !(option = front + "~s~" + end).matches(".*~s~[A-Z0-9].*")) {
                                for (j = 0; j < e.size(); ++j) {
                                    eTag = ((AnalyzedToken)e.get(j)).getPOSTag();
                                    eWord = ((AnalyzedToken)e.get(j)).getLemma();
                                    for (k = 0; k < f.size(); ++k) {
                                        fTag = ((AnalyzedToken)f.get(k)).getPOSTag();
                                        fWord = ((AnalyzedToken)f.get(k)).getLemma();
                                        tagCombi = fTag + "~s~" + eTag;
                                        if (!tagCombi.matches("^(ZNW:EKV|ZNW:EKV:DE_|ZNW:EKV:HET|ZNW:MRV:VRK:HET)~s~ZNW:.*$") || option.matches(".*e~s~.*")) continue;
                                        l.add(new AnalyzedToken(word, eTag, front + "s" + eWord));
                                        l.add(new AnalyzedToken(word, "LIKELY_SPELLING", word));
                                        ignoreSpelling = true;
                                    }
                                }
                            }
                            if (!word.substring(i - 1, i).equals("-") || (front = word.substring(0, i - 1)).matches(riskyParts) || (f = this.asAnalyzedTokenListForTaggedWords(originalWord, this.getWordTagger().tag(front))).isEmpty()) continue;
                            option = front + "~-~" + end;
                            for (j = 0; j < e.size(); ++j) {
                                eTag = ((AnalyzedToken)e.get(j)).getPOSTag();
                                eWord = ((AnalyzedToken)e.get(j)).getLemma();
                                for (k = 0; k < f.size(); ++k) {
                                    fTag = ((AnalyzedToken)f.get(k)).getPOSTag();
                                    fWord = ((AnalyzedToken)f.get(k)).getLemma();
                                    tagCombi = fTag + "~-~" + eTag;
                                    if (tagCombi.matches("^(ZNW:EKV|ZNW:EKV:DE_|ZNW:EKV:HET|ZNW:MRV:VRK:HET|WKW:TGW:1EP)~-~ZNW:.*$")) {
                                        l.add(new AnalyzedToken(word, eTag, front + "-" + eWord));
                                        l.add(new AnalyzedToken(word, "LIKELY_SPELLING", word));
                                        ignoreSpelling = true;
                                        continue;
                                    }
                                    if (!tagCombi.matches("^ZNW:MRV:DE_~ZNW:.*$") || !front.matches(".*en$") || !(o = this.asAnalyzedTokenListForTaggedWords(otherPlural = front.replaceAll("n$", "s"), this.getWordTagger().tag(otherPlural))).isEmpty()) continue;
                                    System.out.println(o.toString());
                                    temp = new AnalyzedToken(word, eTag, front + eWord);
                                    l.add(new AnalyzedToken(word, eTag, front + "-" + eWord));
                                    l.add(new AnalyzedToken(word, "LIKELY_SPELLING", word));
                                    ignoreSpelling = true;
                                }
                            }
                        }
                    }
                }
            }
            word = originalWord;
            if (l.isEmpty()) {
                l.add(new AnalyzedToken(originalWord, null, null));
            }
            AnalyzedTokenReadings atr = new AnalyzedTokenReadings(l, pos);
            if (ignoreSpelling) {
                if (isLowercase) {
                    List fu = this.asAnalyzedTokenListForTaggedWords(StringTools.uppercaseFirstChar((String)originalWord), this.getWordTagger().tag(StringTools.uppercaseFirstChar((String)originalWord)));
                    if (fu.isEmpty()) {
                        atr.ignoreSpelling();
                    } else {
                        l.clear();
                        l.add(new AnalyzedToken(originalWord, null, null));
                    }
                } else {
                    atr.ignoreSpelling();
                }
            }
            tokenReadings.add(atr);
            pos += word.length();
        }
        return tokenReadings;
    }

    private void addTokens(List<AnalyzedToken> taggedTokens, List<AnalyzedToken> l) {
        if (taggedTokens != null) {
            l.addAll(taggedTokens);
        }
    }
}

