/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.lspcli.client;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentItem;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\fJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0003H\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0003H\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/bsplines/lspcli/client/LspCliTextDocumentItem;", "Lorg/eclipse/lsp4j/TextDocumentItem;", "uri", "", "codeLanguageId", "version", "", "text", "(Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;)V", "lineStartPosList", "", "convertPosition", "Lorg/eclipse/lsp4j/Position;", "pos", "position", "reinitializeLineStartPosList", "", "setText", "lspcli"})
public final class LspCliTextDocumentItem
extends TextDocumentItem {
    @NotNull
    private final List<Integer> lineStartPosList;

    public LspCliTextDocumentItem(@NotNull String uri, @NotNull String codeLanguageId, int version, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)codeLanguageId, (String)"codeLanguageId");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(uri, codeLanguageId, version, text);
        this.lineStartPosList = new ArrayList();
        this.reinitializeLineStartPosList(text);
    }

    private final void reinitializeLineStartPosList(String text) {
        this.lineStartPosList.clear();
        this.lineStartPosList.add(0);
        int i = 0;
        while (i < text.length()) {
            int n;
            char c = text.charAt(i);
            if (c == '\r') {
                if (i + 1 < text.length() && text.charAt(i + 1) == '\n') {
                    n = i;
                    i = n + 1;
                }
                this.lineStartPosList.add(i + 1);
            } else if (c == '\n') {
                this.lineStartPosList.add(i + 1);
            }
            n = i;
            i = n + 1;
        }
    }

    public final int convertPosition(@NotNull Position position) {
        int n;
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        int line = position.getLine();
        int character = position.getCharacter();
        String string = this.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
        String text = string;
        if (line < 0) {
            n = 0;
        } else if (line >= this.lineStartPosList.size()) {
            n = text.length();
        } else {
            int lineStart = ((Number)this.lineStartPosList.get(line)).intValue();
            int nextLineStart = line < this.lineStartPosList.size() - 1 ? ((Number)this.lineStartPosList.get(line + 1)).intValue() : text.length();
            int lineLength = nextLineStart - lineStart;
            if (character < 0) {
                n = lineStart;
            } else if (character >= lineLength) {
                int pos = lineStart + lineLength;
                if (pos >= 1) {
                    int n2;
                    if (text.charAt(pos - 1) == '\r') {
                        int n3 = pos;
                        pos = n3 + -1;
                    } else if (text.charAt(pos - 1) == '\n' && (pos = (n2 = pos) + -1) >= 1 && text.charAt(pos - 1) == '\r') {
                        n2 = pos;
                        pos = n2 + -1;
                    }
                }
                n = pos;
            } else {
                n = lineStart + character;
            }
        }
        return n;
    }

    @NotNull
    public final Position convertPosition(int pos) {
        int line = CollectionsKt.binarySearch$default(this.lineStartPosList, (Comparable)Integer.valueOf(pos), (int)0, (int)0, (int)6, null);
        if (line < 0) {
            int insertionPoint = -line - 1;
            line = insertionPoint - 1;
        }
        return new Position(line, pos - ((Number)this.lineStartPosList.get(line)).intValue());
    }

    public void setText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super.setText(text);
        this.reinitializeLineStartPosList(text);
    }
}

