/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.lspcli;

import com.google.gson.JsonElement;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.bsplines.lspcli.client.Checker;
import org.bsplines.lspcli.client.LspCliLanguageClient;
import org.bsplines.lspcli.tools.I18n;
import org.bsplines.lspcli.tools.Logging;
import org.bsplines.lspcli.tools.LspCliSettings;
import org.bsplines.lspcli.tools.VersionProvider;
import org.fusesource.jansi.AnsiConsole;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;

@CommandLine.Command(name="lsp-cli", versionProvider=VersionProvider.class, mixinStandardHelpOptions=true, description={"lsp-cli - CLI language client for LSP language servers"}, showDefaultValues=true)
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0011\b\u0007\u0018\u0000 ,2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001,B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u0017\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\r\u0010*\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010+R \u0010\t\u001a\u0004\u0018\u00010\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u00168\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\"\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0018\"\u0004\b\u001e\u0010\u001aR \u0010\u001f\u001a\u0004\u0018\u00010\u001c8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R \u0010$\u001a\u0004\u0018\u00010\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\f\"\u0004\b&\u0010\u000eR\u001e\u0010'\u001a\u00020\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0012\"\u0004\b)\u0010\u0014\u00a8\u0006-"}, d2={"Lorg/bsplines/lspcli/LspCliLauncher;", "Ljava/util/concurrent/Callable;", "", "()V", "parseResult", "Lpicocli/CommandLine$ParseResult;", "lspCliSettings", "Lorg/bsplines/lspcli/tools/LspCliSettings;", "(Lpicocli/CommandLine$ParseResult;Lorg/bsplines/lspcli/tools/LspCliSettings;)V", "clientConfigurationFilePath", "Ljava/nio/file/Path;", "getClientConfigurationFilePath", "()Ljava/nio/file/Path;", "setClientConfigurationFilePath", "(Ljava/nio/file/Path;)V", "hideCommands", "", "getHideCommands", "()Z", "setHideCommands", "(Z)V", "inputFilePaths", "", "getInputFilePaths", "()Ljava/util/List;", "setInputFilePaths", "(Ljava/util/List;)V", "serverCommandLineList", "", "getServerCommandLineList", "setServerCommandLineList", "serverCommandLineString", "getServerCommandLineString", "()Ljava/lang/String;", "setServerCommandLineString", "(Ljava/lang/String;)V", "serverWorkingDirPath", "getServerWorkingDirPath", "setServerWorkingDirPath", "verbose", "getVerbose", "setVerbose", "call", "()Ljava/lang/Integer;", "Companion", "lspcli"})
public final class LspCliLauncher
implements Callable<Integer> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @CommandLine.Option(names={"--server-command-line"}, required=true, description={"Required. Command line to start the language server, starting with the path of its executable. If you want to supply arguments to the language server, separate them with spaces. If the path of the executable or one of the arguments contain spaces, you can escape them by using '\\ ' instead. In .lsp-cli.json, this option can either be specified as an array of arguments or as a string with space-separated arguments."}, paramLabel="<string>")
    @Nullable
    private String serverCommandLineString;
    @Nullable
    private List<String> serverCommandLineList;
    @CommandLine.Option(names={"--server-working-directory"}, description={"Working directory for --server-command-line. If omitted, use the parent directory of `.lsp-cli.json` if given, otherwise use the current working directory."}, paramLabel="<directory>")
    @Nullable
    private Path serverWorkingDirPath;
    @CommandLine.Option(names={"--client-configuration"}, description={"Use the client configuration stored in the JSON file <file>. The format is usually nested JSON objects (e.g., {\"latex\": {\"commands\": ...}})."}, paramLabel="<file>")
    @Nullable
    private Path clientConfigurationFilePath;
    @CommandLine.Option(names={"--hide-commands"}, description={"Hide commands in lists of code actions for diagnostics, only show quick fixes."})
    private boolean hideCommands;
    @CommandLine.Option(names={"--verbose"}, description={"Write to standard error output what is being done."})
    private boolean verbose;
    @CommandLine.Parameters(description={"Paths of files or directories to check. Directories are traversed recursively for supported file types. If - is given, standard input will be checked as plain text."}, arity="1..*", paramLabel="<path>")
    @NotNull
    private List<? extends Path> inputFilePaths;
    private static final int EXIT_CODE_MATCHES_FOUND = 3;
    @NotNull
    private static final Regex ESCAPED_SPACE_REGEX = new Regex("\\\\ ");
    @NotNull
    private static final String NON_ESCAPED_SPACE_REGEX_STRING = "(?<!\\\\) ";
    @NotNull
    private static final Regex NON_ESCAPED_SPACE_REGEX = new Regex("(?<!\\\\) ");

    @Nullable
    public final String getServerCommandLineString() {
        return this.serverCommandLineString;
    }

    public final void setServerCommandLineString(@Nullable String string) {
        this.serverCommandLineString = string;
    }

    @Nullable
    public final List<String> getServerCommandLineList() {
        return this.serverCommandLineList;
    }

    public final void setServerCommandLineList(@Nullable List<String> list) {
        this.serverCommandLineList = list;
    }

    @Nullable
    public final Path getServerWorkingDirPath() {
        return this.serverWorkingDirPath;
    }

    public final void setServerWorkingDirPath(@Nullable Path path) {
        this.serverWorkingDirPath = path;
    }

    @Nullable
    public final Path getClientConfigurationFilePath() {
        return this.clientConfigurationFilePath;
    }

    public final void setClientConfigurationFilePath(@Nullable Path path) {
        this.clientConfigurationFilePath = path;
    }

    public final boolean getHideCommands() {
        return this.hideCommands;
    }

    public final void setHideCommands(boolean bl) {
        this.hideCommands = bl;
    }

    public final boolean getVerbose() {
        return this.verbose;
    }

    public final void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    @NotNull
    public final List<Path> getInputFilePaths() {
        return this.inputFilePaths;
    }

    public final void setInputFilePaths(@NotNull List<? extends Path> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.inputFilePaths = list;
    }

    public LspCliLauncher() {
        this.inputFilePaths = CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    public LspCliLauncher(@NotNull CommandLine.ParseResult parseResult, @NotNull LspCliSettings lspCliSettings) {
        boolean bl;
        boolean bl2;
        Object object;
        Path path;
        Path path2;
        String $this$mapTo$iv$iv;
        LspCliLauncher lspCliLauncher;
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)parseResult, (String)"parseResult");
        Intrinsics.checkNotNullParameter((Object)lspCliSettings, (String)"lspCliSettings");
        this.inputFilePaths = CollectionsKt.emptyList();
        if (parseResult.hasMatchedOption("--server-command-line")) {
            this.serverCommandLineString = (String)parseResult.matchedOptionValue("--server-command-line", null);
        } else {
            JsonElement jsonElement;
            stringArray = new String[]{"defaultValues", "--server-command-line"};
            JsonElement jsonElement2 = jsonElement = lspCliSettings.getValue(stringArray);
            if (jsonElement2 == null ? false : jsonElement2.isJsonArray()) {
                void $this$map$iv;
                stringArray = jsonElement.getAsJsonArray();
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"jsonElement.asJsonArray");
                stringArray = (Iterable)stringArray;
                lspCliLauncher = this;
                boolean $i$f$map = false;
                void var6_11 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    Object item$iv$iv = iterator.next();
                    JsonElement jsonElement3 = (JsonElement)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(it.getAsString());
                }
                lspCliLauncher.serverCommandLineList = (List)destination$iv$iv;
            } else if (jsonElement != null) {
                this.serverCommandLineString = jsonElement.getAsString();
            }
        }
        if (parseResult.hasMatchedOption("--server-working-directory")) {
            path2 = (Path)parseResult.matchedOptionValue("--server-working-directory", null);
        } else {
            String string;
            String[] stringArray2 = new String[]{"defaultValues", "--server-working-directory"};
            stringArray = lspCliSettings.getValue(stringArray2);
            String string2 = string = stringArray == null ? null : stringArray.getAsString();
            if (string != null) {
                path2 = Path.of(string, new String[0]);
            } else {
                Path path3 = lspCliSettings.getSettingsFilePath();
                if (path3 == null) {
                    path2 = null;
                } else {
                    Path path4 = path3.toAbsolutePath();
                    path2 = path4 == null ? null : path4.getParent();
                }
            }
        }
        this.serverWorkingDirPath = path2;
        LspCliLauncher lspCliLauncher2 = this;
        if (parseResult.hasMatchedOption("--client-configuration")) {
            path = (Path)parseResult.matchedOptionValue("--client-configuration", null);
        } else {
            stringArray = new String[]{"defaultValues", "--client-configuration"};
            object = lspCliSettings.getValue(stringArray);
            if (object == null) {
                path = null;
            } else {
                String string = object.getAsString();
                if (string == null) {
                    path = null;
                } else {
                    void it;
                    $this$mapTo$iv$iv = string;
                    lspCliLauncher = lspCliLauncher2;
                    boolean bl4 = false;
                    path = Path.of((String)it, new String[0]);
                    lspCliLauncher2 = lspCliLauncher;
                }
            }
        }
        lspCliLauncher2.clientConfigurationFilePath = path;
        if (parseResult.hasMatchedOption("--hide-commands")) {
            object = parseResult.matchedOptionValue("--hide-commands", (Object)false);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n      parseResult.matc\u2026e-commands\", false)\n    }");
            bl2 = (Boolean)object;
        } else {
            boolean bl5;
            stringArray = new String[]{"defaultValues", "--hide-commands"};
            JsonElement jsonElement = lspCliSettings.getValue(stringArray);
            bl2 = this.hideCommands = jsonElement == null ? false : (bl5 = jsonElement.getAsBoolean());
        }
        if (parseResult.hasMatchedOption("--verbose")) {
            object = parseResult.matchedOptionValue("--verbose", (Object)false);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n      parseResult.matc\u2026\"--verbose\", false)\n    }");
            bl = (Boolean)object;
        } else {
            boolean bl6;
            String[] stringArray3 = new String[]{"defaultValues", "--verbose"};
            JsonElement jsonElement = lspCliSettings.getValue(stringArray3);
            bl = jsonElement == null ? false : (bl6 = jsonElement.getAsBoolean());
        }
        this.verbose = bl;
        object = parseResult.matchedPositionals();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parseResult.matchedPositionals()");
        if (!((Collection)object).isEmpty()) {
            object = ((CommandLine.Model.PositionalParamSpec)parseResult.matchedPositionals().get(0)).getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parseResult.matchedPositionals()[0].getValue()");
            this.inputFilePaths = (List)object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Integer call() {
        List<String> list;
        if (this.verbose) {
            Level level = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"INFO");
            Logging.INSTANCE.setLogLevel(level);
        }
        if ((list = this.serverCommandLineList) == null) {
            List list2;
            String string = this.serverCommandLineString;
            if (string == null) {
                list2 = null;
            } else {
                void $this$mapTo$iv$iv;
                String serverCommandLineString = string;
                boolean bl = false;
                Iterable $this$map$iv = Regex.split$default((Regex)NON_ESCAPED_SPACE_REGEX, (CharSequence)serverCommandLineString, (int)0, (int)2, null);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(ESCAPED_SPACE_REGEX.replace((CharSequence)it, " "));
                }
                list2 = (List)destination$iv$iv;
            }
            List list3 = list2;
            if (list3 == null) {
                Object[] objectArray = new Object[]{"--server-command-line"};
                throw new IllegalArgumentException(I18n.INSTANCE.format("requiredArgumentNotSpecified", objectArray));
            }
            list = list3;
        }
        List<String> serverCommandLine = list;
        LspCliLanguageClient client = new LspCliLanguageClient(serverCommandLine, this.serverWorkingDirPath, this.clientConfigurationFilePath);
        try {
            Checker checker = new Checker(client, this.hideCommands);
            int numberOfMatches = checker.check(this.inputFilePaths);
            Integer n = numberOfMatches == 0 ? 0 : 3;
            return n;
        }
        finally {
            client.getLanguageServer().shutdown();
            client.getLanguageServerProcess().destroy();
        }
    }

    @JvmStatic
    public static final void main(@NotNull String[] arguments) {
        Companion.main(arguments);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002JF\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00122\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u00142\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0014H\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u001b\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u001bH\u0007\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/bsplines/lspcli/LspCliLauncher$Companion;", "", "()V", "ESCAPED_SPACE_REGEX", "Lkotlin/text/Regex;", "EXIT_CODE_MATCHES_FOUND", "", "NON_ESCAPED_SPACE_REGEX", "NON_ESCAPED_SPACE_REGEX_STRING", "", "createCommandLine", "Lpicocli/CommandLine;", "lspCliSettings", "Lorg/bsplines/lspcli/tools/LspCliSettings;", "createOptionSpec", "Lpicocli/CommandLine$Model$OptionSpec;", "classOptionSpec", "defaultValues", "", "hiddenArguments", "", "visibleArguments", "getLspCliSettingsFilePath", "Ljava/nio/file/Path;", "main", "", "arguments", "", "([Ljava/lang/String;)V", "lspcli"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] arguments) {
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            AnsiConsole.systemInstall();
            Path lspCliSettingsFilePath = this.getLspCliSettingsFilePath();
            LspCliSettings lspCliSettings = new LspCliSettings(lspCliSettingsFilePath);
            CommandLine commandLine = this.createCommandLine(lspCliSettings);
            CommandLine.Model.CommandSpec commandSpec = commandLine.getCommandSpec();
            Intrinsics.checkNotNullExpressionValue((Object)commandSpec, (String)"commandLine.commandSpec");
            CommandLine.Model.CommandSpec commandSpec2 = commandSpec;
            try {
                CommandLine.ParseResult parseResult = commandLine.parseArgs(Arrays.copyOf(arguments, arguments.length));
                Intrinsics.checkNotNullExpressionValue((Object)parseResult, (String)"commandLine.parseArgs(*arguments)");
                CommandLine.ParseResult parseResult2 = parseResult;
                if (parseResult2.isUsageHelpRequested()) {
                    commandLine.usage(commandLine.getOut());
                    System.exit(commandSpec2.exitCodeOnUsageHelp());
                    throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                }
                if (parseResult2.isVersionHelpRequested()) {
                    commandLine.printVersionHelp(commandLine.getOut());
                    System.exit(commandSpec2.exitCodeOnVersionHelp());
                    throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                }
                LspCliLauncher launcher = new LspCliLauncher(parseResult2, lspCliSettings);
                int exitCode = launcher.call();
                if (exitCode != 0) {
                    System.exit(exitCode);
                    throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                }
            }
            catch (CommandLine.ParameterException e) {
                commandLine.getErr().println(e.getMessage());
                if (!CommandLine.UnmatchedArgumentException.printSuggestions((CommandLine.ParameterException)e, (PrintWriter)commandLine.getErr())) {
                    e.getCommandLine().usage(commandLine.getErr());
                }
                System.exit(commandSpec2.exitCodeOnInvalidInput());
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            catch (Exception e) {
                e.printStackTrace(commandLine.getErr());
                System.exit(commandSpec2.exitCodeOnExecutionException());
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
        }

        private final Path getLspCliSettingsFilePath() {
            Object object;
            Path path;
            String[] stringArray;
            Path path2;
            String environmentVariable;
            String string = System.getenv("LSP_CLI_JSON_SETTINGS_PATH");
            if (string == null) {
                string = "";
            }
            if (((CharSequence)(environmentVariable = string)).length() > 0) {
                path2 = Path.of(environmentVariable, new String[0]);
            } else {
                stringArray = System.getProperty("app.home", "");
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getProperty(\"app.home\", \"\")");
                String[] appHome = stringArray;
                if (((CharSequence)appHome).length() > 0) {
                    stringArray = new String[]{"bin"};
                    path2 = Path.of((String)appHome, stringArray);
                } else {
                    path2 = path = null;
                }
            }
            if (path == null) {
                object = null;
            } else if (path.toFile().isFile()) {
                object = path;
            } else if (path.toFile().isDirectory()) {
                stringArray = path.resolve(".lsp-cli.json");
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"path.resolve(\".lsp-cli.json\")");
                String[] filePath = stringArray;
                object = filePath.toFile().isFile() ? filePath : null;
            } else {
                object = null;
            }
            return object;
        }

        private final CommandLine createCommandLine(LspCliSettings lspCliSettings) {
            String string;
            Object object2;
            String usageMessageDescription;
            String[] stringArray = new String[]{"defaultValues"};
            Map<String, JsonElement> defaultValues = lspCliSettings.getValueAsMap(stringArray);
            String[] stringArray2 = new String[]{"helpMessage", "hiddenArguments"};
            List<String> hiddenArguments = lspCliSettings.getValueAsListOfString(stringArray2);
            String[] stringArray3 = new String[]{"helpMessage", "visibleArguments"};
            List<String> visibleArguments = lspCliSettings.getValueAsListOfString(stringArray3);
            CommandLine.Model.CommandSpec classCommandSpec = CommandLine.Model.CommandSpec.forAnnotatedObject((Object)new LspCliLauncher());
            CommandLine.Model.CommandSpec commandSpec = CommandLine.Model.CommandSpec.create();
            commandSpec.usageMessage(classCommandSpec.usageMessage());
            String[] stringArray4 = new String[]{"helpMessage", "description"};
            JsonElement jsonElement = lspCliSettings.getValue(stringArray4);
            String string2 = usageMessageDescription = jsonElement == null ? null : jsonElement.getAsString();
            if (usageMessageDescription != null) {
                String[] stringArray5 = new String[]{usageMessageDescription};
                commandSpec.usageMessage().description(stringArray5);
            }
            for (Object object2 : classCommandSpec.options()) {
                Intrinsics.checkNotNullExpressionValue(object2, (String)"classCommandSpec.options()");
                CommandLine.Model.OptionSpec classOptionSpec = (CommandLine.Model.OptionSpec)object2;
                commandSpec.addOption(this.createOptionSpec(classOptionSpec, defaultValues, hiddenArguments, visibleArguments));
            }
            for (Object object2 : classCommandSpec.positionalParameters()) {
                Intrinsics.checkNotNullExpressionValue(object2, (String)"classCommandSpec.positionalParameters()");
                CommandLine.Model.PositionalParamSpec positionalParamSpec = (CommandLine.Model.PositionalParamSpec)object2;
                commandSpec.addPositional(positionalParamSpec);
            }
            CommandLine commandLine = new CommandLine((Object)commandSpec);
            object2 = new String[]{"programName"};
            JsonElement jsonElement2 = lspCliSettings.getValue((String)object2);
            if (jsonElement2 == null) {
                string = "lsp-cli";
            } else {
                string = jsonElement2.getAsString();
                if (string == null) {
                    string = "lsp-cli";
                }
            }
            commandLine.setCommandName(string);
            commandLine.setCaseInsensitiveEnumValuesAllowed(true);
            return commandLine;
        }

        private final CommandLine.Model.OptionSpec createOptionSpec(CommandLine.Model.OptionSpec classOptionSpec, Map<String, ? extends Object> defaultValues, List<String> hiddenArguments, List<String> visibleArguments) {
            int n;
            int n2;
            String[] stringArray = classOptionSpec.toBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"classOptionSpec.toBuilder()");
            String[] optionSpecBuilder = stringArray;
            if (defaultValues != null) {
                String[] stringArray2 = optionSpecBuilder.names();
                Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"optionSpecBuilder.names()");
                stringArray = stringArray2;
                n2 = stringArray.length;
                for (int i = 0; i < n2; ++i) {
                    String string = stringArray[i];
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"optionSpecBuilder.names()");
                    String name = string;
                    Object object = defaultValues.get(name);
                    String defaultValueString = object == null ? null : object.toString();
                    if (defaultValueString == null) continue;
                    optionSpecBuilder.defaultValue(defaultValueString);
                }
            }
            if (visibleArguments != null) {
                n = !visibleArguments.contains(classOptionSpec.longestName()) ? 1 : 0;
            } else {
                List<String> list = hiddenArguments;
                n = list == null ? 0 : (n2 = list.contains(classOptionSpec.longestName()));
            }
            int hidden = n;
            optionSpecBuilder.hidden(hidden != 0);
            CommandLine.Model.OptionSpec optionSpec = optionSpecBuilder.build();
            Intrinsics.checkNotNullExpressionValue((Object)optionSpec, (String)"optionSpecBuilder.build()");
            return optionSpec;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

