/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.ltexls.tools;

import java.util.HashSet;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011J\u0016\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lorg/bsplines/ltexls/tools/Tools;", "", "()V", "MAX_EXCEPTION_DEPTH", "", "RANDOM_NUMBER_GENERATOR", "Ljava/util/Random;", "getRANDOM_NUMBER_GENERATOR", "()Ljava/util/Random;", "areRangesIntersecting", "", "range1", "Lorg/eclipse/lsp4j/Range;", "range2", "getRandomUuid", "", "getRootCauseOfThrowable", "", "throwable", "positionLower", "position1", "Lorg/eclipse/lsp4j/Position;", "position2", "rethrowCancellationException", "", "ltexls"})
public final class Tools {
    @NotNull
    public static final Tools INSTANCE = new Tools();
    private static final int MAX_EXCEPTION_DEPTH = 100;
    @NotNull
    private static final Random RANDOM_NUMBER_GENERATOR = new Random();

    private Tools() {
    }

    @NotNull
    public final Random getRANDOM_NUMBER_GENERATOR() {
        return RANDOM_NUMBER_GENERATOR;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean areRangesIntersecting(@NotNull Range range1, @NotNull Range range2) {
        Intrinsics.checkNotNullParameter((Object)range1, (String)"range1");
        Intrinsics.checkNotNullParameter((Object)range2, (String)"range2");
        Position position = range2.getEnd();
        Intrinsics.checkNotNullExpressionValue((Object)position, (String)"range2.end");
        Position position2 = range1.getStart();
        Intrinsics.checkNotNullExpressionValue((Object)position2, (String)"range1.start");
        if (this.positionLower(position, position2)) return false;
        Position position3 = range1.getEnd();
        Intrinsics.checkNotNullExpressionValue((Object)position3, (String)"range1.end");
        Position position4 = range2.getStart();
        Intrinsics.checkNotNullExpressionValue((Object)position4, (String)"range2.start");
        if (this.positionLower(position3, position4)) return false;
        return true;
    }

    public final boolean positionLower(@NotNull Position position1, @NotNull Position position2) {
        Intrinsics.checkNotNullParameter((Object)position1, (String)"position1");
        Intrinsics.checkNotNullParameter((Object)position2, (String)"position2");
        return position1.getLine() < position2.getLine() || position1.getLine() == position2.getLine() && position1.getCharacter() < position2.getCharacter();
    }

    @NotNull
    public final String getRandomUuid() {
        String string = new UUID(RANDOM_NUMBER_GENERATOR.nextLong(), RANDOM_NUMBER_GENERATOR.nextLong()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UUID(RANDOM_NUMBER_GENER\u2026OR.nextLong()).toString()");
        return string;
    }

    @Nullable
    public final Throwable getRootCauseOfThrowable(@Nullable Throwable throwable) {
        Throwable newCause;
        if (throwable == null) {
            return null;
        }
        HashSet<Throwable> ancestors = new HashSet<Throwable>();
        Throwable cause = throwable;
        ancestors.add(throwable);
        for (int i = 0; i < 100 && (newCause = cause.getCause()) != null && !ancestors.contains(newCause); ++i) {
            cause = newCause;
            ancestors.add(newCause);
        }
        return cause;
    }

    public final void rethrowCancellationException(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        Throwable rootCause = this.getRootCauseOfThrowable(throwable);
        if (rootCause != null && rootCause instanceof CancellationException) {
            throw rootCause;
        }
    }
}

