/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.ltexls.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bsplines.ltexls.client.LtexLanguageClient;
import org.bsplines.ltexls.languagetool.LanguageToolRuleMatch;
import org.bsplines.ltexls.parsing.AnnotatedTextFragment;
import org.bsplines.ltexls.server.CompletionListProvider;
import org.bsplines.ltexls.server.LtexLanguageServer;
import org.bsplines.ltexls.server.LtexTextDocumentItem;
import org.bsplines.ltexls.settings.Settings;
import org.bsplines.ltexls.tools.I18n;
import org.bsplines.ltexls.tools.Logging;
import org.bsplines.ltexls.tools.Tools;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.CompletableFutures;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\r\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00100\u000f0\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J(\u0010\u0015\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u000f\u0012\u0004\u0012\u00020\u00170\u00100\u000e2\u0006\u0010\u0013\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020!H\u0016J\u001a\u0010\"\u001a\u00020\u001a2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001a0$J\u0012\u0010%\u001a\u0004\u0018\u00010\b2\u0006\u0010&\u001a\u00020\u0007H\u0002R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006'"}, d2={"Lorg/bsplines/ltexls/server/LtexTextDocumentService;", "Lorg/eclipse/lsp4j/services/TextDocumentService;", "languageServer", "Lorg/bsplines/ltexls/server/LtexLanguageServer;", "(Lorg/bsplines/ltexls/server/LtexLanguageServer;)V", "documents", "", "", "Lorg/bsplines/ltexls/server/LtexTextDocumentItem;", "getDocuments", "()Ljava/util/Map;", "getLanguageServer", "()Lorg/bsplines/ltexls/server/LtexLanguageServer;", "codeAction", "Ljava/util/concurrent/CompletableFuture;", "", "Lorg/eclipse/lsp4j/jsonrpc/messages/Either;", "Lorg/eclipse/lsp4j/Command;", "Lorg/eclipse/lsp4j/CodeAction;", "params", "Lorg/eclipse/lsp4j/CodeActionParams;", "completion", "Lorg/eclipse/lsp4j/CompletionItem;", "Lorg/eclipse/lsp4j/CompletionList;", "Lorg/eclipse/lsp4j/CompletionParams;", "didChange", "", "Lorg/eclipse/lsp4j/DidChangeTextDocumentParams;", "didClose", "Lorg/eclipse/lsp4j/DidCloseTextDocumentParams;", "didOpen", "Lorg/eclipse/lsp4j/DidOpenTextDocumentParams;", "didSave", "Lorg/eclipse/lsp4j/DidSaveTextDocumentParams;", "executeFunctionForEachDocument", "function", "Lkotlin/Function1;", "getDocument", "uri", "ltexls"})
@SourceDebugExtension(value={"SMAP\nLtexTextDocumentService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LtexTextDocumentService.kt\norg/bsplines/ltexls/server/LtexTextDocumentService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,212:1\n1855#2,2:213\n*S KotlinDebug\n*F\n+ 1 LtexTextDocumentService.kt\norg/bsplines/ltexls/server/LtexTextDocumentService\n*L\n209#1:213,2\n*E\n"})
public final class LtexTextDocumentService
implements TextDocumentService {
    @NotNull
    private final LtexLanguageServer languageServer;
    @NotNull
    private final Map<String, LtexTextDocumentItem> documents;

    public LtexTextDocumentService(@NotNull LtexLanguageServer languageServer) {
        Intrinsics.checkNotNullParameter((Object)languageServer, (String)"languageServer");
        this.languageServer = languageServer;
        this.documents = new HashMap();
    }

    @NotNull
    public final LtexLanguageServer getLanguageServer() {
        return this.languageServer;
    }

    @NotNull
    public final Map<String, LtexTextDocumentItem> getDocuments() {
        return this.documents;
    }

    @NotNull
    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(@NotNull CompletionParams params) {
        CompletableFuture<Either<List<CompletionItem>, CompletionList>> completableFuture;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (this.languageServer.getSettingsManager().getSettings().getCompletionEnabled()) {
            TextDocumentIdentifier textDocumentIdentifier = params.getTextDocument();
            String string = textDocumentIdentifier != null ? textDocumentIdentifier.getUri() : null;
            if (string == null) {
                CompletableFuture<Either<List<CompletionItem>, CompletionList>> completableFuture2 = CompletableFuture.completedFuture(Either.forLeft((Object)CollectionsKt.emptyList()));
                Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"completedFuture(\n       \u2026eft(emptyList()),\n      )");
                return completableFuture2;
            }
            String uri = string;
            LtexTextDocumentItem ltexTextDocumentItem = this.getDocument(uri);
            if (ltexTextDocumentItem == null) {
                LtexTextDocumentService $this$completion_u24lambda_u240 = this;
                boolean bl = false;
                Object[] objectArray = new Object[]{uri};
                Logging.INSTANCE.getLOGGER().warning(I18n.INSTANCE.format("couldNotFindDocumentWithUri", objectArray));
                CompletableFuture<Either<List<CompletionItem>, CompletionList>> completableFuture3 = CompletableFuture.completedFuture(Either.forLeft((Object)CollectionsKt.emptyList()));
                Intrinsics.checkNotNullExpressionValue(completableFuture3, (String)"completedFuture(Either.forLeft(emptyList()))");
                return completableFuture3;
            }
            LtexTextDocumentItem document = ltexTextDocumentItem;
            CompletionListProvider completionListProvider = this.languageServer.getCompletionListProvider();
            Position position = params.getPosition();
            Intrinsics.checkNotNullExpressionValue((Object)position, (String)"params.position");
            CompletableFuture<Either> completableFuture4 = CompletableFuture.completedFuture(Either.forRight((Object)completionListProvider.createCompletionList(document, position)));
            Intrinsics.checkNotNullExpressionValue(completableFuture4, (String)"{\n      val uri: String \u2026\n        ),\n      )\n    }");
            completableFuture = completableFuture4;
        } else {
            CompletableFuture<Either<List<CompletionItem>, CompletionList>> completableFuture5 = CompletableFuture.completedFuture(Either.forLeft((Object)CollectionsKt.emptyList()));
            completableFuture = completableFuture5;
            Intrinsics.checkNotNullExpressionValue(completableFuture5, (String)"{\n      CompletableFutur\u2026rLeft(emptyList()))\n    }");
        }
        return completableFuture;
    }

    public void didOpen(@NotNull DidOpenTextDocumentParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        String string = params.getTextDocument().getUri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"params.textDocument.uri");
        String uri = string;
        Map<String, LtexTextDocumentItem> map = this.documents;
        TextDocumentItem textDocumentItem = params.getTextDocument();
        Intrinsics.checkNotNullExpressionValue((Object)textDocumentItem, (String)"params.textDocument");
        LtexTextDocumentItem ltexTextDocumentItem = new LtexTextDocumentItem(this.languageServer, textDocumentItem);
        map.put(uri, ltexTextDocumentItem);
        LtexTextDocumentItem ltexTextDocumentItem2 = this.getDocument(uri);
        if (ltexTextDocumentItem2 == null) {
            return;
        }
        LtexTextDocumentItem document = ltexTextDocumentItem2;
        if (this.languageServer.getSettingsManager().getSettings().getCheckFrequency() != Settings.CheckFrequency.Manual) {
            this.languageServer.getSingleThreadExecutorService().execute(() -> LtexTextDocumentService.didOpen$lambda$1(document));
        }
    }

    public void didClose(@NotNull DidCloseTextDocumentParams params) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            String string = params.getTextDocument().getUri();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"params.textDocument.uri");
            String uri = string;
            if (this.getDocument(uri) == null) {
                return;
            }
            this.documents.remove(uri);
            if (!this.languageServer.getSettingsManager().getSettings().getClearDiagnosticsWhenClosingFile()) break block2;
            LtexLanguageClient ltexLanguageClient = this.languageServer.getLanguageClient();
            if (ltexLanguageClient != null) {
                ltexLanguageClient.publishDiagnostics(new PublishDiagnosticsParams(uri, CollectionsKt.emptyList()));
            }
        }
    }

    public void didSave(@NotNull DidSaveTextDocumentParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (this.languageServer.getSettingsManager().getSettings().getCheckFrequency() != Settings.CheckFrequency.Save) {
            return;
        }
        String string = params.getTextDocument().getUri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"params.textDocument.uri");
        String uri = string;
        LtexTextDocumentItem ltexTextDocumentItem = this.getDocument(uri);
        if (ltexTextDocumentItem == null) {
            return;
        }
        LtexTextDocumentItem document = ltexTextDocumentItem;
        if (document.getBeingChecked()) {
            document.cancelCheck();
        }
        this.languageServer.getSingleThreadExecutorService().execute(() -> LtexTextDocumentService.didSave$lambda$2(document));
    }

    public void didChange(@NotNull DidChangeTextDocumentParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        String string = params.getTextDocument().getUri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"params.textDocument.uri");
        String uri = string;
        LtexTextDocumentItem ltexTextDocumentItem = this.getDocument(uri);
        if (ltexTextDocumentItem == null) {
            return;
        }
        LtexTextDocumentItem document = ltexTextDocumentItem;
        if (document.getBeingChecked()) {
            document.cancelCheck();
        }
        this.languageServer.getSingleThreadExecutorService().execute(() -> LtexTextDocumentService.didChange$lambda$3(document, params, this));
    }

    @NotNull
    public CompletableFuture<List<Either<Command, CodeAction>>> codeAction(@NotNull CodeActionParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (params.getContext().getDiagnostics().isEmpty()) {
            CompletableFuture<List<Either<Command, CodeAction>>> completableFuture = CompletableFuture.completedFuture(CollectionsKt.emptyList());
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(emptyList())");
            return completableFuture;
        }
        String string = params.getTextDocument().getUri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"params.textDocument.uri");
        String uri = string;
        LtexTextDocumentItem ltexTextDocumentItem = this.getDocument(uri);
        if (ltexTextDocumentItem == null) {
            LtexTextDocumentService $this$codeAction_u24lambda_u244 = this;
            boolean bl = false;
            Object[] objectArray = new Object[]{uri};
            Logging.INSTANCE.getLOGGER().warning(I18n.INSTANCE.format("couldNotFindDocumentWithUri", objectArray));
            CompletableFuture<List<Either<Command, CodeAction>>> completableFuture = CompletableFuture.completedFuture(CollectionsKt.emptyList());
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(emptyList())");
            return completableFuture;
        }
        LtexTextDocumentItem document = ltexTextDocumentItem;
        CompletableFuture completableFuture = CompletableFutures.computeAsync((Executor)this.languageServer.getSingleThreadExecutorService(), arg_0 -> LtexTextDocumentService.codeAction$lambda$5(document, this, params, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"computeAsync(this.langua\u2026emptyList()\n      }\n    }");
        return completableFuture;
    }

    private final LtexTextDocumentItem getDocument(String uri) {
        LtexTextDocumentItem ltexTextDocumentItem = this.documents.get(uri);
        if (ltexTextDocumentItem == null) {
            LtexTextDocumentService $this$getDocument_u24lambda_u246 = this;
            boolean bl = false;
            Object[] objectArray = new Object[]{uri};
            Logging.INSTANCE.getLOGGER().warning(I18n.INSTANCE.format("couldNotFindDocumentWithUri", objectArray));
            ltexTextDocumentItem = null;
        }
        return ltexTextDocumentItem;
    }

    public final void executeFunctionForEachDocument(@NotNull Function1<? super LtexTextDocumentItem, Unit> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        Iterable $this$forEach$iv = this.documents.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            function.invoke(element$iv);
        }
    }

    private static final void didOpen$lambda$1(LtexTextDocumentItem $document) {
        Intrinsics.checkNotNullParameter((Object)((Object)$document), (String)"$document");
        Exception exception = null;
        try {
            LtexTextDocumentItem.checkAndPublishDiagnosticsWithoutCache$default($document, null, 1, null);
            $document.raiseExceptionIfCanceled();
        }
        catch (ExecutionException e) {
            exception = e;
        }
        catch (InterruptedException e) {
            exception = e;
        }
        if (exception != null) {
            Tools.INSTANCE.rethrowCancellationException(exception);
            Logging.INSTANCE.getLOGGER().warning(I18n.INSTANCE.format(exception));
        }
    }

    private static final void didSave$lambda$2(LtexTextDocumentItem $document) {
        Intrinsics.checkNotNullParameter((Object)((Object)$document), (String)"$document");
        Exception exception = null;
        try {
            LtexTextDocumentItem.checkAndPublishDiagnosticsWithoutCache$default($document, null, 1, null);
            $document.raiseExceptionIfCanceled();
        }
        catch (ExecutionException e) {
            exception = e;
        }
        catch (InterruptedException e) {
            exception = e;
        }
        if (exception != null) {
            Tools.INSTANCE.rethrowCancellationException(exception);
            Logging.INSTANCE.getLOGGER().warning(I18n.INSTANCE.format(exception));
        }
    }

    private static final void didChange$lambda$3(LtexTextDocumentItem $document, DidChangeTextDocumentParams $params, LtexTextDocumentService this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)$document), (String)"$document");
        Intrinsics.checkNotNullParameter((Object)$params, (String)"$params");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        List list = $params.getContentChanges();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"params.contentChanges");
        $document.applyTextChangeEvents(list);
        Integer n = $params.getTextDocument().getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"params.textDocument.version");
        $document.setVersion(((Number)n).intValue());
        if (this$0.languageServer.getSettingsManager().getSettings().getCheckFrequency() == Settings.CheckFrequency.Edit) {
            Exception exception = null;
            try {
                LtexTextDocumentItem.checkAndPublishDiagnosticsWithoutCache$default($document, null, 1, null);
                $document.raiseExceptionIfCanceled();
            }
            catch (ExecutionException e) {
                exception = e;
            }
            catch (InterruptedException e) {
                exception = e;
            }
            if (exception != null) {
                Tools.INSTANCE.rethrowCancellationException(exception);
                Logging.INSTANCE.getLOGGER().warning(I18n.INSTANCE.format(exception));
            }
        }
    }

    private static final List codeAction$lambda$5(LtexTextDocumentItem $document, LtexTextDocumentService this$0, CodeActionParams $params, CancelChecker lspCancelChecker) {
        List<Either<Command, CodeAction>> list;
        Intrinsics.checkNotNullParameter((Object)((Object)$document), (String)"$document");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$params, (String)"$params");
        Intrinsics.checkNotNullParameter((Object)lspCancelChecker, (String)"lspCancelChecker");
        $document.setLspCancelChecker(lspCancelChecker);
        try {
            Pair checkingResult = LtexTextDocumentItem.checkWithCache$default($document, null, 1, null);
            List<Either<Command, CodeAction>> codeActions = this$0.languageServer.getCodeActionProvider().generate($params, $document, (Pair<? extends List<LanguageToolRuleMatch>, ? extends List<AnnotatedTextFragment>>)checkingResult);
            $document.raiseExceptionIfCanceled();
            list = codeActions;
        }
        catch (ExecutionException e) {
            Tools.INSTANCE.rethrowCancellationException(e);
            Logging.INSTANCE.getLOGGER().warning(I18n.INSTANCE.format(e));
            list = CollectionsKt.emptyList();
        }
        catch (InterruptedException e) {
            Tools.INSTANCE.rethrowCancellationException(e);
            Logging.INSTANCE.getLOGGER().warning(I18n.INSTANCE.format(e));
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

