/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.ltexls.server;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.time.Instant;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bsplines.ltexls.client.LtexLanguageClient;
import org.bsplines.ltexls.server.CodeActionProvider;
import org.bsplines.ltexls.server.CompletionListProvider;
import org.bsplines.ltexls.server.DocumentChecker;
import org.bsplines.ltexls.server.LtexTextDocumentService;
import org.bsplines.ltexls.server.LtexWorkspaceService;
import org.bsplines.ltexls.settings.SettingsManager;
import org.bsplines.ltexls.tools.I18n;
import org.bsplines.ltexls.tools.Logging;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.CodeActionOptions;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.WindowClientCapabilities;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u00101\u001a\u0002022\u0006\u0010\u0017\u001a\u000203H\u0016J\b\u00104\u001a\u000202H\u0016J\b\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u000208H\u0016J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020;0:2\u0006\u0010<\u001a\u00020=H\u0016J\u000e\u0010>\u001a\b\u0012\u0004\u0012\u00020?0:H\u0016R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020.\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100\u00a8\u0006@"}, d2={"Lorg/bsplines/ltexls/server/LtexLanguageServer;", "Lorg/eclipse/lsp4j/services/LanguageServer;", "Lorg/eclipse/lsp4j/services/LanguageClientAware;", "()V", "<set-?>", "", "clientSupportsWorkDoneProgress", "getClientSupportsWorkDoneProgress", "()Z", "clientSupportsWorkspaceSpecificConfiguration", "getClientSupportsWorkspaceSpecificConfiguration", "codeActionProvider", "Lorg/bsplines/ltexls/server/CodeActionProvider;", "getCodeActionProvider", "()Lorg/bsplines/ltexls/server/CodeActionProvider;", "completionListProvider", "Lorg/bsplines/ltexls/server/CompletionListProvider;", "getCompletionListProvider", "()Lorg/bsplines/ltexls/server/CompletionListProvider;", "documentChecker", "Lorg/bsplines/ltexls/server/DocumentChecker;", "getDocumentChecker", "()Lorg/bsplines/ltexls/server/DocumentChecker;", "languageClient", "Lorg/bsplines/ltexls/client/LtexLanguageClient;", "getLanguageClient", "()Lorg/bsplines/ltexls/client/LtexLanguageClient;", "setLanguageClient", "(Lorg/bsplines/ltexls/client/LtexLanguageClient;)V", "ltexTextDocumentService", "Lorg/bsplines/ltexls/server/LtexTextDocumentService;", "getLtexTextDocumentService", "()Lorg/bsplines/ltexls/server/LtexTextDocumentService;", "ltexWorkspaceService", "Lorg/bsplines/ltexls/server/LtexWorkspaceService;", "getLtexWorkspaceService", "()Lorg/bsplines/ltexls/server/LtexWorkspaceService;", "settingsManager", "Lorg/bsplines/ltexls/settings/SettingsManager;", "getSettingsManager", "()Lorg/bsplines/ltexls/settings/SettingsManager;", "singleThreadExecutorService", "Ljava/util/concurrent/ExecutorService;", "getSingleThreadExecutorService", "()Ljava/util/concurrent/ExecutorService;", "startupInstant", "Ljava/time/Instant;", "getStartupInstant", "()Ljava/time/Instant;", "connect", "", "Lorg/eclipse/lsp4j/services/LanguageClient;", "exit", "getTextDocumentService", "Lorg/eclipse/lsp4j/services/TextDocumentService;", "getWorkspaceService", "Lorg/eclipse/lsp4j/services/WorkspaceService;", "initialize", "Ljava/util/concurrent/CompletableFuture;", "Lorg/eclipse/lsp4j/InitializeResult;", "params", "Lorg/eclipse/lsp4j/InitializeParams;", "shutdown", "", "ltexls"})
public final class LtexLanguageServer
implements LanguageServer,
LanguageClientAware {
    @Nullable
    private LtexLanguageClient languageClient;
    @NotNull
    private final ExecutorService singleThreadExecutorService;
    @NotNull
    private final SettingsManager settingsManager;
    @NotNull
    private final DocumentChecker documentChecker;
    @NotNull
    private final CodeActionProvider codeActionProvider;
    @NotNull
    private final CompletionListProvider completionListProvider;
    @NotNull
    private final LtexTextDocumentService ltexTextDocumentService;
    @NotNull
    private final LtexWorkspaceService ltexWorkspaceService;
    @NotNull
    private final Instant startupInstant;
    private boolean clientSupportsWorkDoneProgress;
    private boolean clientSupportsWorkspaceSpecificConfiguration;

    public LtexLanguageServer() {
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newSingleThreadScheduledExecutor()");
        this.singleThreadExecutorService = scheduledExecutorService;
        this.settingsManager = new SettingsManager();
        this.documentChecker = new DocumentChecker(this.settingsManager);
        this.codeActionProvider = new CodeActionProvider(this.settingsManager);
        this.completionListProvider = new CompletionListProvider(this.settingsManager);
        this.ltexTextDocumentService = new LtexTextDocumentService(this);
        this.ltexWorkspaceService = new LtexWorkspaceService(this);
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        this.startupInstant = instant;
    }

    @Nullable
    public final LtexLanguageClient getLanguageClient() {
        return this.languageClient;
    }

    public final void setLanguageClient(@Nullable LtexLanguageClient ltexLanguageClient) {
        this.languageClient = ltexLanguageClient;
    }

    @NotNull
    public final ExecutorService getSingleThreadExecutorService() {
        return this.singleThreadExecutorService;
    }

    @NotNull
    public final SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    @NotNull
    public final DocumentChecker getDocumentChecker() {
        return this.documentChecker;
    }

    @NotNull
    public final CodeActionProvider getCodeActionProvider() {
        return this.codeActionProvider;
    }

    @NotNull
    public final CompletionListProvider getCompletionListProvider() {
        return this.completionListProvider;
    }

    @NotNull
    public final LtexTextDocumentService getLtexTextDocumentService() {
        return this.ltexTextDocumentService;
    }

    @NotNull
    public final LtexWorkspaceService getLtexWorkspaceService() {
        return this.ltexWorkspaceService;
    }

    @NotNull
    public final Instant getStartupInstant() {
        return this.startupInstant;
    }

    public final boolean getClientSupportsWorkDoneProgress() {
        return this.clientSupportsWorkDoneProgress;
    }

    public final boolean getClientSupportsWorkspaceSpecificConfiguration() {
        return this.clientSupportsWorkspaceSpecificConfiguration;
    }

    @NotNull
    public CompletableFuture<InitializeResult> initialize(@NotNull InitializeParams params) {
        WindowClientCapabilities windowClientCapabilities;
        Package ltexLsPackage;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Package package_ = ltexLsPackage = LtexLanguageServer.class.getPackage();
        String string = package_ != null ? package_.getImplementationVersion() : null;
        if (string == null) {
            string = "null";
        }
        String ltexLsVersion = string;
        Object[] objectArray = new Object[]{ltexLsVersion};
        Logging.INSTANCE.getLOGGER().info(I18n.INSTANCE.format("initializingLtexLs", objectArray));
        ClientCapabilities clientCapabilities = params.getCapabilities();
        this.clientSupportsWorkDoneProgress = false;
        if (clientCapabilities != null && (windowClientCapabilities = clientCapabilities.getWindow()) != null) {
            Boolean bl = windowClientCapabilities.getWorkDoneProgress();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"windowClientCapabilities.workDoneProgress");
            if (bl.booleanValue()) {
                this.clientSupportsWorkDoneProgress = true;
            }
        }
        String localeLanguage = params.getLocale();
        JsonElement initializationOptions = (JsonElement)params.getInitializationOptions();
        if (initializationOptions != null && initializationOptions.isJsonObject()) {
            JsonObject jsonObject = initializationOptions.getAsJsonObject();
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"initializationOptions.asJsonObject");
            JsonObject initializationOptionsObject = jsonObject;
            if (initializationOptionsObject.has("locale")) {
                localeLanguage = initializationOptionsObject.get("locale").getAsString();
            }
            if (initializationOptionsObject.has("customCapabilities")) {
                JsonObject jsonObject2 = initializationOptionsObject.getAsJsonObject("customCapabilities");
                Intrinsics.checkNotNullExpressionValue((Object)jsonObject2, (String)"initializationOptionsObj\u2026ect(\"customCapabilities\")");
                JsonObject customCapabilities = jsonObject2;
                if (customCapabilities.has("workspaceSpecificConfiguration")) {
                    this.clientSupportsWorkspaceSpecificConfiguration = customCapabilities.get("workspaceSpecificConfiguration").getAsBoolean();
                }
            }
        }
        if (localeLanguage != null) {
            Locale locale = Locale.forLanguageTag(localeLanguage);
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"forLanguageTag(localeLanguage)");
            I18n.setLocale$default(I18n.INSTANCE, locale, false, 2, null);
        }
        ServerCapabilities serverCapabilities = new ServerCapabilities();
        serverCapabilities.setCodeActionProvider(Either.forRight((Object)new CodeActionOptions(CodeActionProvider.Companion.getCodeActionKinds())));
        serverCapabilities.setCompletionProvider(new CompletionOptions());
        serverCapabilities.setExecuteCommandProvider(new ExecuteCommandOptions(LtexWorkspaceService.Companion.getCommandNames()));
        serverCapabilities.setTextDocumentSync(Either.forLeft((Object)TextDocumentSyncKind.Full));
        CompletableFuture<InitializeResult> completableFuture = CompletableFuture.completedFuture(new InitializeResult(serverCapabilities));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(Initiali\u2026sult(serverCapabilities))");
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<Object> shutdown() {
        Logging.INSTANCE.getLOGGER().info(I18n.INSTANCE.format("shuttingDownLtexLs", new Object[0]));
        this.singleThreadExecutorService.shutdown();
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(new Object());
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(Object())");
        return completableFuture;
    }

    public void exit() {
        Logging.INSTANCE.getLOGGER().info(I18n.INSTANCE.format("exitingLtexLs", new Object[0]));
        System.exit(0);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    public void connect(@NotNull LanguageClient languageClient) {
        Intrinsics.checkNotNullParameter((Object)languageClient, (String)"languageClient");
        this.languageClient = (LtexLanguageClient)languageClient;
    }

    @NotNull
    public TextDocumentService getTextDocumentService() {
        return this.ltexTextDocumentService;
    }

    @NotNull
    public WorkspaceService getWorkspaceService() {
        return this.ltexWorkspaceService;
    }
}

