/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.ltexls.server;

import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.bsplines.ltexls.parsing.AnnotatedTextFragment;
import org.bsplines.ltexls.parsing.CodeAnnotatedTextBuilder;
import org.bsplines.ltexls.parsing.CodeFragment;
import org.bsplines.ltexls.parsing.CodeFragmentizer;
import org.bsplines.ltexls.server.LtexTextDocumentItem;
import org.bsplines.ltexls.settings.SettingsManager;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.Position;
import org.jetbrains.annotations.NotNull;
import org.languagetool.DetectedLanguage;
import org.languagetool.language.identifier.SimpleLanguageIdentifier;
import org.languagetool.markup.AnnotatedText;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\t\u0018\u0000 !2\u00020\u0001:\u0001!B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016J&\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00182\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\b2\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001d\u001a\u00020\u000eH\u0002J\u0018\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0019H\u0002R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/bsplines/ltexls/server/CompletionListProvider;", "", "settingsManager", "Lorg/bsplines/ltexls/settings/SettingsManager;", "(Lorg/bsplines/ltexls/settings/SettingsManager;)V", "fullCompletionListMap", "", "", "", "getSettingsManager", "()Lorg/bsplines/ltexls/settings/SettingsManager;", "simpleLanguageIdentifier", "Lorg/languagetool/language/identifier/SimpleLanguageIdentifier;", "buildAnnotatedTextFragment", "Lorg/bsplines/ltexls/parsing/AnnotatedTextFragment;", "document", "Lorg/bsplines/ltexls/server/LtexTextDocumentItem;", "codeFragment", "Lorg/bsplines/ltexls/parsing/CodeFragment;", "createCompletionList", "Lorg/eclipse/lsp4j/CompletionList;", "position", "Lorg/eclipse/lsp4j/Position;", "getCodeFragmentFromPosition", "Lkotlin/Pair;", "", "getFullCompletionList", "languageShortCode", "getLanguageShortCode", "annotatedTextFragment", "getPrefixFromPosition", "code", "pos", "Companion", "ltexls"})
public final class CompletionListProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SettingsManager settingsManager;
    @NotNull
    private final Map<String, List<String>> fullCompletionListMap;
    @NotNull
    private final SimpleLanguageIdentifier simpleLanguageIdentifier;
    @NotNull
    private static final Regex LANGUAGE_SHORT_CODE_REGEX = new Regex("^[-A-Za-z]+$");

    public CompletionListProvider(@NotNull SettingsManager settingsManager) {
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        this.settingsManager = settingsManager;
        this.fullCompletionListMap = new HashMap();
        this.simpleLanguageIdentifier = new SimpleLanguageIdentifier();
    }

    @NotNull
    public final SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    @NotNull
    public final CompletionList createCompletionList(@NotNull LtexTextDocumentItem document, @NotNull Position position) {
        Intrinsics.checkNotNullParameter((Object)((Object)document), (String)"document");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Pair<CodeFragment, Integer> pair = this.getCodeFragmentFromPosition(document, position);
        if (pair == null) {
            return new CompletionList(CollectionsKt.emptyList());
        }
        Pair<CodeFragment, Integer> codeFragmentPositionPair = pair;
        AnnotatedTextFragment annotatedTextFragment = this.buildAnnotatedTextFragment(document, (CodeFragment)codeFragmentPositionPair.getFirst());
        String string = this.getLanguageShortCode(annotatedTextFragment);
        if (string == null) {
            return new CompletionList(CollectionsKt.emptyList());
        }
        String languageShortCode = string;
        String prefix = this.getPrefixFromPosition(annotatedTextFragment.getCodeFragment().getCode(), ((Number)codeFragmentPositionPair.getSecond()).intValue());
        if (((CharSequence)prefix).length() == 0) {
            return new CompletionList(CollectionsKt.emptyList());
        }
        List<String> fullCompletionList = this.getFullCompletionList(languageShortCode);
        if (fullCompletionList.isEmpty()) {
            return new CompletionList(CollectionsKt.emptyList());
        }
        ArrayList<CompletionItem> completionList = new ArrayList<CompletionItem>();
        for (String entry : annotatedTextFragment.getCodeFragment().getSettings().getDictionary()) {
            if (!StringsKt.startsWith$default((String)entry, (String)prefix, (boolean)false, (int)2, null)) continue;
            completionList.add(new CompletionItem(entry));
        }
        for (String entry : fullCompletionList) {
            if (!StringsKt.startsWith$default((String)entry, (String)prefix, (boolean)false, (int)2, null)) continue;
            completionList.add(new CompletionItem(entry));
        }
        return new CompletionList((List)completionList);
    }

    private final Pair<CodeFragment, Integer> getCodeFragmentFromPosition(LtexTextDocumentItem document, Position position) {
        String string = document.getLanguageId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"document.languageId");
        CodeFragmentizer codeFragmentizer = CodeFragmentizer.Companion.create(string);
        String string2 = document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"document.text");
        String code = string2;
        List<CodeFragment> codeFragments = codeFragmentizer.fragmentize(code, this.settingsManager.getSettings());
        int pos = document.convertPosition(position);
        CodeFragment matchingCodeFragment = null;
        for (CodeFragment codeFragment : codeFragments) {
            if (codeFragment.getFromPos() > pos || pos >= codeFragment.getFromPos() + codeFragment.getCode().length() || matchingCodeFragment != null && codeFragment.getFromPos() <= matchingCodeFragment.getFromPos()) continue;
            matchingCodeFragment = codeFragment;
        }
        return matchingCodeFragment != null ? new Pair((Object)matchingCodeFragment, (Object)(pos - matchingCodeFragment.getFromPos())) : null;
    }

    private final AnnotatedTextFragment buildAnnotatedTextFragment(LtexTextDocumentItem document, CodeFragment codeFragment) {
        CodeAnnotatedTextBuilder builder = CodeAnnotatedTextBuilder.Companion.create(codeFragment.getCodeLanguageId());
        builder.setSettings(codeFragment.getSettings());
        builder.addCode(codeFragment.getCode());
        AnnotatedText annotatedText = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)annotatedText, (String)"builder.build()");
        AnnotatedText annotatedText2 = annotatedText;
        return new AnnotatedTextFragment(annotatedText2, codeFragment, document);
    }

    private final String getLanguageShortCode(AnnotatedTextFragment annotatedTextFragment) {
        String string;
        if (Intrinsics.areEqual((Object)annotatedTextFragment.getCodeFragment().getSettings().getLanguageShortCode(), (Object)"auto")) {
            String string2 = this.simpleLanguageIdentifier.cleanAndShortenText(annotatedTextFragment.getAnnotatedText().getPlainText());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this.simpleLanguageIdent\u2026edText.plainText,\n      )");
            String cleanText = string2;
            DetectedLanguage detectedLanguage = this.simpleLanguageIdentifier.detectLanguage(cleanText, CollectionsKt.emptyList(), CollectionsKt.emptyList());
            DetectedLanguage detectedLanguage2 = detectedLanguage;
            string = detectedLanguage2 != null && (detectedLanguage2 = detectedLanguage2.getDetectedLanguage()) != null ? detectedLanguage2.getShortCodeWithCountryAndVariant() : null;
        } else {
            string = annotatedTextFragment.getCodeFragment().getSettings().getLanguageShortCode();
        }
        return string;
    }

    private final String getPrefixFromPosition(String code, int pos) {
        if (pos >= code.length()) {
            return "";
        }
        for (int curPos = pos - 1; -1 < curPos; --curPos) {
            char character = code.charAt(curPos);
            if (Character.isLetter(character) || character == '-') continue;
            String string = code.substring(curPos + 1, pos);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            return string;
        }
        String string = code.substring(0, pos);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    private final List<String> getFullCompletionList(String languageShortCode) {
        List list;
        block5: {
            block6: {
                List list2;
                Object completionListText;
                Object object;
                CompletionListProvider $this$getFullCompletionList_u24lambda_u240;
                block8: {
                    block7: {
                        list = this.fullCompletionListMap.get(languageShortCode);
                        if (list != null) break block5;
                        $this$getFullCompletionList_u24lambda_u240 = this;
                        boolean bl = false;
                        if (!LANGUAGE_SHORT_CODE_REGEX.matches((CharSequence)languageShortCode)) break block6;
                        URL uRL = $this$getFullCompletionList_u24lambda_u240.getClass().getResource("/completionList." + languageShortCode + ".txt");
                        object = uRL;
                        if (object == null) break block7;
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getResource(\"/completion\u2026.$languageShortCode.txt\")");
                        URL uRL2 = uRL;
                        Charset charset = Charsets.UTF_8;
                        byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
                        object = ((Object)StringsKt.trim((CharSequence)new String(byArray, charset))).toString();
                        if (object != null) break block8;
                    }
                    object = "";
                }
                if (((CharSequence)(completionListText = object)).length() > 0) {
                    char[] cArray = new char[]{'\n'};
                    list2 = StringsKt.split$default((CharSequence)((CharSequence)completionListText), (char[])cArray, (boolean)false, (int)0, (int)6, null);
                } else {
                    list2 = CollectionsKt.emptyList();
                }
                List fullCompletionList = list2;
                $this$getFullCompletionList_u24lambda_u240.fullCompletionListMap.put(languageShortCode, fullCompletionList);
                list = fullCompletionList;
                break block5;
            }
            list = CollectionsKt.emptyList();
        }
        List fullCompletionList = list;
        return fullCompletionList;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/bsplines/ltexls/server/CompletionListProvider$Companion;", "", "()V", "LANGUAGE_SHORT_CODE_REGEX", "Lkotlin/text/Regex;", "ltexls"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

