/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.ltexls.server;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.bsplines.ltexls.languagetool.LanguageToolRuleMatch;
import org.bsplines.ltexls.parsing.AnnotatedTextFragment;
import org.bsplines.ltexls.parsing.CodeFragment;
import org.bsplines.ltexls.server.LtexTextDocumentItem;
import org.bsplines.ltexls.settings.SettingsManager;
import org.bsplines.ltexls.tools.I18n;
import org.bsplines.ltexls.tools.Logging;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticCodeDescription;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u0000 \"2\u00020\u0001:\u0001\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJH\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f0\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u001e\u0010\u0014\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u000e0\u0015J&\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0002J,\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u000eH\u0002J,\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u000eH\u0002J,\u0010 \u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006#"}, d2={"Lorg/bsplines/ltexls/server/CodeActionProvider;", "", "settingsManager", "Lorg/bsplines/ltexls/settings/SettingsManager;", "(Lorg/bsplines/ltexls/settings/SettingsManager;)V", "getSettingsManager", "()Lorg/bsplines/ltexls/settings/SettingsManager;", "createDiagnostic", "Lorg/eclipse/lsp4j/Diagnostic;", "match", "Lorg/bsplines/ltexls/languagetool/LanguageToolRuleMatch;", "document", "Lorg/bsplines/ltexls/server/LtexTextDocumentItem;", "generate", "", "Lorg/eclipse/lsp4j/jsonrpc/messages/Either;", "Lorg/eclipse/lsp4j/Command;", "Lorg/eclipse/lsp4j/CodeAction;", "params", "Lorg/eclipse/lsp4j/CodeActionParams;", "checkingResult", "Lkotlin/Pair;", "Lorg/bsplines/ltexls/parsing/AnnotatedTextFragment;", "getAcceptSuggestionsCodeAction", "newWord", "", "acceptSuggestionsMatches", "getAddWordToDictionaryCodeAction", "addToDictionaryMatches", "annotatedTextFragments", "getDisableRulesCodeAction", "disableRuleMatches", "getHideFalsePositivesCodeAction", "hideFalsePositivesMatches", "Companion", "ltexls"})
public final class CodeActionProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SettingsManager settingsManager;
    @NotNull
    private static final Regex SUGGESTION_REGEX = new Regex("<suggestion>(.*?)</suggestion>");
    @NotNull
    private static final String ACCEPT_SUGGESTIONS_CODE_ACTION_KIND = "quickfix.ltex.acceptSuggestions";
    @NotNull
    private static final String ADD_TO_DICTIONARY_CODE_ACTION_KIND = "quickfix.ltex.addToDictionary";
    @NotNull
    private static final String DISABLE_RULES_CODE_ACTION_KIND = "quickfix.ltex.disableRules";
    @NotNull
    private static final String HIDE_FALSE_POSITIVES_CODE_ACTION_KIND = "quickfix.ltex.hideFalsePositives";
    @NotNull
    private static final String ADD_TO_DICTIONARY_COMMAND_NAME = "_ltex.addToDictionary";
    @NotNull
    private static final String DISABLE_RULES_COMMAND_NAME = "_ltex.disableRules";
    @NotNull
    private static final String HIDE_FALSE_POSITIVES_COMMAND_NAME = "_ltex.hideFalsePositives";
    @NotNull
    private static final String DUMMY_REGEX_STRING = "(?:Dummy|Ina|Jimmy-)[0-9]+";
    @NotNull
    private static final Regex DUMMY_REGEX = new Regex("(?:Dummy|Ina|Jimmy-)[0-9]+");
    private static final int MAX_NUMBER_OF_ACCEPT_SUGGESTIONS_CODE_ACTIONS = 5;

    public CodeActionProvider(@NotNull SettingsManager settingsManager) {
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        this.settingsManager = settingsManager;
    }

    @NotNull
    public final SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    @NotNull
    public final Diagnostic createDiagnostic(@NotNull LanguageToolRuleMatch match, @NotNull LtexTextDocumentItem document) {
        Intrinsics.checkNotNullParameter((Object)match, (String)"match");
        Intrinsics.checkNotNullParameter((Object)((Object)document), (String)"document");
        Diagnostic diagnostic = new Diagnostic();
        Position fromPosition = document.convertPosition(match.getFromPos());
        Position toPosition = document.convertPosition(match.getToPos());
        diagnostic.setRange(new Range(fromPosition, toPosition));
        Map<String, DiagnosticSeverity> diagnosticSeverityMap = this.settingsManager.getSettings().getDiagnosticSeverity();
        DiagnosticSeverity diagnosticSeverity = diagnosticSeverityMap.get(match.getRuleId());
        if (diagnosticSeverity == null) {
            diagnosticSeverity = diagnosticSeverityMap.get("default");
        }
        if (diagnosticSeverity == null) {
            diagnosticSeverity = DiagnosticSeverity.Information;
        }
        diagnostic.setSeverity(diagnosticSeverity);
        diagnostic.setSource("LTeX");
        CharSequence charSequence = match.getMessage();
        Regex regex = SUGGESTION_REGEX;
        String string = "'$1'";
        diagnostic.setMessage(regex.replace(charSequence, string));
        diagnostic.setCode(Either.forLeft((Object)match.getRuleId()));
        StringBuilder urlBuilder = new StringBuilder("https://community.languagetool.org/rule/show/");
        urlBuilder.append(URLEncoder.encode(match.getRuleId(), "utf-8"));
        urlBuilder.append("?lang=");
        urlBuilder.append(URLEncoder.encode(match.getLanguageShortCode(), "utf-8"));
        diagnostic.setCodeDescription(new DiagnosticCodeDescription(urlBuilder.toString()));
        return diagnostic;
    }

    @NotNull
    public final List<Either<Command, CodeAction>> generate(@NotNull CodeActionParams params, @NotNull LtexTextDocumentItem document, @NotNull Pair<? extends List<LanguageToolRuleMatch>, ? extends List<AnnotatedTextFragment>> checkingResult) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)((Object)document), (String)"document");
        Intrinsics.checkNotNullParameter(checkingResult, (String)"checkingResult");
        List annotatedTextFragments = (List)checkingResult.getSecond();
        ArrayList<Either> result = new ArrayList<Either>();
        LinkedHashMap acceptSuggestionsMatchesMap = new LinkedHashMap();
        ArrayList<LanguageToolRuleMatch> addToDictionaryMatches = new ArrayList<LanguageToolRuleMatch>();
        ArrayList<LanguageToolRuleMatch> hideFalsePositivesMatches = new ArrayList<LanguageToolRuleMatch>();
        ArrayList<LanguageToolRuleMatch> disableRulesMatches = new ArrayList<LanguageToolRuleMatch>();
        for (LanguageToolRuleMatch entry : (List)checkingResult.getFirst()) {
            Range range = params.getRange();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"params.range");
            if (!entry.isIntersectingWithRange(range, document)) continue;
            for (String newWord : entry.getSuggestedReplacements()) {
                ArrayList<LanguageToolRuleMatch> arrayList;
                if (!acceptSuggestionsMatchesMap.containsKey(newWord) && acceptSuggestionsMatchesMap.size() >= 5) continue;
                ArrayList<LanguageToolRuleMatch> arrayList2 = (ArrayList<LanguageToolRuleMatch>)acceptSuggestionsMatchesMap.get(newWord);
                if (arrayList2 == null) {
                    CodeActionProvider $this$generate_u24lambda_u240 = this;
                    boolean bl = false;
                    ArrayList<LanguageToolRuleMatch> acceptSuggestionsMatches = new ArrayList<LanguageToolRuleMatch>();
                    ((Map)acceptSuggestionsMatchesMap).put(newWord, acceptSuggestionsMatches);
                    arrayList = acceptSuggestionsMatches;
                } else {
                    arrayList = arrayList2;
                }
                ArrayList<LanguageToolRuleMatch> acceptSuggestionsMatches = arrayList;
                acceptSuggestionsMatches.add(entry);
            }
            if (entry.isUnknownWordRule()) {
                addToDictionaryMatches.add(entry);
            }
            if (entry.getSentence() != null) {
                hideFalsePositivesMatches.add(entry);
            }
            disableRulesMatches.add(entry);
        }
        for (Map.Entry entry : ((Map)acceptSuggestionsMatchesMap).entrySet()) {
            String newWord = (String)entry.getKey();
            ArrayList acceptSuggestionsMatches = (ArrayList)entry.getValue();
            result.add(Either.forRight((Object)this.getAcceptSuggestionsCodeAction(document, newWord, acceptSuggestionsMatches)));
        }
        if (!((Collection)addToDictionaryMatches).isEmpty()) {
            result.add(Either.forRight((Object)this.getAddWordToDictionaryCodeAction(document, (List<LanguageToolRuleMatch>)addToDictionaryMatches, annotatedTextFragments)));
        }
        if (!((Collection)hideFalsePositivesMatches).isEmpty()) {
            result.add(Either.forRight((Object)this.getHideFalsePositivesCodeAction(document, (List<LanguageToolRuleMatch>)hideFalsePositivesMatches, annotatedTextFragments)));
        }
        if (!((Collection)disableRulesMatches).isEmpty()) {
            result.add(Either.forRight((Object)this.getDisableRulesCodeAction(document, (List<LanguageToolRuleMatch>)disableRulesMatches, annotatedTextFragments)));
        }
        return result;
    }

    private final CodeAction getAcceptSuggestionsCodeAction(LtexTextDocumentItem document, String newWord, List<LanguageToolRuleMatch> acceptSuggestionsMatches) {
        String string;
        Object[] objectArray;
        VersionedTextDocumentIdentifier textDocument = new VersionedTextDocumentIdentifier(document.getUri(), Integer.valueOf(document.getVersion()));
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        ArrayList<Either> documentChanges = new ArrayList<Either>();
        for (LanguageToolRuleMatch match : acceptSuggestionsMatches) {
            Range range;
            Diagnostic diagnostic = this.createDiagnostic(match, document);
            Intrinsics.checkNotNullExpressionValue((Object)diagnostic.getRange(), (String)"diagnostic.range");
            diagnostics.add(diagnostic);
            documentChanges.add(Either.forLeft((Object)new TextDocumentEdit(textDocument, CollectionsKt.listOf((Object)new TextEdit(range, newWord)))));
        }
        if (acceptSuggestionsMatches.size() == 1) {
            objectArray = new Object[]{newWord};
            string = I18n.INSTANCE.format("useWord", objectArray);
        } else {
            objectArray = new Object[]{newWord};
            string = I18n.INSTANCE.format("useWordAllSelectedMatches", objectArray);
        }
        CodeAction codeAction = new CodeAction(string);
        codeAction.setKind(ACCEPT_SUGGESTIONS_CODE_ACTION_KIND);
        codeAction.setDiagnostics((List)diagnostics);
        codeAction.setEdit(new WorkspaceEdit((List)documentChanges));
        return codeAction;
    }

    private final CodeAction getAddWordToDictionaryCodeAction(LtexTextDocumentItem document, List<LanguageToolRuleMatch> addToDictionaryMatches, List<AnnotatedTextFragment> annotatedTextFragments) {
        String string;
        Object[] annotatedTextFragment;
        HashMap unknownWordsMap = new HashMap();
        JsonObject unknownWordsJsonObject = new JsonObject();
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        for (LanguageToolRuleMatch match : addToDictionaryMatches) {
            int fragmentIndex = Companion.findAnnotatedTextFragmentWithMatch(annotatedTextFragments, match);
            if (fragmentIndex == -1) {
                Logging.INSTANCE.getLOGGER().warning(I18n.INSTANCE.format("couldNotFindFragmentForMatch", new Object[0]));
                continue;
            }
            annotatedTextFragment = annotatedTextFragments.get(fragmentIndex);
            CodeFragment codeFragment = annotatedTextFragment.getCodeFragment();
            String language = codeFragment.getLanguageShortCode();
            int offset = codeFragment.getFromPos();
            String word = annotatedTextFragment.getSubstringOfPlainText(match.getFromPos() - offset, match.getToPos() - offset);
            CodeActionProvider.Companion.addToMap(language, word, unknownWordsMap, unknownWordsJsonObject);
            diagnostics.add(this.createDiagnostic(match, document));
        }
        JsonObject arguments = new JsonObject();
        arguments.addProperty("uri", document.getUri());
        arguments.add("words", (JsonElement)unknownWordsJsonObject);
        String onlyUnknownWord = CodeActionProvider.Companion.getOnlyEntry(unknownWordsMap);
        if (onlyUnknownWord != null) {
            annotatedTextFragment = new Object[]{onlyUnknownWord};
            string = I18n.INSTANCE.format("addWordToDictionary", annotatedTextFragment);
        } else {
            string = I18n.INSTANCE.format("addAllUnknownWordsInSelectionToDictionary", new Object[0]);
        }
        String commandTitle = string;
        Command command = new Command(commandTitle, ADD_TO_DICTIONARY_COMMAND_NAME);
        command.setArguments(CollectionsKt.listOf((Object)arguments));
        CodeAction codeAction = new CodeAction(command.getTitle());
        codeAction.setKind(ADD_TO_DICTIONARY_CODE_ACTION_KIND);
        codeAction.setDiagnostics((List)diagnostics);
        codeAction.setCommand(command);
        return codeAction;
    }

    private final CodeAction getHideFalsePositivesCodeAction(LtexTextDocumentItem document, List<LanguageToolRuleMatch> hideFalsePositivesMatches, List<AnnotatedTextFragment> annotatedTextFragments) {
        ArrayList<Pair> ruleIdSentencePairs = new ArrayList<Pair>();
        HashMap hiddenFalsePositivesMap = new HashMap();
        JsonObject falsePositivesJsonObject = new JsonObject();
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        for (LanguageToolRuleMatch match : hideFalsePositivesMatches) {
            String sentence;
            String ruleId = match.getRuleId();
            String string = match.getSentence();
            String string2 = sentence = string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null;
            if (ruleId == null || sentence == null) continue;
            Pair pair = new Pair((Object)ruleId, (Object)sentence);
            if (!ruleIdSentencePairs.contains(pair)) {
                int fragmentIndex = Companion.findAnnotatedTextFragmentWithMatch(annotatedTextFragments, match);
                if (fragmentIndex == -1) {
                    Logging.INSTANCE.getLOGGER().warning(I18n.INSTANCE.format("couldNotFindFragmentForMatch", new Object[0]));
                    continue;
                }
                AnnotatedTextFragment annotatedTextFragment = annotatedTextFragments.get(fragmentIndex);
                CodeFragment codeFragment = annotatedTextFragment.getCodeFragment();
                String language = codeFragment.getLanguageShortCode();
                StringBuilder sentencePatternStringBuilder = new StringBuilder();
                int lastEnd = 0;
                for (MatchResult matchResult : Regex.findAll$default((Regex)DUMMY_REGEX, (CharSequence)sentence, (int)0, (int)2, null)) {
                    String string3 = sentence.substring(lastEnd, matchResult.getRange().getFirst());
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    sentencePatternStringBuilder.append(Regex.Companion.escape(string3));
                    sentencePatternStringBuilder.append(DUMMY_REGEX_STRING);
                    lastEnd = matchResult.getRange().getLast() + 1;
                }
                if (lastEnd < sentence.length()) {
                    String string4 = sentence.substring(lastEnd);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
                    sentencePatternStringBuilder.append(Regex.Companion.escape(string4));
                }
                ruleIdSentencePairs.add(pair);
                JsonObject falsePositiveJson = new JsonObject();
                falsePositiveJson.add("rule", (JsonElement)new JsonPrimitive(ruleId));
                String sentencePatternString = "^" + sentencePatternStringBuilder + "$";
                falsePositiveJson.add("sentence", (JsonElement)new JsonPrimitive(sentencePatternString));
                String string5 = falsePositiveJson.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"falsePositiveJson.toString()");
                CodeActionProvider.Companion.addToMap(language, string5, hiddenFalsePositivesMap, falsePositivesJsonObject);
            }
            diagnostics.add(this.createDiagnostic(match, document));
        }
        JsonObject arguments = new JsonObject();
        arguments.addProperty("uri", document.getUri());
        arguments.add("falsePositives", (JsonElement)falsePositivesJsonObject);
        Command command = new Command(ruleIdSentencePairs.size() == 1 ? I18n.INSTANCE.format("hideFalsePositive", new Object[0]) : I18n.INSTANCE.format("hideAllFalsePositivesInTheSelectedSentences", new Object[0]), HIDE_FALSE_POSITIVES_COMMAND_NAME);
        command.setArguments(CollectionsKt.listOf((Object)arguments));
        CodeAction codeAction = new CodeAction(command.getTitle());
        codeAction.setKind(HIDE_FALSE_POSITIVES_CODE_ACTION_KIND);
        codeAction.setDiagnostics((List)diagnostics);
        codeAction.setCommand(command);
        return codeAction;
    }

    private final CodeAction getDisableRulesCodeAction(LtexTextDocumentItem document, List<LanguageToolRuleMatch> disableRuleMatches, List<AnnotatedTextFragment> annotatedTextFragments) {
        HashMap ruleIdsMap = new HashMap();
        JsonObject ruleIdsJsonObject = new JsonObject();
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        for (LanguageToolRuleMatch match : disableRuleMatches) {
            String ruleId = match.getRuleId();
            if (ruleId != null) {
                int fragmentIndex = Companion.findAnnotatedTextFragmentWithMatch(annotatedTextFragments, match);
                if (fragmentIndex == -1) {
                    Logging.INSTANCE.getLOGGER().warning(I18n.INSTANCE.format("couldNotFindFragmentForMatch", new Object[0]));
                    continue;
                }
                AnnotatedTextFragment annotatedTextFragment = annotatedTextFragments.get(fragmentIndex);
                String language = annotatedTextFragment.getCodeFragment().getLanguageShortCode();
                CodeActionProvider.Companion.addToMap(language, ruleId, ruleIdsMap, ruleIdsJsonObject);
            }
            diagnostics.add(this.createDiagnostic(match, document));
        }
        JsonObject arguments = new JsonObject();
        arguments.addProperty("uri", document.getUri());
        arguments.add("ruleIds", (JsonElement)ruleIdsJsonObject);
        String commandTitle = CodeActionProvider.Companion.getOnlyEntry(ruleIdsMap) != null ? I18n.INSTANCE.format("disableRule", new Object[0]) : I18n.INSTANCE.format("disableAllRulesWithMatchesInSelection", new Object[0]);
        Command command = new Command(commandTitle, DISABLE_RULES_COMMAND_NAME);
        command.setArguments(CollectionsKt.listOf((Object)arguments));
        CodeAction codeAction = new CodeAction(command.getTitle());
        codeAction.setKind(DISABLE_RULES_CODE_ACTION_KIND);
        codeAction.setDiagnostics((List)diagnostics);
        codeAction.setCommand(command);
        return codeAction;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001c\u0010\u001c\u001a\u00020\u000f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040\u001eJ$\u0010#\u001a\u0004\u0018\u00010\u00042\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u001e0$H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006%"}, d2={"Lorg/bsplines/ltexls/server/CodeActionProvider$Companion;", "", "()V", "ACCEPT_SUGGESTIONS_CODE_ACTION_KIND", "", "ADD_TO_DICTIONARY_CODE_ACTION_KIND", "ADD_TO_DICTIONARY_COMMAND_NAME", "DISABLE_RULES_CODE_ACTION_KIND", "DISABLE_RULES_COMMAND_NAME", "DUMMY_REGEX", "Lkotlin/text/Regex;", "DUMMY_REGEX_STRING", "HIDE_FALSE_POSITIVES_CODE_ACTION_KIND", "HIDE_FALSE_POSITIVES_COMMAND_NAME", "MAX_NUMBER_OF_ACCEPT_SUGGESTIONS_CODE_ACTIONS", "", "SUGGESTION_REGEX", "getSUGGESTION_REGEX", "()Lkotlin/text/Regex;", "addToMap", "", "key", "value", "map", "", "", "jsonObject", "Lcom/google/gson/JsonObject;", "findAnnotatedTextFragmentWithMatch", "annotatedTextFragments", "", "Lorg/bsplines/ltexls/parsing/AnnotatedTextFragment;", "match", "Lorg/bsplines/ltexls/languagetool/LanguageToolRuleMatch;", "getCodeActionKinds", "getOnlyEntry", "", "ltexls"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getSUGGESTION_REGEX() {
            return SUGGESTION_REGEX;
        }

        @NotNull
        public final List<String> getCodeActionKinds() {
            return CollectionsKt.listOf((Object)CodeActionProvider.ACCEPT_SUGGESTIONS_CODE_ACTION_KIND);
        }

        public final int findAnnotatedTextFragmentWithMatch(@NotNull List<AnnotatedTextFragment> annotatedTextFragments, @NotNull LanguageToolRuleMatch match) {
            Intrinsics.checkNotNullParameter(annotatedTextFragments, (String)"annotatedTextFragments");
            Intrinsics.checkNotNullParameter((Object)match, (String)"match");
            int n = annotatedTextFragments.size();
            for (int i = 0; i < n; ++i) {
                if (!annotatedTextFragments.get(i).getCodeFragment().contains(match)) continue;
                return i;
            }
            return -1;
        }

        private final void addToMap(String key, String value, Map<String, List<String>> map, JsonObject jsonObject) {
            List list = map.get(key);
            if (list == null) {
                Companion $this$addToMap_u24lambda_u240 = this;
                boolean bl = false;
                ArrayList unknownWordsList = new ArrayList();
                map.put(key, unknownWordsList);
                jsonObject.add(key, (JsonElement)new JsonArray());
                list = unknownWordsList;
            }
            List unknownWordsList = list;
            JsonArray jsonArray = jsonObject.getAsJsonArray(key);
            Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"jsonObject.getAsJsonArray(key)");
            JsonArray unknownWordsJsonArray = jsonArray;
            if (!unknownWordsList.contains(value)) {
                unknownWordsList.add((String)value);
                unknownWordsJsonArray.add(value);
            }
        }

        private final String getOnlyEntry(Map<String, ? extends List<String>> map) {
            List list;
            return map.size() == 1 ? ((list = (List)CollectionsKt.toList((Iterable)map.values()).get(0)).size() == 1 ? (String)list.get(0) : null) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

