/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.ltexls.parsing.restructuredtext;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.bsplines.ltexls.parsing.CharacterBasedCodeAnnotatedTextBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001a\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\bH\u0002J\b\u0010\r\u001a\u00020\bH\u0002J\b\u0010\u000e\u001a\u00020\bH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\b\u0010\u0017\u001a\u00020\bH\u0002J\b\u0010\u0018\u001a\u00020\bH\u0002J\b\u0010\u0019\u001a\u00020\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/bsplines/ltexls/parsing/restructuredtext/RestructuredtextAnnotatedTextBuilder;", "Lorg/bsplines/ltexls/parsing/CharacterBasedCodeAnnotatedTextBuilder;", "codeLanguageId", "", "(Ljava/lang/String;)V", "blockType", "Lorg/bsplines/ltexls/parsing/restructuredtext/RestructuredtextAnnotatedTextBuilder$BlockType;", "inIgnoredMarkup", "", "indentation", "", "lastIndentation", "isExplicitBlockType", "isParagraph", "isTableBlockType", "matchInlineEndFromPosition", "Lkotlin/text/MatchResult;", "regex", "Lkotlin/text/Regex;", "matchInlineStartFromPosition", "processCharacter", "", "processInlineElement", "processStartOfBlock", "processStartOfLine", "processWhitespaceAtStartOfLine", "BlockType", "Companion", "ltexls"})
@SourceDebugExtension(value={"SMAP\nRestructuredtextAnnotatedTextBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RestructuredtextAnnotatedTextBuilder.kt\norg/bsplines/ltexls/parsing/restructuredtext/RestructuredtextAnnotatedTextBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,322:1\n1#2:323\n*E\n"})
public final class RestructuredtextAnnotatedTextBuilder
extends CharacterBasedCodeAnnotatedTextBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int indentation;
    private int lastIndentation;
    @NotNull
    private BlockType blockType;
    private boolean inIgnoredMarkup;
    @NotNull
    private static final Regex BLOCK_SEPARATOR_REGEX = new Regex("^([ \t]*\r?\n)+");
    @NotNull
    private static final Regex WHITESPACE_REGEX = new Regex("^[ \t]*");
    @NotNull
    private static final Regex FOOTNOTE_REGEX = new Regex("^\\.\\. \\[([0-9]+|[#*]|#[0-9A-Za-z\\-_.:+]+)]([ \t\r\n]|$)");
    @NotNull
    private static final Regex DIRECTIVE_REGEX = new Regex("^\\.\\. [0-9A-Za-z\\-_.:+]+::([ \t\r\n]|$)");
    @NotNull
    private static final Regex COMMENT_REGEX = new Regex("^\\.\\.([ \t\r\n]|$)");
    @NotNull
    private static final Regex GRID_TABLE_START_REGEX = new Regex("^(\\+-{3,}){2,}\\+\r?\n");
    @NotNull
    private static final Regex SIMPLE_TABLE_START_REGEX = new Regex("^={3,}( +={3,})+\r?\n");
    @NotNull
    private static final Regex SECTION_TITLE_ADORNMENT_REGEX = new Regex("^(={3,}|-{3,}|`{3,}|:{3,}|\\.{3,}|'{3,}|\"{3,}|~{3,}|\\^{3,}|_{3,}|\\*{3,}|\\+{3,}|#{3,})\r?\n");
    @NotNull
    private static final Regex LINE_BLOCK_REGEX = new Regex("^\\|[ \t]+(?=.*?[^|](\r?\n|$))");
    @NotNull
    private static final Regex BULLET_LIST_REGEX = new Regex("^[*+\\-\u2022\u2023\u2043][ \t]+");
    @NotNull
    private static final Regex ENUMERATED_LIST_REGEX = new Regex("^(([0-9]+|[A-Za-z#]|[IVXLCDM]+|[ivxlcdm]+)\\.|\\(?([0-9]+|[A-Za-z#]|[IVXLCDM]+|[ivxlcdm]+)\\))[ \t]+");
    @NotNull
    private static final Regex INLINE_START_PRECEDING_REGEX = new Regex("^[ \t\r\n\\-:/'\"<(\\[{]");
    @NotNull
    private static final Regex INLINE_START_FOLLOWING_REGEX = new Regex("^[^ \t\r\n]");
    @NotNull
    private static final Regex INLINE_END_PRECEDING_REGEX = new Regex("^[^ \t\r\n]");
    @NotNull
    private static final Regex INLINE_END_FOLLOWING_REGEX = new Regex("^([ \t\r\n-.,:;!?\\\\/'\")\\]}>]|$)");
    @NotNull
    private static final Regex STRONG_EMPHASIS_REGEX = new Regex("^\\*\\*");
    @NotNull
    private static final Regex EMPHASIS_REGEX = new Regex("^\\*");
    @NotNull
    private static final Regex INLINE_LITERAL_REGEX = new Regex("^``");
    @NotNull
    private static final Regex INTERPRETED_TEXT_START_REGEX = new Regex("^(:[0-9A-Za-z\\-_.:+]+:)?`");
    @NotNull
    private static final Regex INTERPRETED_TEXT_END_REGEX = new Regex("^`(:[0-9A-Za-z\\-_.:+]+:)?");
    @NotNull
    private static final Regex INLINE_INTERNAL_TARGET_START_REGEX = new Regex("^_`");
    @NotNull
    private static final Regex INLINE_INTERNAL_TARGET_END_REGEX = new Regex("^`");
    @NotNull
    private static final Regex FOOTNOTE_REFERENCE_START_REGEX = new Regex("^\\[");
    @NotNull
    private static final Regex FOOTNOTE_REFERENCE_END_REGEX = new Regex("^]_");
    @NotNull
    private static final Regex HYPERLINK_REFERENCE_START_REGEX = new Regex("^`");
    @NotNull
    private static final Regex HYPERLINK_REFERENCE_END_REGEX = new Regex("^`__?");

    public RestructuredtextAnnotatedTextBuilder(@NotNull String codeLanguageId) {
        Intrinsics.checkNotNullParameter((Object)codeLanguageId, (String)"codeLanguageId");
        super(codeLanguageId);
        this.indentation = -1;
        this.lastIndentation = -1;
        this.blockType = BlockType.Paragraph;
    }

    @Override
    protected void processCharacter() {
        boolean isStartOfBlock = false;
        if (this.isStartOfLine()) {
            isStartOfBlock = this.processStartOfBlock();
            this.processWhitespaceAtStartOfLine();
            if (this.getPos() >= this.getCode().length()) {
                return;
            }
        }
        if (isStartOfBlock) {
            this.inIgnoredMarkup = false;
            if (this.isParagraph()) {
                this.blockType = BlockType.Paragraph;
            }
        }
        if (!this.isStartOfLine() || !this.processStartOfLine()) {
            if (this.blockType == BlockType.Comment || this.blockType == BlockType.GridTable || this.blockType == BlockType.SimpleTable) {
                this.addMarkup(this.getCurString());
            } else {
                this.processInlineElement();
            }
        }
    }

    private final boolean processStartOfBlock() {
        boolean bl;
        MatchResult blockSeparatorMatchResult = CharacterBasedCodeAnnotatedTextBuilder.matchFromPosition$default(this, BLOCK_SEPARATOR_REGEX, 0, 2, null);
        if (this.getPos() == 0 || blockSeparatorMatchResult != null) {
            if (blockSeparatorMatchResult != null) {
                this.addMarkup(blockSeparatorMatchResult.getValue(), "\n");
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final void processWhitespaceAtStartOfLine() {
        Object object = CharacterBasedCodeAnnotatedTextBuilder.matchFromPosition$default(this, WHITESPACE_REGEX, 0, 2, null);
        if (object == null || (object = object.getValue()) == null) {
            object = "";
        }
        Object whitespace = object;
        this.lastIndentation = this.indentation;
        this.indentation = ((String)whitespace).length();
        this.addMarkup((String)whitespace);
        if (this.getPos() < this.getCode().length()) {
            this.setCurChar(this.getCode().charAt(this.getPos()));
            this.setCurString(String.valueOf(this.getCurChar()));
        }
    }

    private final boolean processStartOfLine() {
        MatchResult matchResult;
        MatchResult it;
        MatchResult matchResult2;
        MatchResult matchResult3 = null;
        boolean blockFound = true;
        MatchResult matchResult4 = CharacterBasedCodeAnnotatedTextBuilder.matchFromPosition$default(this, FOOTNOTE_REGEX, 0, 2, null);
        if (matchResult4 != null) {
            it = matchResult2 = matchResult4;
            boolean bl = false;
            matchResult3 = it;
            matchResult = matchResult2;
        } else {
            matchResult = null;
        }
        if (matchResult != null) {
            this.blockType = BlockType.Footnote;
            MatchResult matchResult5 = matchResult3;
            this.addMarkup(matchResult5 != null ? matchResult5.getValue() : null);
        } else {
            MatchResult matchResult6;
            MatchResult matchResult7 = CharacterBasedCodeAnnotatedTextBuilder.matchFromPosition$default(this, DIRECTIVE_REGEX, 0, 2, null);
            if (matchResult7 != null) {
                it = matchResult2 = matchResult7;
                boolean bl = false;
                matchResult3 = it;
                matchResult6 = matchResult2;
            } else {
                matchResult6 = null;
            }
            if (matchResult6 != null) {
                this.blockType = BlockType.Directive;
                MatchResult matchResult8 = matchResult3;
                this.addMarkup(matchResult8 != null ? matchResult8.getValue() : null);
            } else {
                MatchResult matchResult9;
                MatchResult matchResult10 = CharacterBasedCodeAnnotatedTextBuilder.matchFromPosition$default(this, COMMENT_REGEX, 0, 2, null);
                if (matchResult10 != null) {
                    it = matchResult2 = matchResult10;
                    boolean bl = false;
                    matchResult3 = it;
                    matchResult9 = matchResult2;
                } else {
                    matchResult9 = null;
                }
                if (matchResult9 != null) {
                    this.blockType = BlockType.Comment;
                    MatchResult matchResult11 = matchResult3;
                    this.addMarkup(matchResult11 != null ? matchResult11.getValue() : null);
                } else {
                    MatchResult matchResult12;
                    MatchResult matchResult13 = CharacterBasedCodeAnnotatedTextBuilder.matchFromPosition$default(this, GRID_TABLE_START_REGEX, 0, 2, null);
                    if (matchResult13 != null) {
                        it = matchResult2 = matchResult13;
                        boolean bl = false;
                        matchResult3 = it;
                        matchResult12 = matchResult2;
                    } else {
                        matchResult12 = null;
                    }
                    if (matchResult12 != null) {
                        this.blockType = BlockType.GridTable;
                        MatchResult matchResult14 = matchResult3;
                        this.addMarkup(matchResult14 != null ? matchResult14.getValue() : null);
                    } else {
                        MatchResult matchResult15;
                        MatchResult matchResult16 = CharacterBasedCodeAnnotatedTextBuilder.matchFromPosition$default(this, SIMPLE_TABLE_START_REGEX, 0, 2, null);
                        if (matchResult16 != null) {
                            it = matchResult2 = matchResult16;
                            boolean bl = false;
                            matchResult3 = it;
                            matchResult15 = matchResult2;
                        } else {
                            matchResult15 = null;
                        }
                        if (matchResult15 != null) {
                            this.blockType = BlockType.SimpleTable;
                            MatchResult matchResult17 = matchResult3;
                            this.addMarkup(matchResult17 != null ? matchResult17.getValue() : null);
                        } else {
                            MatchResult matchResult18;
                            MatchResult matchResult19 = CharacterBasedCodeAnnotatedTextBuilder.matchFromPosition$default(this, SECTION_TITLE_ADORNMENT_REGEX, 0, 2, null);
                            if (matchResult19 != null) {
                                it = matchResult2 = matchResult19;
                                boolean bl = false;
                                matchResult3 = it;
                                matchResult18 = matchResult2;
                            } else {
                                matchResult18 = null;
                            }
                            if (matchResult18 != null) {
                                MatchResult matchResult20 = matchResult3;
                                this.addMarkup(matchResult20 != null ? matchResult20.getValue() : null);
                            } else {
                                MatchResult matchResult21;
                                MatchResult matchResult22 = CharacterBasedCodeAnnotatedTextBuilder.matchFromPosition$default(this, LINE_BLOCK_REGEX, 0, 2, null);
                                if (matchResult22 != null) {
                                    it = matchResult2 = matchResult22;
                                    boolean bl = false;
                                    matchResult3 = it;
                                    matchResult21 = matchResult2;
                                } else {
                                    matchResult21 = null;
                                }
                                if (matchResult21 != null) {
                                    MatchResult matchResult23 = matchResult3;
                                    this.addMarkup(matchResult23 != null ? matchResult23.getValue() : null);
                                } else {
                                    MatchResult matchResult24;
                                    MatchResult matchResult25 = CharacterBasedCodeAnnotatedTextBuilder.matchFromPosition$default(this, BULLET_LIST_REGEX, 0, 2, null);
                                    if (matchResult25 != null) {
                                        it = matchResult2 = matchResult25;
                                        boolean bl = false;
                                        matchResult3 = it;
                                        matchResult24 = matchResult2;
                                    } else {
                                        matchResult24 = null;
                                    }
                                    if (matchResult24 != null) {
                                        MatchResult matchResult26 = matchResult3;
                                        this.addMarkup(matchResult26 != null ? matchResult26.getValue() : null);
                                    } else {
                                        MatchResult matchResult27;
                                        MatchResult matchResult28 = CharacterBasedCodeAnnotatedTextBuilder.matchFromPosition$default(this, ENUMERATED_LIST_REGEX, 0, 2, null);
                                        if (matchResult28 != null) {
                                            it = matchResult2 = matchResult28;
                                            boolean bl = false;
                                            matchResult3 = it;
                                            matchResult27 = matchResult2;
                                        } else {
                                            matchResult27 = null;
                                        }
                                        if (matchResult27 != null) {
                                            MatchResult matchResult29 = matchResult3;
                                            this.addMarkup(matchResult29 != null ? matchResult29.getValue() : null);
                                        } else {
                                            blockFound = false;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return blockFound;
    }

    private final void processInlineElement() {
        MatchResult matchResult;
        MatchResult it;
        MatchResult matchResult2;
        MatchResult matchResult3 = null;
        MatchResult matchResult4 = this.matchInlineStartFromPosition(STRONG_EMPHASIS_REGEX);
        if (matchResult4 != null) {
            it = matchResult2 = matchResult4;
            boolean bl = false;
            matchResult3 = it;
            matchResult = matchResult2;
        } else {
            matchResult = null;
        }
        if (matchResult != null) {
            MatchResult matchResult5 = matchResult3;
            this.addMarkup(matchResult5 != null ? matchResult5.getValue() : null);
        } else {
            MatchResult matchResult6;
            MatchResult matchResult7 = this.matchInlineEndFromPosition(STRONG_EMPHASIS_REGEX);
            if (matchResult7 != null) {
                it = matchResult2 = matchResult7;
                boolean bl = false;
                matchResult3 = it;
                matchResult6 = matchResult2;
            } else {
                matchResult6 = null;
            }
            if (matchResult6 != null) {
                MatchResult matchResult8 = matchResult3;
                this.addMarkup(matchResult8 != null ? matchResult8.getValue() : null);
            } else {
                MatchResult matchResult9;
                MatchResult matchResult10 = this.matchInlineStartFromPosition(EMPHASIS_REGEX);
                if (matchResult10 != null) {
                    it = matchResult2 = matchResult10;
                    boolean bl = false;
                    matchResult3 = it;
                    matchResult9 = matchResult2;
                } else {
                    matchResult9 = null;
                }
                if (matchResult9 != null) {
                    MatchResult matchResult11 = matchResult3;
                    this.addMarkup(matchResult11 != null ? matchResult11.getValue() : null);
                } else {
                    MatchResult matchResult12;
                    MatchResult matchResult13 = this.matchInlineEndFromPosition(EMPHASIS_REGEX);
                    if (matchResult13 != null) {
                        it = matchResult2 = matchResult13;
                        boolean bl = false;
                        matchResult3 = it;
                        matchResult12 = matchResult2;
                    } else {
                        matchResult12 = null;
                    }
                    if (matchResult12 != null) {
                        MatchResult matchResult14 = matchResult3;
                        this.addMarkup(matchResult14 != null ? matchResult14.getValue() : null);
                    } else {
                        MatchResult matchResult15;
                        MatchResult matchResult16 = this.matchInlineStartFromPosition(INLINE_LITERAL_REGEX);
                        if (matchResult16 != null) {
                            it = matchResult2 = matchResult16;
                            boolean bl = false;
                            matchResult3 = it;
                            matchResult15 = matchResult2;
                        } else {
                            matchResult15 = null;
                        }
                        if (matchResult15 != null) {
                            MatchResult matchResult17 = matchResult3;
                            this.addMarkup(matchResult17 != null ? matchResult17.getValue() : null, this.generateDummy());
                            this.inIgnoredMarkup = true;
                        } else {
                            MatchResult matchResult18;
                            MatchResult matchResult19 = this.matchInlineEndFromPosition(INLINE_LITERAL_REGEX);
                            if (matchResult19 != null) {
                                it = matchResult2 = matchResult19;
                                boolean bl = false;
                                matchResult3 = it;
                                matchResult18 = matchResult2;
                            } else {
                                matchResult18 = null;
                            }
                            if (matchResult18 != null) {
                                MatchResult matchResult20 = matchResult3;
                                this.addMarkup(matchResult20 != null ? matchResult20.getValue() : null);
                                this.inIgnoredMarkup = false;
                            } else {
                                MatchResult matchResult21;
                                MatchResult matchResult22 = this.matchInlineStartFromPosition(INTERPRETED_TEXT_START_REGEX);
                                if (matchResult22 != null) {
                                    it = matchResult2 = matchResult22;
                                    boolean bl = false;
                                    matchResult3 = it;
                                    matchResult21 = matchResult2;
                                } else {
                                    matchResult21 = null;
                                }
                                if (matchResult21 != null) {
                                    MatchResult matchResult23 = matchResult3;
                                    this.addMarkup(matchResult23 != null ? matchResult23.getValue() : null, this.generateDummy());
                                    this.inIgnoredMarkup = true;
                                } else {
                                    MatchResult matchResult24;
                                    MatchResult matchResult25 = this.matchInlineEndFromPosition(INTERPRETED_TEXT_END_REGEX);
                                    if (matchResult25 != null) {
                                        it = matchResult2 = matchResult25;
                                        boolean bl = false;
                                        matchResult3 = it;
                                        matchResult24 = matchResult2;
                                    } else {
                                        matchResult24 = null;
                                    }
                                    if (matchResult24 != null) {
                                        MatchResult matchResult26 = matchResult3;
                                        this.addMarkup(matchResult26 != null ? matchResult26.getValue() : null);
                                        this.inIgnoredMarkup = false;
                                    } else {
                                        MatchResult matchResult27;
                                        MatchResult matchResult28 = this.matchInlineStartFromPosition(INLINE_INTERNAL_TARGET_START_REGEX);
                                        if (matchResult28 != null) {
                                            it = matchResult2 = matchResult28;
                                            boolean bl = false;
                                            matchResult3 = it;
                                            matchResult27 = matchResult2;
                                        } else {
                                            matchResult27 = null;
                                        }
                                        if (matchResult27 != null) {
                                            MatchResult matchResult29 = matchResult3;
                                            this.addMarkup(matchResult29 != null ? matchResult29.getValue() : null, this.generateDummy());
                                            this.inIgnoredMarkup = true;
                                        } else {
                                            MatchResult matchResult30;
                                            MatchResult matchResult31 = this.matchInlineEndFromPosition(INLINE_INTERNAL_TARGET_END_REGEX);
                                            if (matchResult31 != null) {
                                                it = matchResult2 = matchResult31;
                                                boolean bl = false;
                                                matchResult3 = it;
                                                matchResult30 = matchResult2;
                                            } else {
                                                matchResult30 = null;
                                            }
                                            if (matchResult30 != null) {
                                                MatchResult matchResult32 = matchResult3;
                                                this.addMarkup(matchResult32 != null ? matchResult32.getValue() : null);
                                                this.inIgnoredMarkup = false;
                                            } else {
                                                MatchResult matchResult33;
                                                MatchResult matchResult34 = this.matchInlineStartFromPosition(FOOTNOTE_REFERENCE_START_REGEX);
                                                if (matchResult34 != null) {
                                                    it = matchResult2 = matchResult34;
                                                    boolean bl = false;
                                                    matchResult3 = it;
                                                    matchResult33 = matchResult2;
                                                } else {
                                                    matchResult33 = null;
                                                }
                                                if (matchResult33 != null) {
                                                    MatchResult matchResult35 = matchResult3;
                                                    this.addMarkup(matchResult35 != null ? matchResult35.getValue() : null, this.generateDummy());
                                                    this.inIgnoredMarkup = true;
                                                } else {
                                                    MatchResult matchResult36;
                                                    MatchResult matchResult37 = this.matchInlineEndFromPosition(FOOTNOTE_REFERENCE_END_REGEX);
                                                    if (matchResult37 != null) {
                                                        it = matchResult2 = matchResult37;
                                                        boolean bl = false;
                                                        matchResult3 = it;
                                                        matchResult36 = matchResult2;
                                                    } else {
                                                        matchResult36 = null;
                                                    }
                                                    if (matchResult36 != null) {
                                                        MatchResult matchResult38 = matchResult3;
                                                        this.addMarkup(matchResult38 != null ? matchResult38.getValue() : null);
                                                        this.inIgnoredMarkup = false;
                                                    } else {
                                                        MatchResult matchResult39;
                                                        MatchResult matchResult40 = this.matchInlineStartFromPosition(HYPERLINK_REFERENCE_START_REGEX);
                                                        if (matchResult40 != null) {
                                                            it = matchResult2 = matchResult40;
                                                            boolean bl = false;
                                                            matchResult3 = it;
                                                            matchResult39 = matchResult2;
                                                        } else {
                                                            matchResult39 = null;
                                                        }
                                                        if (matchResult39 != null) {
                                                            MatchResult matchResult41 = matchResult3;
                                                            this.addMarkup(matchResult41 != null ? matchResult41.getValue() : null, this.generateDummy());
                                                            this.inIgnoredMarkup = true;
                                                        } else {
                                                            MatchResult matchResult42;
                                                            MatchResult matchResult43 = this.matchInlineEndFromPosition(HYPERLINK_REFERENCE_END_REGEX);
                                                            if (matchResult43 != null) {
                                                                it = matchResult2 = matchResult43;
                                                                boolean bl = false;
                                                                matchResult3 = it;
                                                                matchResult42 = matchResult2;
                                                            } else {
                                                                matchResult42 = null;
                                                            }
                                                            if (matchResult42 != null) {
                                                                MatchResult matchResult44 = matchResult3;
                                                                this.addMarkup(matchResult44 != null ? matchResult44.getValue() : null);
                                                                this.inIgnoredMarkup = false;
                                                            } else if (this.inIgnoredMarkup) {
                                                                this.addMarkup(this.getCurString());
                                                            } else {
                                                                this.addText(this.getCurString());
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private final boolean isParagraph() {
        return this.isExplicitBlockType() && (this.indentation == 0 || this.indentation < this.lastIndentation) || this.isTableBlockType();
    }

    private final MatchResult matchInlineStartFromPosition(Regex regex) {
        int n;
        if (this.getPos() > 0 && this.matchFromPosition(INLINE_START_PRECEDING_REGEX, this.getPos() - 1) == null) {
            return null;
        }
        MatchResult matchResult = CharacterBasedCodeAnnotatedTextBuilder.matchFromPosition$default(this, regex, 0, 2, null);
        if (matchResult == null || this.getPos() == 0 || this.getPos() >= this.getCode().length() - 1) {
            return matchResult;
        }
        if (this.matchFromPosition(INLINE_START_FOLLOWING_REGEX, this.getPos() + matchResult.getValue().length()) == null) {
            return null;
        }
        char c = this.getCode().charAt(this.getPos() - 1);
        if (c == '\'') {
            n = 39;
        } else if (c == '\"') {
            n = 34;
        } else if (c == '<') {
            n = 62;
        } else if (c == '(') {
            n = 41;
        } else if (c == '[') {
            n = 93;
        } else if (c == '{') {
            n = 125;
        } else {
            return matchResult;
        }
        int forbiddenFollowingChar = n;
        return this.getCode().charAt(this.getPos() + 1) == forbiddenFollowingChar ? null : matchResult;
    }

    private final MatchResult matchInlineEndFromPosition(Regex regex) {
        if (this.getPos() == 0 || this.matchFromPosition(INLINE_END_PRECEDING_REGEX, this.getPos() - 1) == null) {
            return null;
        }
        MatchResult matchResult = CharacterBasedCodeAnnotatedTextBuilder.matchFromPosition$default(this, regex, 0, 2, null);
        return matchResult == null || this.matchFromPosition(INLINE_END_FOLLOWING_REGEX, this.getPos() + matchResult.getValue().length()) != null ? matchResult : null;
    }

    private final boolean isExplicitBlockType() {
        return this.blockType == BlockType.Footnote || this.blockType == BlockType.Directive || this.blockType == BlockType.Comment;
    }

    private final boolean isTableBlockType() {
        return this.blockType == BlockType.GridTable || this.blockType == BlockType.SimpleTable;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lorg/bsplines/ltexls/parsing/restructuredtext/RestructuredtextAnnotatedTextBuilder$BlockType;", "", "(Ljava/lang/String;I)V", "Paragraph", "Footnote", "Directive", "Comment", "GridTable", "SimpleTable", "ltexls"})
    private static final class BlockType
    extends Enum<BlockType> {
        public static final /* enum */ BlockType Paragraph = new BlockType();
        public static final /* enum */ BlockType Footnote = new BlockType();
        public static final /* enum */ BlockType Directive = new BlockType();
        public static final /* enum */ BlockType Comment = new BlockType();
        public static final /* enum */ BlockType GridTable = new BlockType();
        public static final /* enum */ BlockType SimpleTable = new BlockType();
        private static final /* synthetic */ BlockType[] $VALUES;

        public static BlockType[] values() {
            return (BlockType[])$VALUES.clone();
        }

        public static BlockType valueOf(String value) {
            return Enum.valueOf(BlockType.class, value);
        }

        static {
            $VALUES = blockTypeArray = new BlockType[]{BlockType.Paragraph, BlockType.Footnote, BlockType.Directive, BlockType.Comment, BlockType.GridTable, BlockType.SimpleTable};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001a\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/bsplines/ltexls/parsing/restructuredtext/RestructuredtextAnnotatedTextBuilder$Companion;", "", "()V", "BLOCK_SEPARATOR_REGEX", "Lkotlin/text/Regex;", "BULLET_LIST_REGEX", "COMMENT_REGEX", "DIRECTIVE_REGEX", "EMPHASIS_REGEX", "ENUMERATED_LIST_REGEX", "FOOTNOTE_REFERENCE_END_REGEX", "FOOTNOTE_REFERENCE_START_REGEX", "FOOTNOTE_REGEX", "GRID_TABLE_START_REGEX", "HYPERLINK_REFERENCE_END_REGEX", "HYPERLINK_REFERENCE_START_REGEX", "INLINE_END_FOLLOWING_REGEX", "INLINE_END_PRECEDING_REGEX", "INLINE_INTERNAL_TARGET_END_REGEX", "INLINE_INTERNAL_TARGET_START_REGEX", "INLINE_LITERAL_REGEX", "INLINE_START_FOLLOWING_REGEX", "INLINE_START_PRECEDING_REGEX", "INTERPRETED_TEXT_END_REGEX", "INTERPRETED_TEXT_START_REGEX", "LINE_BLOCK_REGEX", "SECTION_TITLE_ADORNMENT_REGEX", "SIMPLE_TABLE_START_REGEX", "STRONG_EMPHASIS_REGEX", "WHITESPACE_REGEX", "ltexls"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

