/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.ltexls.parsing.program;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bsplines.ltexls.parsing.CodeFragment;
import org.bsplines.ltexls.parsing.RegexCodeFragmentizer;
import org.bsplines.ltexls.parsing.program.ProgramCommentRegexs;
import org.bsplines.ltexls.settings.Settings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/bsplines/ltexls/parsing/program/ProgramFragmentizer;", "Lorg/bsplines/ltexls/parsing/RegexCodeFragmentizer;", "codeLanguageId", "", "(Ljava/lang/String;)V", "fragmentize", "", "Lorg/bsplines/ltexls/parsing/CodeFragment;", "code", "originalSettings", "Lorg/bsplines/ltexls/settings/Settings;", "Companion", "ltexls"})
public final class ProgramFragmentizer
extends RegexCodeFragmentizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<String> DICTIONARY;
    @NotNull
    private static final Set<String> DISABLED_RULES;

    public ProgramFragmentizer(@NotNull String codeLanguageId) {
        Intrinsics.checkNotNullParameter((Object)codeLanguageId, (String)"codeLanguageId");
        super(codeLanguageId, ProgramCommentRegexs.Companion.fromCodeLanguageId(codeLanguageId).getMagicCommentRegex());
    }

    @Override
    @NotNull
    public List<CodeFragment> fragmentize(@NotNull String code, @NotNull Settings originalSettings) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)originalSettings, (String)"originalSettings");
        List<CodeFragment> oldCodeFragments = super.fragmentize(code, originalSettings);
        ArrayList<CodeFragment> result = new ArrayList<CodeFragment>();
        for (CodeFragment oldCodeFragment : oldCodeFragments) {
            Settings settings = oldCodeFragment.getSettings();
            HashSet dictionary = new HashSet(settings.getDictionary());
            dictionary.addAll(DICTIONARY);
            HashSet<String> disabledRules = new HashSet<String>((Collection)settings.getDisabledRules());
            for (String ruleId : DISABLED_RULES) {
                if (settings.getEnabledRules().contains(ruleId)) continue;
                disabledRules.add(ruleId);
            }
            result.add(CodeFragment.copy$default(oldCodeFragment, null, null, 0, Settings.copy$default(settings, null, null, settings.getModifiedDictionary(dictionary), settings.getModifiedDisabledRules((Set<String>)disabledRules), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0x3FFFF3, null), null, 23, null));
        }
        return result;
    }

    static {
        Object[] objectArray = new String[]{"@param", "@return", "param"};
        DICTIONARY = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"COPYRIGHT", "DASH_RULE", "R_SYMBOL", "UPPERCASE_SENTENCE_START", "WHITESPACE_RULE"};
        DISABLED_RULES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/bsplines/ltexls/parsing/program/ProgramFragmentizer$Companion;", "", "()V", "DICTIONARY", "", "", "getDICTIONARY", "()Ljava/util/Set;", "DISABLED_RULES", "getDISABLED_RULES", "ltexls"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getDICTIONARY() {
            return DICTIONARY;
        }

        @NotNull
        public final Set<String> getDISABLED_RULES() {
            return DISABLED_RULES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

