/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.ltexls.parsing.markdown;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.bsplines.ltexls.parsing.CodeFragment;
import org.bsplines.ltexls.parsing.CodeFragmentizer;
import org.bsplines.ltexls.parsing.RegexCodeFragmentizer;
import org.bsplines.ltexls.settings.Settings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/bsplines/ltexls/parsing/markdown/MarkdownFragmentizer;", "Lorg/bsplines/ltexls/parsing/CodeFragmentizer;", "codeLanguageId", "", "(Ljava/lang/String;)V", "commentFragmentizer", "Lorg/bsplines/ltexls/parsing/RegexCodeFragmentizer;", "fragmentize", "", "Lorg/bsplines/ltexls/parsing/CodeFragment;", "code", "originalSettings", "Lorg/bsplines/ltexls/settings/Settings;", "fragmentizeYamlFrontMatter", "Companion", "ltexls"})
public final class MarkdownFragmentizer
extends CodeFragmentizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RegexCodeFragmentizer commentFragmentizer;
    @NotNull
    private static final Regex YAML_FRONT_MATTER_REGEX = new Regex("\\A---[ \t]*$(?s).*?(?-s)^lang:[ \t]+(?:\"(.+)\"|'(.+)'|(.+))$(?s).*?(?-s)^---[ \t]*$", RegexOption.MULTILINE);
    @NotNull
    private static final Regex COMMENT_REGEX = new Regex("^[ \t]*\\[[^]]+]:[ \t]*<>[ \t]*\"[ \t]*(?i)ltex(?-i):(.*?)\"[ \t]*$|^[ \t]*<!--[ \t]*(?i)ltex(?-i):(.*?)[ \t]*-->[ \t]*$", RegexOption.MULTILINE);

    public MarkdownFragmentizer(@NotNull String codeLanguageId) {
        Intrinsics.checkNotNullParameter((Object)codeLanguageId, (String)"codeLanguageId");
        super(codeLanguageId);
        this.commentFragmentizer = new RegexCodeFragmentizer(codeLanguageId, COMMENT_REGEX);
    }

    @Override
    @NotNull
    public List<CodeFragment> fragmentize(@NotNull String code, @NotNull Settings originalSettings) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)originalSettings, (String)"originalSettings");
        List<CodeFragment> fragments = this.fragmentizeYamlFrontMatter(code, originalSettings);
        fragments = this.commentFragmentizer.fragmentize(fragments);
        return fragments;
    }

    private final List<CodeFragment> fragmentizeYamlFrontMatter(String code, Settings originalSettings) {
        MatchResult matchResult = Regex.find$default((Regex)YAML_FRONT_MATTER_REGEX, (CharSequence)code, (int)0, (int)2, null);
        MarkdownFragmentizer $this$fragmentizeYamlFrontMatter_u24lambda_u240 = this;
        boolean bl = false;
        boolean firstGroupValue = true;
        String languageShortCode = "";
        Object object = matchResult;
        if (object == null || (object = object.getGroupValues()) == null) {
            object = CollectionsKt.emptyList();
        }
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            String groupValue = (String)iterator.next();
            if (firstGroupValue) {
                firstGroupValue = false;
                continue;
            }
            if (!(((CharSequence)groupValue).length() > 0)) continue;
            languageShortCode = groupValue;
            break;
        }
        Settings settings = ((CharSequence)languageShortCode).length() > 0 ? Settings.copy$default(originalSettings, null, languageShortCode, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0x3FFFFD, null) : originalSettings;
        return CollectionsKt.listOf((Object)new CodeFragment(this.getCodeLanguageId(), code, 0, settings, null, 16, null));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/bsplines/ltexls/parsing/markdown/MarkdownFragmentizer$Companion;", "", "()V", "COMMENT_REGEX", "Lkotlin/text/Regex;", "YAML_FRONT_MATTER_REGEX", "ltexls"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

