/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.ltexls.parsing.markdown;

import com.vladsch.flexmark.ext.definition.DefinitionExtension;
import com.vladsch.flexmark.ext.gfm.strikethrough.StrikethroughExtension;
import com.vladsch.flexmark.ext.gitlab.GitLabExtension;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.ext.yaml.front.matter.YamlFrontMatterExtension;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.test.util.AstCollectingVisitor;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import com.vladsch.flexmark.util.sequence.Escaping;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bsplines.ltexls.parsing.CodeAnnotatedTextBuilder;
import org.bsplines.ltexls.parsing.DummyGenerator;
import org.bsplines.ltexls.parsing.markdown.LtexMarkdownExtension;
import org.bsplines.ltexls.parsing.markdown.MarkdownAnnotatedTextBuilderDefaults;
import org.bsplines.ltexls.parsing.markdown.MarkdownNodeSignature;
import org.bsplines.ltexls.settings.Settings;
import org.bsplines.ltexls.tools.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 %2\u00020\u0001:\u0001%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0003H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\b\u0010\u001b\u001a\u00020\u0003H\u0002J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u0003H\u0002J\b\u0010\u001e\u001a\u00020\tH\u0002J\u0010\u0010\u001f\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u0003H\u0002J\u0010\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010$\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/bsplines/ltexls/parsing/markdown/MarkdownAnnotatedTextBuilder;", "Lorg/bsplines/ltexls/parsing/CodeAnnotatedTextBuilder;", "codeLanguageId", "", "(Ljava/lang/String;)V", "code", "dummyCounter", "", "firstCellInTableRow", "", "language", "nodeSignatures", "", "Lorg/bsplines/ltexls/parsing/markdown/MarkdownNodeSignature;", "nodeTypeStack", "Lkotlin/collections/ArrayDeque;", "parser", "Lcom/vladsch/flexmark/parser/Parser;", "pos", "addCode", "addMarkup", "", "node", "Lcom/vladsch/flexmark/util/ast/Node;", "interpretAs", "newPos", "addText", "generateDummy", "isDummyNodeType", "nodeType", "isInIgnoredNodeType", "isInNodeType", "setSettings", "settings", "Lorg/bsplines/ltexls/settings/Settings;", "visit", "visitChildren", "Companion", "ltexls"})
public final class MarkdownAnnotatedTextBuilder
extends CodeAnnotatedTextBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Parser parser;
    @NotNull
    private String code;
    private int pos;
    private int dummyCounter;
    private boolean firstCellInTableRow;
    @NotNull
    private final ArrayDeque<String> nodeTypeStack;
    @NotNull
    private String language;
    @NotNull
    private final List<MarkdownNodeSignature> nodeSignatures;
    @NotNull
    private static final DataHolder PARSER_OPTIONS;

    public MarkdownAnnotatedTextBuilder(@NotNull String codeLanguageId) {
        Intrinsics.checkNotNullParameter((Object)codeLanguageId, (String)"codeLanguageId");
        super(codeLanguageId);
        Parser parser = Parser.builder((DataHolder)PARSER_OPTIONS).build();
        Intrinsics.checkNotNullExpressionValue((Object)parser, (String)"builder(PARSER_OPTIONS).build()");
        this.parser = parser;
        this.code = "";
        this.nodeTypeStack = new ArrayDeque();
        this.language = "en-US";
        this.nodeSignatures = new ArrayList(MarkdownAnnotatedTextBuilderDefaults.INSTANCE.getDEFAULT_MARKDOWN_NODE_SIGNATURES());
    }

    private final boolean isInNodeType(String nodeType) {
        return this.nodeTypeStack.contains((Object)nodeType);
    }

    private final boolean isInIgnoredNodeType() {
        boolean result = false;
        for (String nodeType : this.nodeTypeStack) {
            for (MarkdownNodeSignature nodeSignature : this.nodeSignatures) {
                if (!Intrinsics.areEqual((Object)nodeSignature.getName(), (Object)nodeType)) continue;
                result = nodeSignature.getAction() == MarkdownNodeSignature.Action.Ignore;
            }
        }
        return result;
    }

    private final boolean isDummyNodeType(String nodeType) {
        boolean result = false;
        for (MarkdownNodeSignature nodeSignature : this.nodeSignatures) {
            if (!Intrinsics.areEqual((Object)nodeSignature.getName(), (Object)nodeType)) continue;
            result = nodeSignature.getAction() == MarkdownNodeSignature.Action.Dummy;
        }
        return result;
    }

    private final void addMarkup(int newPos) {
        boolean inParagraph = this.isInNodeType("Paragraph");
        while (this.pos < this.code.length() && this.pos < newPos) {
            int curPos = StringsKt.indexOf$default((CharSequence)this.code, (String)"\r\n", (int)this.pos, (boolean)false, (int)4, null);
            if (curPos != -1) {
                ++curPos;
            }
            if ((curPos == -1 || curPos >= newPos) && ((curPos = StringsKt.indexOf$default((CharSequence)this.code, (char)'\n', (int)this.pos, (boolean)false, (int)4, null)) == -1 || curPos >= newPos)) break;
            if (curPos > this.pos) {
                String string = this.code.substring(this.pos, curPos);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                super.addMarkup(string);
            }
            String string = this.code.substring(curPos, curPos + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            super.addMarkup(string, inParagraph ? " " : "\n");
            this.pos = curPos + 1;
        }
        if (newPos > this.pos) {
            String string = this.code.substring(this.pos, newPos);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            super.addMarkup(string);
            this.pos = newPos;
        }
    }

    private final void addMarkup(Node node, String interpretAs) {
        this.addMarkup(node.getStartOffset());
        int newPos = node.getEndOffset();
        String string = this.code.substring(this.pos, newPos);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        super.addMarkup(string, interpretAs);
        this.pos = newPos;
    }

    private final void addText(int newPos) {
        if (newPos > this.pos) {
            String string = this.code.substring(this.pos, newPos);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            super.addText(string);
            this.pos = newPos;
        }
    }

    private final String generateDummy() {
        int n = this.dummyCounter;
        this.dummyCounter = n + 1;
        return DummyGenerator.generate$default(DummyGenerator.Companion.getInstance$default(DummyGenerator.Companion, false, false, 3, null), this.language, n, false, 4, null);
    }

    @Override
    @NotNull
    public MarkdownAnnotatedTextBuilder addCode(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Document document = this.parser.parse(code);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"this.parser.parse(code)");
        Document document2 = document;
        if (Logging.INSTANCE.getLOGGER().isLoggable(Level.FINEST)) {
            Logging.INSTANCE.getLOGGER().finest("flexmarkAst = " + new AstCollectingVisitor().collectAndGetAstText((Node)document2));
        }
        this.code = code;
        this.pos = 0;
        this.visitChildren((Node)document2);
        if (this.pos < this.code.length()) {
            this.addMarkup(this.code.length());
        }
        return this;
    }

    private final void visit(Node node) {
        String string = node.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.javaClass.simpleName");
        String nodeType = string;
        if (Intrinsics.areEqual((Object)nodeType, (Object)"TableRow")) {
            this.firstCellInTableRow = true;
        } else if (Intrinsics.areEqual((Object)nodeType, (Object)"TableCell")) {
            if (this.firstCellInTableRow) {
                this.firstCellInTableRow = false;
            } else {
                super.addMarkup("", " ");
            }
        }
        if (this.isInIgnoredNodeType()) {
            this.addMarkup(node.getEndOffset());
        } else if (this.isDummyNodeType(nodeType)) {
            this.addMarkup(node, this.generateDummy());
        } else if (Intrinsics.areEqual((Object)nodeType, (Object)"Text")) {
            this.addMarkup(node.getStartOffset());
            this.addText(node.getEndOffset());
        } else if (Intrinsics.areEqual((Object)nodeType, (Object)"HtmlEntity")) {
            String string2 = Escaping.unescapeHtml((CharSequence)((CharSequence)node.getChars()));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"unescapeHtml(node.chars)");
            this.addMarkup(node, string2);
        } else {
            if (Intrinsics.areEqual((Object)nodeType, (Object)"Paragraph")) {
                this.addMarkup(node.getStartOffset());
            }
            this.nodeTypeStack.addLast((Object)nodeType);
            this.visitChildren(node);
            this.nodeTypeStack.removeLastOrNull();
            if (Intrinsics.areEqual((Object)nodeType, (Object)"DefinitionTerm")) {
                super.addMarkup("", ".");
            }
        }
    }

    private final void visitChildren(Node node) {
        for (Object object : node.getChildren()) {
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"node.children");
            Node child = (Node)object;
            this.visit(child);
        }
    }

    @Override
    public void setSettings(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.language = settings.getLanguageShortCode();
        block12: for (Map.Entry<String, String> entry : settings.getMarkdownNodes().entrySet()) {
            MarkdownNodeSignature.Action action;
            String nodeName = entry.getKey();
            String actionString = entry.getValue();
            DummyGenerator dummyGenerator = DummyGenerator.Companion.getInstance$default(DummyGenerator.Companion, false, false, 3, null);
            switch (actionString) {
                case "default": {
                    action = MarkdownNodeSignature.Action.Default;
                    break;
                }
                case "ignore": {
                    action = MarkdownNodeSignature.Action.Ignore;
                    break;
                }
                case "dummy": 
                case "vowelDummy": 
                case "pluralDummy": {
                    boolean plural = Intrinsics.areEqual((Object)actionString, (Object)"pluralDummy");
                    boolean vowel = Intrinsics.areEqual((Object)actionString, (Object)"vowelDummy");
                    dummyGenerator = DummyGenerator.Companion.getInstance(plural, vowel);
                    action = MarkdownNodeSignature.Action.Dummy;
                    break;
                }
                default: {
                    continue block12;
                }
            }
            MarkdownNodeSignature.Action action2 = action;
            this.nodeSignatures.add(new MarkdownNodeSignature(nodeName, action2, dummyGenerator));
        }
    }

    static {
        Object[] objectArray = new Parser.ParserExtension[]{(Parser.ParserExtension)DefinitionExtension.create(), (Parser.ParserExtension)GitLabExtension.create(), LtexMarkdownExtension.Companion.create(), (Parser.ParserExtension)StrikethroughExtension.create(), (Parser.ParserExtension)TablesExtension.create(), (Parser.ParserExtension)YamlFrontMatterExtension.create()};
        MutableDataSet mutableDataSet = new MutableDataSet().set(Parser.EXTENSIONS, (Object)CollectionsKt.listOf((Object[])objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)mutableDataSet, (String)"MutableDataSet().set(\n  \u2026.create(),\n      ),\n    )");
        PARSER_OPTIONS = (DataHolder)mutableDataSet;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/bsplines/ltexls/parsing/markdown/MarkdownAnnotatedTextBuilder$Companion;", "", "()V", "PARSER_OPTIONS", "Lcom/vladsch/flexmark/util/data/DataHolder;", "ltexls"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

