/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.ltexls.parsing.latex;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.bsplines.ltexls.parsing.latex.LatexCommandSignature;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0018\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0007J\u000e\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007J\u0006\u0010\u0017\u001a\u00020\u0007R#\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lorg/bsplines/ltexls/parsing/latex/LatexCommandSignatureMatch;", "", "commandSignature", "Lorg/bsplines/ltexls/parsing/latex/LatexCommandSignature;", "code", "", "fromPos", "", "argumentPos", "", "Lkotlin/Pair;", "(Lorg/bsplines/ltexls/parsing/latex/LatexCommandSignature;Ljava/lang/String;ILjava/util/List;)V", "getArgumentPos", "()Ljava/util/List;", "getCommandSignature", "()Lorg/bsplines/ltexls/parsing/latex/LatexCommandSignature;", "getFromPos", "()I", "toPos", "getToPos", "getArgumentContents", "index", "getArgumentContentsFromPos", "getArgumentsSize", "ltexls"})
public final class LatexCommandSignatureMatch {
    @NotNull
    private final LatexCommandSignature commandSignature;
    @NotNull
    private final String code;
    private final int fromPos;
    @NotNull
    private final List<Pair<Integer, Integer>> argumentPos;
    private final int toPos;

    public LatexCommandSignatureMatch(@NotNull LatexCommandSignature commandSignature, @NotNull String code, int fromPos, @NotNull List<Pair<Integer, Integer>> argumentPos) {
        Intrinsics.checkNotNullParameter((Object)commandSignature, (String)"commandSignature");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter(argumentPos, (String)"argumentPos");
        this.commandSignature = commandSignature;
        this.code = code;
        this.fromPos = fromPos;
        this.argumentPos = argumentPos;
        this.toPos = this.argumentPos.isEmpty() ? this.fromPos + this.commandSignature.getPrefix().length() : ((Number)this.argumentPos.get(this.argumentPos.size() - 1).getSecond()).intValue();
    }

    @NotNull
    public final LatexCommandSignature getCommandSignature() {
        return this.commandSignature;
    }

    public final int getFromPos() {
        return this.fromPos;
    }

    @NotNull
    public final List<Pair<Integer, Integer>> getArgumentPos() {
        return this.argumentPos;
    }

    public final int getToPos() {
        return this.toPos;
    }

    @NotNull
    public final String getArgumentContents(int index) {
        Pair<Integer, Integer> argument = this.argumentPos.get(index);
        int argumentFromPos = ((Number)argument.getFirst()).intValue() + 1;
        int argumentToPos = ((Number)argument.getSecond()).intValue() - 1;
        String string = this.code.substring(argumentFromPos, argumentToPos);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    public final int getArgumentContentsFromPos(int index) {
        return ((Number)this.argumentPos.get(index).getFirst()).intValue() + 1;
    }

    public final int getArgumentsSize() {
        return this.argumentPos.size();
    }
}

