/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.ltexls.parsing.latex;

import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.bsplines.ltexls.parsing.CharacterBasedCodeAnnotatedTextBuilder;
import org.bsplines.ltexls.parsing.DummyGenerator;
import org.bsplines.ltexls.parsing.latex.LatexAnnotatedTextBuilderDefaults;
import org.bsplines.ltexls.parsing.latex.LatexCommandSignature;
import org.bsplines.ltexls.parsing.latex.LatexEnvironmentSignature;
import org.bsplines.ltexls.settings.Settings;
import org.bsplines.ltexls.tools.I18n;
import org.bsplines.ltexls.tools.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 A2\u00020\u0001:\u0003ABCB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u001f\u001a\u00020\u00002\b\u0010 \u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u001f\u001a\u00020\u00002\b\u0010 \u001a\u0004\u0018\u00010\u00032\b\u0010!\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010\"\u001a\u00020\u00002\b\u0010#\u001a\u0004\u0018\u00010\u0003H\u0016J\u0018\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003H\u0002J\b\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020(H\u0002J\b\u0010*\u001a\u00020\u0003H\u0014J\u0010\u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020,H\u0002J\u001a\u0010-\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u00152\b\b\u0002\u0010/\u001a\u000200H\u0002J\b\u00101\u001a\u00020(H\u0002J\b\u00102\u001a\u00020(H\u0002J\b\u00103\u001a\u00020(H\u0014J\b\u00104\u001a\u00020(H\u0002J\b\u00105\u001a\u00020(H\u0002J\b\u00106\u001a\u00020(H\u0002J\b\u00107\u001a\u00020(H\u0002J\b\u00108\u001a\u00020(H\u0002J\b\u00109\u001a\u00020(H\u0002J\b\u0010:\u001a\u00020(H\u0002J\b\u0010;\u001a\u00020(H\u0002J\b\u0010<\u001a\u00020(H\u0002J\u0010\u0010=\u001a\u00020(2\u0006\u0010>\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u00020(2\u0006\u0010#\u001a\u00020\u0003H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lorg/bsplines/ltexls/parsing/latex/LatexAnnotatedTextBuilder;", "Lorg/bsplines/ltexls/parsing/CharacterBasedCodeAnnotatedTextBuilder;", "codeLanguageId", "", "(Ljava/lang/String;)V", "canInsertSpaceBeforeDummy", "", "commandSignatureMap", "", "", "Lorg/bsplines/ltexls/parsing/latex/LatexCommandSignature;", "commandSignatures", "", "curMode", "Lorg/bsplines/ltexls/parsing/latex/LatexAnnotatedTextBuilder$Mode;", "dummyLastPunctuation", "dummyLastSpace", "environmentSignatureMap", "Lorg/bsplines/ltexls/parsing/latex/LatexEnvironmentSignature;", "environmentSignatures", "ignoreEnvironmentEndRegex", "Lkotlin/text/Regex;", "isMathCharTrivial", "isMathEmpty", "lastPunctuation", "lastSpace", "mathVowelState", "Lorg/bsplines/ltexls/parsing/latex/LatexAnnotatedTextBuilder$MathVowelState;", "modeStack", "Lkotlin/collections/ArrayDeque;", "preserveDummyLast", "addMarkup", "markup", "interpretAs", "addText", "text", "convertAccentCommandToUnicode", "accentCommand", "letter", "enterDisplayMath", "", "enterInlineMath", "generateDummy", "dummyGenerator", "Lorg/bsplines/ltexls/parsing/DummyGenerator;", "matchFromPositionAsString", "regex", "pos", "", "popMode", "processBackslash", "processCharacter", "processClosingBrace", "processDefaultCharacter", "processDollar", "processEnvironmentArguments", "processIgnoredEnvironmentContents", "processOpeningBrace", "processPercentage", "processQuotationMark", "processWhitespace", "setSettings", "settings", "Lorg/bsplines/ltexls/settings/Settings;", "textAdded", "Companion", "MathVowelState", "Mode", "ltexls"})
@SourceDebugExtension(value={"SMAP\nLatexAnnotatedTextBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LatexAnnotatedTextBuilder.kt\norg/bsplines/ltexls/parsing/latex/LatexAnnotatedTextBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,993:1\n1#2:994\n*E\n"})
public final class LatexAnnotatedTextBuilder
extends CharacterBasedCodeAnnotatedTextBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String lastSpace;
    @NotNull
    private String lastPunctuation;
    @NotNull
    private String dummyLastSpace;
    @NotNull
    private String dummyLastPunctuation;
    private boolean isMathEmpty;
    @NotNull
    private MathVowelState mathVowelState;
    private boolean preserveDummyLast;
    private boolean canInsertSpaceBeforeDummy;
    private boolean isMathCharTrivial;
    @Nullable
    private Regex ignoreEnvironmentEndRegex;
    @NotNull
    private ArrayDeque<Mode> modeStack;
    @NotNull
    private Mode curMode;
    @NotNull
    private final List<LatexCommandSignature> commandSignatures;
    @NotNull
    private Map<String, ? extends List<? extends LatexCommandSignature>> commandSignatureMap;
    @NotNull
    private final List<LatexEnvironmentSignature> environmentSignatures;
    @NotNull
    private Map<String, ? extends List<LatexEnvironmentSignature>> environmentSignatureMap;
    @NotNull
    private static final String LENGTH_REGEX_STRING = "-?[0-9]*(\\.[0-9]+)?(pt|mm|cm|ex|em|bp|dd|pc|in)";
    @NotNull
    private static final String ACCENT_REGEX_STRING = "(?<accentCommand>\\\\[`'^~\"=.Hbcdkruv])(?: *(?<letter1>[A-Za-z]|\\\\i|\\\\j)|\\{(?<letter2>[A-Za-z]|\\\\i|\\\\j)})";
    @NotNull
    private static final Regex COMMAND_REGEX = new Regex("^\\\\(([^A-Za-z@]|([A-Za-z@]+))\\*?)");
    @NotNull
    private static final Regex ARGUMENT_REGEX = new Regex("^\\{[^}]*?}");
    @NotNull
    private static final Regex COMMENT_REGEX = new Regex("^%.*?($|(\r?\n[ \n\r\t]*))");
    @NotNull
    private static final Regex WHITESPACE_REGEX = new Regex("^[ \n\r\t]+(%.*?($|(\r?\n[ \n\r\t]*)))?");
    @NotNull
    private static final Regex LENGTH_IN_BRACE_REGEX = new Regex("^\\{-?[0-9]*(\\.[0-9]+)?(pt|mm|cm|ex|em|bp|dd|pc|in)}");
    @NotNull
    private static final Regex LENGTH_IN_BRACKET_REGEX = new Regex("^\\[-?[0-9]*(\\.[0-9]+)?(pt|mm|cm|ex|em|bp|dd|pc|in)]");
    @NotNull
    private static final Regex EM_DASH_REGEX = new Regex("^---");
    @NotNull
    private static final Regex EN_DASH_REGEX = new Regex("^--");
    @NotNull
    private static final Regex ACCENT_REGEX = new Regex("^(?<accentCommand>\\\\[`'^~\"=.Hbcdkruv])(?: *(?<letter1>[A-Za-z]|\\\\i|\\\\j)|\\{(?<letter2>[A-Za-z]|\\\\i|\\\\j)})");
    @NotNull
    private static final Regex ACCENT_IN_BRACE_REGEX = new Regex("^\\{(?<accentCommand>\\\\[`'^~\"=.Hbcdkruv])(?: *(?<letter1>[A-Za-z]|\\\\i|\\\\j)|\\{(?<letter2>[A-Za-z]|\\\\i|\\\\j)})}");
    @NotNull
    private static final Regex DISPLAY_MATH_REGEX = new Regex("^\\$\\$");
    @NotNull
    private static final Regex VERB_COMMAND_REGEX = new Regex("^\\\\verb\\*?(.).*?\\1");
    @NotNull
    private static final Regex RSWEAVE_BEGIN_REGEX = new Regex("^<<.*?>>=");
    @NotNull
    private static final Regex RSWEAVE_END_REGEX = new Regex("^@");
    @NotNull
    private static final List<String> MATH_ENVIRONMENTS;
    private static final int LENGTH_OF_START_PREFIX = 6;
    private static final int LENGTH_OF_STOP_PREFIX = 5;

    public LatexAnnotatedTextBuilder(@NotNull String codeLanguageId) {
        Intrinsics.checkNotNullParameter((Object)codeLanguageId, (String)"codeLanguageId");
        super(codeLanguageId);
        this.lastSpace = "";
        this.lastPunctuation = "";
        this.dummyLastSpace = "";
        this.dummyLastPunctuation = "";
        this.mathVowelState = MathVowelState.Undecided;
        this.modeStack = new ArrayDeque((Collection)CollectionsKt.listOf((Object)((Object)Mode.ParagraphText)));
        this.curMode = Mode.ParagraphText;
        this.commandSignatures = new ArrayList(LatexAnnotatedTextBuilderDefaults.INSTANCE.getDEFAULT_LATEX_COMMAND_SIGNATURES());
        this.commandSignatureMap = LatexAnnotatedTextBuilder.Companion.createCommandSignatureMap(this.commandSignatures);
        this.environmentSignatures = new ArrayList(LatexAnnotatedTextBuilderDefaults.INSTANCE.getDEFAULT_LATEX_ENVIRONMENT_SIGNATURES());
        this.environmentSignatureMap = LatexAnnotatedTextBuilder.Companion.createCommandSignatureMap(this.environmentSignatures);
    }

    @Override
    public void setSettings(@NotNull Settings settings) {
        String actionString;
        String key;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super.setSettings(settings);
        this.setLanguage(settings.getLanguageShortCode());
        this.commandSignatures.clear();
        this.commandSignatures.addAll((Collection<LatexCommandSignature>)LatexAnnotatedTextBuilderDefaults.INSTANCE.getDEFAULT_LATEX_COMMAND_SIGNATURES());
        block12: for (Map.Entry<String, String> entry : settings.getLatexCommands().entrySet()) {
            LatexCommandSignature.Action action;
            key = entry.getKey();
            actionString = entry.getValue();
            DummyGenerator dummyGenerator = DummyGenerator.Companion.getInstance$default(DummyGenerator.Companion, false, false, 3, null);
            switch (actionString) {
                case "default": {
                    action = LatexCommandSignature.Action.Default;
                    break;
                }
                case "ignore": {
                    action = LatexCommandSignature.Action.Ignore;
                    break;
                }
                case "dummy": 
                case "vowelDummy": 
                case "pluralDummy": {
                    boolean plural = Intrinsics.areEqual((Object)actionString, (Object)"pluralDummy");
                    boolean vowel = Intrinsics.areEqual((Object)actionString, (Object)"vowelDummy");
                    dummyGenerator = DummyGenerator.Companion.getInstance(plural, vowel);
                    action = LatexCommandSignature.Action.Dummy;
                    break;
                }
                default: {
                    continue block12;
                }
            }
            LatexCommandSignature.Action action2 = action;
            this.commandSignatures.add(new LatexCommandSignature(key, action2, dummyGenerator, false, 8, null));
        }
        this.commandSignatureMap = LatexAnnotatedTextBuilder.Companion.createCommandSignatureMap(this.commandSignatures);
        this.environmentSignatures.clear();
        this.environmentSignatures.addAll((Collection<LatexEnvironmentSignature>)LatexAnnotatedTextBuilderDefaults.INSTANCE.getDEFAULT_LATEX_ENVIRONMENT_SIGNATURES());
        for (Map.Entry<String, String> entry : settings.getLatexEnvironments().entrySet()) {
            LatexCommandSignature.Action action;
            key = entry.getKey();
            actionString = entry.getValue();
            if (Intrinsics.areEqual((Object)actionString, (Object)"default")) {
                action = LatexCommandSignature.Action.Default;
            } else {
                if (!Intrinsics.areEqual((Object)actionString, (Object)"ignore")) continue;
                action = LatexCommandSignature.Action.Ignore;
            }
            LatexCommandSignature.Action action3 = action;
            this.environmentSignatures.add(new LatexEnvironmentSignature(key, action3));
        }
        this.environmentSignatureMap = LatexAnnotatedTextBuilder.Companion.createCommandSignatureMap(this.environmentSignatures);
    }

    @Override
    @NotNull
    public LatexAnnotatedTextBuilder addText(@Nullable String text) {
        super.addText(text);
        String string = text;
        boolean bl = string != null ? ((CharSequence)string).length() > 0 : false;
        if (bl) {
            this.textAdded(text);
        }
        return this;
    }

    @Override
    @NotNull
    public LatexAnnotatedTextBuilder addMarkup(@Nullable String markup) {
        super.addMarkup(markup);
        String string = markup;
        boolean bl = string != null ? ((CharSequence)string).length() > 0 : false;
        if (bl) {
            if (this.preserveDummyLast) {
                this.preserveDummyLast = false;
            } else {
                this.dummyLastSpace = "";
                this.dummyLastPunctuation = "";
            }
        }
        return this;
    }

    @Override
    @NotNull
    public LatexAnnotatedTextBuilder addMarkup(@Nullable String markup, @Nullable String interpretAs) {
        super.addMarkup(markup, interpretAs);
        String string = interpretAs;
        boolean bl = string != null ? ((CharSequence)string).length() > 0 : false;
        if (bl) {
            this.preserveDummyLast = false;
            this.textAdded(interpretAs);
        }
        return this;
    }

    @Override
    protected void processCharacter() {
        this.curMode = (Mode)((Object)this.modeStack.last());
        this.isMathCharTrivial = false;
        if (LatexAnnotatedTextBuilder.Companion.isIgnoreEnvironmentMode(this.curMode)) {
            this.processIgnoredEnvironmentContents();
        } else if (Intrinsics.areEqual((Object)this.getCodeLanguageId(), (Object)"rsweave") && LatexAnnotatedTextBuilder.Companion.isRsweaveMode(this.curMode)) {
            String rsweaveEnd = LatexAnnotatedTextBuilder.matchFromPositionAsString$default(this, RSWEAVE_END_REGEX, 0, 2, null);
            if (((CharSequence)rsweaveEnd).length() > 0) {
                this.popMode();
                this.addMarkup(rsweaveEnd);
            } else {
                this.addMarkup(this.getCurString());
            }
        } else {
            char c = this.getCurChar();
            if (c == '\\') {
                this.processBackslash();
            } else if (c == '{') {
                this.processOpeningBrace();
            } else if (c == '}') {
                this.processClosingBrace();
            } else if (c == '$') {
                this.processDollar();
            } else if (c == '%') {
                this.processPercentage();
            } else if (((((c == ' ' ? true : c == '&') ? true : c == '~') ? true : c == '\n') ? true : c == '\r') ? true : c == '\t') {
                this.processWhitespace();
            } else if ((c == '`' ? true : c == '\'') ? true : c == '\"') {
                this.processQuotationMark();
            } else {
                this.processDefaultCharacter();
            }
        }
        if (!this.isMathCharTrivial) {
            this.canInsertSpaceBeforeDummy = false;
            this.isMathEmpty = false;
        }
    }

    private final void processIgnoredEnvironmentContents() {
        Regex ignoreEnvironmentEndRegex = this.ignoreEnvironmentEndRegex;
        if (ignoreEnvironmentEndRegex != null) {
            String ignoreEnvironmentEnd = LatexAnnotatedTextBuilder.matchFromPositionAsString$default(this, ignoreEnvironmentEndRegex, 0, 2, null);
            if (((CharSequence)ignoreEnvironmentEnd).length() > 0) {
                this.popMode();
                this.addMarkup(ignoreEnvironmentEnd);
            } else {
                this.addMarkup(this.getCurString());
            }
        } else {
            Logging.INSTANCE.getLOGGER().warning(I18n.INSTANCE.format("ignoreEnvironmentEndPatternNotSet", new Object[0]));
            this.popMode();
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void processBackslash() {
        block122: {
            block149: {
                block150: {
                    block148: {
                        block147: {
                            block146: {
                                block145: {
                                    block144: {
                                        block140: {
                                            block143: {
                                                block141: {
                                                    block139: {
                                                        block138: {
                                                            block137: {
                                                                block136: {
                                                                    block135: {
                                                                        block134: {
                                                                            block133: {
                                                                                block132: {
                                                                                    block131: {
                                                                                        block130: {
                                                                                            block129: {
                                                                                                block128: {
                                                                                                    block127: {
                                                                                                        block126: {
                                                                                                            block125: {
                                                                                                                block124: {
                                                                                                                    block123: {
                                                                                                                        block121: {
                                                                                                                            command = LatexAnnotatedTextBuilder.matchFromPositionAsString$default(this, LatexAnnotatedTextBuilder.COMMAND_REGEX, 0, 2, null);
                                                                                                                            if (!Intrinsics.areEqual((Object)command, (Object)"\\begin") && !Intrinsics.areEqual((Object)command, (Object)"\\end") && !StringsKt.startsWith$default((String)command, (String)"\\start", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)command, (String)"\\stop", (boolean)false, (int)2, null)) break block121;
                                                                                                                            this.preserveDummyLast = true;
                                                                                                                            isBeginEnvironment = Intrinsics.areEqual((Object)command, (Object)"\\begin") != false || StringsKt.startsWith$default((String)command, (String)"\\start", (boolean)false, (int)2, null) != false;
                                                                                                                            argument = null;
                                                                                                                            environmentName = null;
                                                                                                                            if (Intrinsics.areEqual((Object)command, (Object)"\\begin") || Intrinsics.areEqual((Object)command, (Object)"\\end")) {
                                                                                                                                argument = this.matchFromPositionAsString(LatexAnnotatedTextBuilder.ARGUMENT_REGEX, this.getPos() + command.length());
                                                                                                                                if (argument.length() >= 2) {
                                                                                                                                    v0 = argument.substring(1, argument.length() - 1);
                                                                                                                                    v1 = v0;
                                                                                                                                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                                                                                                                                } else {
                                                                                                                                    v1 = "";
                                                                                                                                }
                                                                                                                                environmentName = v1;
                                                                                                                            } else {
                                                                                                                                argument = "";
                                                                                                                                v2 = command.substring(isBeginEnvironment != false ? 6 : 5);
                                                                                                                                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"this as java.lang.String).substring(startIndex)");
                                                                                                                                environmentName = v2;
                                                                                                                            }
                                                                                                                            argumentsProcessed = false;
                                                                                                                            interpretAs = "";
                                                                                                                            if (LatexAnnotatedTextBuilder.MATH_ENVIRONMENTS.contains(environmentName)) {
                                                                                                                                this.addMarkup((String)command);
                                                                                                                                if (isBeginEnvironment) {
                                                                                                                                    if (Intrinsics.areEqual((Object)environmentName, (Object)"math")) {
                                                                                                                                        this.enterInlineMath();
                                                                                                                                    } else {
                                                                                                                                        this.enterDisplayMath();
                                                                                                                                    }
                                                                                                                                } else {
                                                                                                                                    this.popMode();
                                                                                                                                    interpretAs = this.generateDummy();
                                                                                                                                }
                                                                                                                            } else if (isBeginEnvironment) {
                                                                                                                                v3 = this.environmentSignatureMap.get((String)command + argument);
                                                                                                                                if (v3 == null) {
                                                                                                                                    v3 = CollectionsKt.emptyList();
                                                                                                                                }
                                                                                                                                possibleEnvironmentSignatures = v3;
                                                                                                                                match = "";
                                                                                                                                matchingEnvironmentSignature = null;
                                                                                                                                for (LatexEnvironmentSignature latexEnvironmentSignature : possibleEnvironmentSignatures) {
                                                                                                                                    curMatch = latexEnvironmentSignature.matchFromPosition(this.getCode(), this.getPos());
                                                                                                                                    if (!(((CharSequence)curMatch).length() > 0) || curMatch.length() < match.length() && !latexEnvironmentSignature.getIgnoreAllArguments()) continue;
                                                                                                                                    match = curMatch;
                                                                                                                                    matchingEnvironmentSignature = latexEnvironmentSignature;
                                                                                                                                }
                                                                                                                                if (matchingEnvironmentSignature != null) {
                                                                                                                                    if (matchingEnvironmentSignature.getAction() == LatexCommandSignature.Action.Ignore) {
                                                                                                                                        this.modeStack.add((Object)Mode.IgnoreEnvironment);
                                                                                                                                        v4 = this.ignoreEnvironmentEndRegex = Intrinsics.areEqual((Object)command, (Object)"\\begin") != false ? new Regex("^\\\\end\\{" + Regex.Companion.escape(environmentName) + "}") : new Regex("^\\\\stop" + Regex.Companion.escape(environmentName) + "(?![A-Za-z])");
                                                                                                                                    }
                                                                                                                                    if (matchingEnvironmentSignature.getIgnoreAllArguments()) {
                                                                                                                                        this.addMarkup((String)command);
                                                                                                                                    } else {
                                                                                                                                        this.addMarkup(match);
                                                                                                                                        argumentsProcessed = true;
                                                                                                                                    }
                                                                                                                                } else {
                                                                                                                                    this.addMarkup((String)command);
                                                                                                                                    this.modeStack.addLast((Object)this.curMode);
                                                                                                                                }
                                                                                                                            } else {
                                                                                                                                this.addMarkup((String)command);
                                                                                                                                this.popMode();
                                                                                                                            }
                                                                                                                            if (!org.bsplines.ltexls.parsing.latex.LatexAnnotatedTextBuilder$Companion.access$isIgnoreEnvironmentMode(LatexAnnotatedTextBuilder.Companion, (Mode)this.modeStack.lastOrNull())) {
                                                                                                                                this.isMathCharTrivial = true;
                                                                                                                                this.preserveDummyLast = true;
                                                                                                                                if (!argumentsProcessed) {
                                                                                                                                    this.addMarkup(argument, interpretAs);
                                                                                                                                    if (isBeginEnvironment) {
                                                                                                                                        this.processEnvironmentArguments();
                                                                                                                                        ** GOTO lbl466
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                            break block122;
                                                                                                                        }
                                                                                                                        if (!Intrinsics.areEqual((Object)command, (Object)"\\$") && !Intrinsics.areEqual((Object)command, (Object)"\\%") && !Intrinsics.areEqual((Object)command, (Object)"\\&")) break block123;
                                                                                                                        v5 = command.substring(1);
                                                                                                                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"this as java.lang.String).substring(startIndex)");
                                                                                                                        this.addMarkup((String)command, v5);
                                                                                                                        break block122;
                                                                                                                    }
                                                                                                                    if (!Intrinsics.areEqual((Object)command, (Object)"\\[")) break block124;
                                                                                                                    this.enterDisplayMath();
                                                                                                                    this.addMarkup((String)command);
                                                                                                                    break block122;
                                                                                                                }
                                                                                                                if (!Intrinsics.areEqual((Object)command, (Object)"\\(")) break block125;
                                                                                                                this.enterInlineMath();
                                                                                                                this.addMarkup((String)command);
                                                                                                                break block122;
                                                                                                            }
                                                                                                            if (!Intrinsics.areEqual((Object)command, (Object)"\\]") && !Intrinsics.areEqual((Object)command, (Object)"\\)")) break block126;
                                                                                                            this.popMode();
                                                                                                            this.addMarkup((String)command, this.generateDummy());
                                                                                                            break block122;
                                                                                                        }
                                                                                                        if (!Intrinsics.areEqual((Object)command, (Object)"\\AA")) break block127;
                                                                                                        this.addMarkup((String)command, org.bsplines.ltexls.parsing.latex.LatexAnnotatedTextBuilder$Companion.access$isMathMode(LatexAnnotatedTextBuilder.Companion, this.curMode) != false ? "" : "\u00c5");
                                                                                                        break block122;
                                                                                                    }
                                                                                                    if (!Intrinsics.areEqual((Object)command, (Object)"\\L")) break block128;
                                                                                                    this.addMarkup((String)command, org.bsplines.ltexls.parsing.latex.LatexAnnotatedTextBuilder$Companion.access$isMathMode(LatexAnnotatedTextBuilder.Companion, this.curMode) != false ? "" : "\u0141");
                                                                                                    break block122;
                                                                                                }
                                                                                                if (!Intrinsics.areEqual((Object)command, (Object)"\\O")) break block129;
                                                                                                this.addMarkup((String)command, org.bsplines.ltexls.parsing.latex.LatexAnnotatedTextBuilder$Companion.access$isMathMode(LatexAnnotatedTextBuilder.Companion, this.curMode) != false ? "" : "\u00d8");
                                                                                                break block122;
                                                                                            }
                                                                                            if (!Intrinsics.areEqual((Object)command, (Object)"\\SS")) break block130;
                                                                                            this.addMarkup((String)command, org.bsplines.ltexls.parsing.latex.LatexAnnotatedTextBuilder$Companion.access$isMathMode(LatexAnnotatedTextBuilder.Companion, this.curMode) != false ? "" : "\u1e9e");
                                                                                            break block122;
                                                                                        }
                                                                                        if (!Intrinsics.areEqual((Object)command, (Object)"\\aa")) break block131;
                                                                                        this.addMarkup((String)command, org.bsplines.ltexls.parsing.latex.LatexAnnotatedTextBuilder$Companion.access$isMathMode(LatexAnnotatedTextBuilder.Companion, this.curMode) != false ? "" : "\u00e5");
                                                                                        break block122;
                                                                                    }
                                                                                    if (!Intrinsics.areEqual((Object)command, (Object)"\\i")) break block132;
                                                                                    this.addMarkup((String)command, org.bsplines.ltexls.parsing.latex.LatexAnnotatedTextBuilder$Companion.access$isMathMode(LatexAnnotatedTextBuilder.Companion, this.curMode) != false ? "" : "\u0131");
                                                                                    break block122;
                                                                                }
                                                                                if (!Intrinsics.areEqual((Object)command, (Object)"\\j")) break block133;
                                                                                this.addMarkup((String)command, org.bsplines.ltexls.parsing.latex.LatexAnnotatedTextBuilder$Companion.access$isMathMode(LatexAnnotatedTextBuilder.Companion, this.curMode) != false ? "" : "\u0237");
                                                                                break block122;
                                                                            }
                                                                            if (!Intrinsics.areEqual((Object)command, (Object)"\\l")) break block134;
                                                                            this.addMarkup((String)command, org.bsplines.ltexls.parsing.latex.LatexAnnotatedTextBuilder$Companion.access$isMathMode(LatexAnnotatedTextBuilder.Companion, this.curMode) != false ? "" : "\u0142");
                                                                            break block122;
                                                                        }
                                                                        if (!Intrinsics.areEqual((Object)command, (Object)"\\o")) break block135;
                                                                        this.addMarkup((String)command, org.bsplines.ltexls.parsing.latex.LatexAnnotatedTextBuilder$Companion.access$isMathMode(LatexAnnotatedTextBuilder.Companion, this.curMode) != false ? "" : "\u00f8");
                                                                        break block122;
                                                                    }
                                                                    if (!Intrinsics.areEqual((Object)command, (Object)"\\ss")) break block136;
                                                                    this.addMarkup((String)command, org.bsplines.ltexls.parsing.latex.LatexAnnotatedTextBuilder$Companion.access$isMathMode(LatexAnnotatedTextBuilder.Companion, this.curMode) != false ? "" : "\u00df");
                                                                    break block122;
                                                                }
                                                                if (!Intrinsics.areEqual((Object)command, (Object)"\\`") && !Intrinsics.areEqual((Object)command, (Object)"\\'") && !Intrinsics.areEqual((Object)command, (Object)"\\^") && !Intrinsics.areEqual((Object)command, (Object)"\\~") && !Intrinsics.areEqual((Object)command, (Object)"\\\"") && !Intrinsics.areEqual((Object)command, (Object)"\\=") && !Intrinsics.areEqual((Object)command, (Object)"\\.") && !Intrinsics.areEqual((Object)command, (Object)"\\H") && !Intrinsics.areEqual((Object)command, (Object)"\\b") && !Intrinsics.areEqual((Object)command, (Object)"\\c") && !Intrinsics.areEqual((Object)command, (Object)"\\d") && !Intrinsics.areEqual((Object)command, (Object)"\\k") && !Intrinsics.areEqual((Object)command, (Object)"\\r") && !Intrinsics.areEqual((Object)command, (Object)"\\u") && !Intrinsics.areEqual((Object)command, (Object)"\\v")) break block137;
                                                                if (!org.bsplines.ltexls.parsing.latex.LatexAnnotatedTextBuilder$Companion.access$isMathMode(LatexAnnotatedTextBuilder.Companion, this.curMode)) {
                                                                    v6 = this.getCode().substring(this.getPos());
                                                                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"this as java.lang.String).substring(startIndex)");
                                                                    matchResult = Regex.find$default((Regex)LatexAnnotatedTextBuilder.ACCENT_REGEX, (CharSequence)v6, (int)0, (int)2, null);
                                                                    if (matchResult != null) {
                                                                        v7 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)"accentCommand");
                                                                        accentCommand = v7 != null ? v7.getValue() : null;
                                                                        v8 /* !! */  = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)"letter1");
                                                                        if (v8 /* !! */  == null || (v8 /* !! */  = v8 /* !! */ .getValue()) == null) {
                                                                            v9 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)"letter2");
                                                                            v8 /* !! */  = v9 != null ? v9.getValue() : null;
                                                                        }
                                                                        letter /* !! */  = v8 /* !! */ ;
                                                                        interpretAs = accentCommand != null && letter /* !! */  != null ? this.convertAccentCommandToUnicode(accentCommand, (String)letter /* !! */ ) : "";
                                                                        this.addMarkup(matchResult.getValue(), interpretAs);
                                                                    } else {
                                                                        this.addMarkup((String)command);
                                                                    }
                                                                } else {
                                                                    this.addMarkup((String)command);
                                                                }
                                                                break block122;
                                                            }
                                                            if (!Intrinsics.areEqual((Object)command, (Object)"\\-")) break block138;
                                                            this.addMarkup((String)command);
                                                            break block122;
                                                        }
                                                        if (!Intrinsics.areEqual((Object)command, (Object)"\\ ") && !Intrinsics.areEqual((Object)command, (Object)"\\,") && !Intrinsics.areEqual((Object)command, (Object)"\\;") && !Intrinsics.areEqual((Object)command, (Object)"\\\\") && !Intrinsics.areEqual((Object)command, (Object)"\\hfill") && !Intrinsics.areEqual((Object)command, (Object)"\\hspace") && !Intrinsics.areEqual((Object)command, (Object)"\\hspace*") && !Intrinsics.areEqual((Object)command, (Object)"\\quad") && !Intrinsics.areEqual((Object)command, (Object)"\\qquad") && !Intrinsics.areEqual((Object)command, (Object)"\\newline")) break block139;
                                                        if (Intrinsics.areEqual((Object)command, (Object)"\\hspace") || Intrinsics.areEqual((Object)command, (Object)"\\hspace*")) {
                                                            argument = this.matchFromPositionAsString(LatexAnnotatedTextBuilder.ARGUMENT_REGEX, this.getPos() + command.length());
                                                            command = (String)command + argument;
                                                        }
                                                        if (org.bsplines.ltexls.parsing.latex.LatexAnnotatedTextBuilder$Companion.access$isMathMode(LatexAnnotatedTextBuilder.Companion, this.curMode) && ((CharSequence)this.lastSpace).length() == 0 && this.canInsertSpaceBeforeDummy) {
                                                            this.addMarkup((String)command, " ");
                                                        } else {
                                                            this.preserveDummyLast = true;
                                                            if (org.bsplines.ltexls.parsing.latex.LatexAnnotatedTextBuilder$Companion.access$isMathMode(LatexAnnotatedTextBuilder.Companion, this.curMode)) {
                                                                this.addMarkup((String)command);
                                                                this.dummyLastSpace = " ";
                                                            } else {
                                                                space = " ";
                                                                if (((CharSequence)this.lastSpace).length() > 0) {
                                                                    space = "";
                                                                } else if (Intrinsics.areEqual((Object)command, (Object)"\\,")) {
                                                                    space = "\u202f";
                                                                }
                                                                this.addMarkup((String)command, space);
                                                            }
                                                        }
                                                        break block122;
                                                    }
                                                    if (!Intrinsics.areEqual((Object)command, (Object)"\\dots") && !Intrinsics.areEqual((Object)command, (Object)"\\eg") && !Intrinsics.areEqual((Object)command, (Object)"\\egc") && !Intrinsics.areEqual((Object)command, (Object)"\\euro") && !Intrinsics.areEqual((Object)command, (Object)"\\ie") && !Intrinsics.areEqual((Object)command, (Object)"\\iec")) break block140;
                                                    if (org.bsplines.ltexls.parsing.latex.LatexAnnotatedTextBuilder$Companion.access$isMathMode(LatexAnnotatedTextBuilder.Companion, this.curMode)) break block141;
                                                    accentCommand = command;
                                                    tmp = -1;
                                                    switch (accentCommand.hashCode()) {
                                                        case 2844907: {
                                                            if (accentCommand.equals("\\iec")) {
                                                                tmp = 1;
                                                            }
                                                            break;
                                                        }
                                                        case 88053414: {
                                                            if (accentCommand.equals("\\dots")) {
                                                                tmp = 2;
                                                            }
                                                            break;
                                                        }
                                                        case 88088905: {
                                                            if (accentCommand.equals("\\euro")) {
                                                                tmp = 3;
                                                            }
                                                            break;
                                                        }
                                                        case 91768: {
                                                            if (accentCommand.equals("\\ie")) {
                                                                tmp = 4;
                                                            }
                                                            break;
                                                        }
                                                        case 2841125: {
                                                            if (accentCommand.equals("\\egc")) {
                                                                tmp = 5;
                                                            }
                                                            break;
                                                        }
                                                        case 91646: {
                                                            if (accentCommand.equals("\\eg")) {
                                                                tmp = 6;
                                                            }
                                                            break;
                                                        }
                                                    }
                                                    switch (tmp) {
                                                        case 2: {
                                                            v10 = "\u2026";
                                                            break;
                                                        }
                                                        case 6: {
                                                            v10 = "e.g.";
                                                            break;
                                                        }
                                                        case 5: {
                                                            v10 = "e.g.,";
                                                            break;
                                                        }
                                                        case 3: {
                                                            v10 = "\u20ac";
                                                            break;
                                                        }
                                                        case 4: {
                                                            v10 = "i.e.";
                                                            break;
                                                        }
                                                        case 1: {
                                                            v10 = "i.e.,";
                                                            break;
                                                        }
                                                        default: {
                                                            v10 = "";
                                                            break;
                                                        }
                                                    }
                                                    break block143;
                                                }
                                                v10 = "";
                                            }
                                            interpretAs = v10;
                                            this.addMarkup((String)command, interpretAs);
                                            break block122;
                                        }
                                        if (!Intrinsics.areEqual((Object)command, (Object)"\\notag") && !Intrinsics.areEqual((Object)command, (Object)"\\qed")) break block144;
                                        this.preserveDummyLast = true;
                                        this.addMarkup((String)command);
                                        break block122;
                                    }
                                    if (!Intrinsics.areEqual((Object)command, (Object)"\\part") && !Intrinsics.areEqual((Object)command, (Object)"\\chapter") && !Intrinsics.areEqual((Object)command, (Object)"\\section") && !Intrinsics.areEqual((Object)command, (Object)"\\subsection") && !Intrinsics.areEqual((Object)command, (Object)"\\subsubsection") && !Intrinsics.areEqual((Object)command, (Object)"\\paragraph") && !Intrinsics.areEqual((Object)command, (Object)"\\subparagraph") && !Intrinsics.areEqual((Object)command, (Object)"\\part*") && !Intrinsics.areEqual((Object)command, (Object)"\\chapter*") && !Intrinsics.areEqual((Object)command, (Object)"\\section*") && !Intrinsics.areEqual((Object)command, (Object)"\\subsection*") && !Intrinsics.areEqual((Object)command, (Object)"\\subsubsection*") && !Intrinsics.areEqual((Object)command, (Object)"\\paragraph*") && !Intrinsics.areEqual((Object)command, (Object)"\\subparagraph*")) break block145;
                                    this.addMarkup((String)command);
                                    headingArgument = LatexCommandSignature.Companion.matchArgumentFromPosition(this.getCode(), this.getPos(), LatexCommandSignature.ArgumentType.Bracket);
                                    if (((CharSequence)headingArgument).length() > 0) {
                                        this.addMarkup(headingArgument);
                                    }
                                    this.modeStack.addLast((Object)Mode.Heading);
                                    this.addMarkup("{");
                                    break block122;
                                }
                                if (!Intrinsics.areEqual((Object)command, (Object)"\\text") && !Intrinsics.areEqual((Object)command, (Object)"\\intertext")) break block146;
                                this.modeStack.addLast((Object)Mode.InlineText);
                                interpretAs = org.bsplines.ltexls.parsing.latex.LatexAnnotatedTextBuilder$Companion.access$isMathMode(LatexAnnotatedTextBuilder.Companion, this.curMode) != false ? this.generateDummy() : "";
                                this.addMarkup((String)command + "{", interpretAs);
                                break block122;
                            }
                            if (!Intrinsics.areEqual((Object)command, (Object)"\\verb")) break block147;
                            verbCommand = LatexAnnotatedTextBuilder.matchFromPositionAsString$default(this, LatexAnnotatedTextBuilder.VERB_COMMAND_REGEX, 0, 2, null);
                            this.addMarkup(verbCommand, this.generateDummy());
                            break block122;
                        }
                        v11 = this.commandSignatureMap.get(command);
                        if (v11 == null) {
                            v11 = CollectionsKt.emptyList();
                        }
                        possibleCommandSignatures = v11;
                        match = "";
                        matchingCommandSignature = null;
                        for (LatexCommandSignature commandSignature : possibleCommandSignatures) {
                            curMatch = commandSignature.matchFromPosition(this.getCode(), this.getPos());
                            if (!(((CharSequence)curMatch).length() > 0) || curMatch.length() < match.length()) continue;
                            match = curMatch;
                            matchingCommandSignature = commandSignature;
                        }
                        if (matchingCommandSignature == null || matchingCommandSignature.getAction() == LatexCommandSignature.Action.Default) break block148;
                        switch (WhenMappings.$EnumSwitchMapping$0[matchingCommandSignature.getAction().ordinal()]) {
                            case 1: {
                                this.addMarkup(match);
                                break;
                            }
                            case 2: {
                                this.addMarkup(match, this.generateDummy(matchingCommandSignature.getDummyGenerator()));
                                break;
                            }
                            default: {
                                this.addMarkup(match);
                                break;
                            }
                        }
                        break block122;
                    }
                    if (!org.bsplines.ltexls.parsing.latex.LatexAnnotatedTextBuilder$Companion.access$isMathMode(LatexAnnotatedTextBuilder.Companion, this.curMode) || this.mathVowelState != MathVowelState.Undecided) break block149;
                    var5_19 = command;
                    switch (var5_19.hashCode()) {
                        case -1529925876: {
                            if (!var5_19.equals("\\widehat")) {
                                ** break;
                            }
                            ** GOTO lbl456
                        }
                        case -1035289201: {
                            if (!var5_19.equals("\\mathit")) {
                                ** break;
                            }
                            ** GOTO lbl456
                        }
                        case -1568175486: {
                            if (var5_19.equals("\\alpha")) break;
                            ** break;
                        }
                        case 817397695: {
                            if (var5_19.equals("\\varepsilon")) break;
                            ** break;
                        }
                        case 1747732260: {
                            if (!var5_19.equals("\\overline")) {
                                ** break;
                            }
                            ** GOTO lbl456
                        }
                        case -1555227003: {
                            if (var5_19.equals("\\omega")) break;
                            ** break;
                        }
                        case 1519402330: {
                            if (!var5_19.equals("\\mathfrak")) {
                                ** break;
                            }
                            ** GOTO lbl456
                        }
                        case -1035289019: {
                            if (!var5_19.equals("\\mathop")) {
                                ** break;
                            }
                            ** GOTO lbl456
                        }
                        case -1663854333: {
                            if (!var5_19.equals("\\overbrace")) {
                                ** break;
                            }
                            ** GOTO lbl456
                        }
                        case 2857400: {
                            if (!var5_19.equals("\\vec")) {
                                ** break;
                            }
                            ** GOTO lbl456
                        }
                        case 2843839: {
                            if (!var5_19.equals("\\hat")) {
                                ** break;
                            }
                            ** GOTO lbl456
                        }
                        case 2841526: {
                            if (var5_19.equals("\\eta")) break;
                            ** break;
                        }
                        case -1926337040: {
                            if (!var5_19.equals("\\underline")) {
                                ** break;
                            }
                            ** GOTO lbl456
                        }
                        case 784144029: {
                            if (!var5_19.equals("\\overrightarrow")) {
                                ** break;
                            }
                            ** GOTO lbl456
                        }
                        case 404114359: {
                            if (!var5_19.equals("\\underbrace")) {
                                ** break;
                            }
                            ** GOTO lbl456
                        }
                        case -1035289432: {
                            if (!var5_19.equals("\\mathbf")) {
                                ** break;
                            }
                            ** GOTO lbl456
                        }
                        case 2841289: {
                            if (var5_19.equals("\\ell")) break;
                            ** break;
                        }
                        case -1368635511: {
                            if (!var5_19.equals("\\widetilde")) {
                                ** break;
                            }
                            ** GOTO lbl456
                        }
                        case 91559: {
                            if (!var5_19.equals("\\bm")) {
                                ** break;
                            }
                            ** GOTO lbl456
                        }
                        case -2029200406: {
                            if (!var5_19.equals("\\mathcal")) {
                                ** break;
                            }
                            ** GOTO lbl456
                        }
                        case -110742642: {
                            if (var5_19.equals("\\epsilon")) break;
                            ** break;
                        }
                        case -1322842229: {
                            if (!var5_19.equals("\\operatorname")) {
                                ** break;
                            }
                            ** GOTO lbl456
                        }
                        case -1550721924: {
                            if (!var5_19.equals("\\tilde")) {
                                ** break;
                            }
                            ** GOTO lbl456
                        }
                        case -1035289436: {
                            if (!var5_19.equals("\\mathbb")) {
                                ** break;
                            }
                            ** GOTO lbl456
                        }
                        case -1035288860: {
                            if (!var5_19.equals("\\mathtt")) {
                                ** break;
                            }
                            ** GOTO lbl456
                        }
                        case 88202351: {
                            if (var5_19.equals("\\iota")) break;
                            ** break;
                        }
                        case -1584779675: {
                            if (var5_19.equals("\\Omega")) break;
                            ** break;
                        }
                        case 83532619: {
                            if (!var5_19.equals("\\mathnormal")) {
                                ** break;
                            }
                            ** GOTO lbl456
                        }
                        case 289744690: {
                            if (!var5_19.equals("\\overleftarrow")) {
                                ** break;
                            }
                            ** GOTO lbl456
                        }
                        case -1744751175: {
                            if (!var5_19.equals("\\boldsymbol")) {
                                ** break;
                            }
                            ** GOTO lbl456
                        }
                        case -1035288905: {
                            if (!var5_19.equals("\\mathsf")) {
                                ** break;
                            }
                            ** GOTO lbl456
                        }
                        case -300187164: {
                            if (!var5_19.equals("\\overleftrightarrow")) ** break;
lbl456:
                            // 24 sources

                            v12 = this.mathVowelState;
                            break block150;
                        }
                    }
                    v12 = MathVowelState.StartsWithVowel;
                    break block150;
lbl460:
                    // 33 sources

                    v12 = MathVowelState.StartsWithConsonant;
                }
                this.mathVowelState = v12;
            }
            this.addMarkup((String)command);
        }
    }

    private final void processOpeningBrace() {
        String length = LatexAnnotatedTextBuilder.matchFromPositionAsString$default(this, LENGTH_IN_BRACE_REGEX, 0, 2, null);
        MatchResult matchResult = null;
        if (((CharSequence)length).length() > 0) {
            this.addMarkup(length);
        } else {
            MatchResult matchResult2;
            String string = this.getCode().substring(this.getPos());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            MatchResult matchResult3 = Regex.find$default((Regex)ACCENT_IN_BRACE_REGEX, (CharSequence)string, (int)0, (int)2, null);
            if (matchResult3 != null) {
                MatchResult matchResult4;
                MatchResult it = matchResult4 = matchResult3;
                boolean bl = false;
                matchResult = it;
                matchResult2 = matchResult4;
            } else {
                matchResult2 = null;
            }
            if (matchResult2 != null) {
                String accentCommand;
                MatchResult matchResult5 = matchResult;
                String string2 = accentCommand = matchResult5 != null && (matchResult5 = matchResult5.getGroups()) != null && (matchResult5 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult5, (String)"accentCommand")) != null ? matchResult5.getValue() : null;
                Object object = matchResult;
                if (object == null || (object = object.getGroups()) == null || (object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)object, (String)"letter1")) == null || (object = object.getValue()) == null) {
                    MatchResult matchResult6 = matchResult;
                    object = matchResult6 != null && (matchResult6 = matchResult6.getGroups()) != null && (matchResult6 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult6, (String)"letter2")) != null ? matchResult6.getValue() : null;
                }
                MatchResult letter = object;
                String interpretAs = accentCommand != null && letter != null ? this.convertAccentCommandToUnicode(accentCommand, (String)letter) : "";
                MatchResult matchResult7 = matchResult;
                this.addMarkup(matchResult7 != null ? matchResult7.getValue() : null, interpretAs);
            } else {
                this.modeStack.addLast((Object)this.curMode);
                this.addMarkup(this.getCurString());
            }
        }
    }

    private final void processClosingBrace() {
        String interpretAs = this.curMode == Mode.Heading && ((CharSequence)this.lastPunctuation).length() == 0 ? "." : (LatexAnnotatedTextBuilder.Companion.isTextMode(this.curMode) && this.getPos() + 1 < this.getCode().length() && this.getCode().charAt(this.getPos() + 1) == '{' ? " " : "");
        this.popMode();
        this.addMarkup(this.getCurString(), interpretAs);
        this.canInsertSpaceBeforeDummy = true;
        if (LatexAnnotatedTextBuilder.Companion.isTextMode(this.curMode) && LatexAnnotatedTextBuilder.Companion.isMathMode((Mode)((Object)this.modeStack.lastOrNull()))) {
            this.isMathEmpty = true;
        }
        this.isMathCharTrivial = true;
    }

    private final void processDollar() {
        String displayMath = LatexAnnotatedTextBuilder.matchFromPositionAsString$default(this, DISPLAY_MATH_REGEX, 0, 2, null);
        if (((CharSequence)displayMath).length() > 0) {
            if (this.curMode == Mode.DisplayMath) {
                this.popMode();
                this.addMarkup(displayMath, this.generateDummy());
            } else {
                this.enterDisplayMath();
                this.addMarkup(displayMath);
            }
        } else if (this.curMode == Mode.InlineMath) {
            this.popMode();
            this.addMarkup(this.getCurString(), this.generateDummy());
        } else {
            this.enterInlineMath();
            this.addMarkup(this.getCurString());
        }
    }

    private final void processPercentage() {
        String comment = LatexAnnotatedTextBuilder.matchFromPositionAsString$default(this, COMMENT_REGEX, 0, 2, null);
        this.preserveDummyLast = true;
        this.isMathCharTrivial = true;
        this.addMarkup(comment, LatexAnnotatedTextBuilder.Companion.containsTwoEndsOfLine(comment) ? "\n\n" : "");
    }

    private final void processWhitespace() {
        String whitespace = this.getCurChar() != '~' && this.getCurChar() != '&' ? LatexAnnotatedTextBuilder.matchFromPositionAsString$default(this, WHITESPACE_REGEX, 0, 2, null) : this.getCurString();
        this.preserveDummyLast = true;
        this.isMathCharTrivial = true;
        if (LatexAnnotatedTextBuilder.Companion.isTextMode(this.curMode)) {
            if (LatexAnnotatedTextBuilder.Companion.containsTwoEndsOfLine(whitespace)) {
                this.addMarkup(whitespace, "\n\n");
            } else if (this.getCurChar() == '~') {
                this.addMarkup(whitespace, ((CharSequence)this.lastSpace).length() == 0 ? "\u00a0" : "");
            } else {
                this.addMarkup(whitespace, ((CharSequence)this.lastSpace).length() == 0 ? " " : "");
            }
        } else {
            this.addMarkup(whitespace);
        }
        if (this.getCurChar() == '~' || this.getCurChar() == '&') {
            this.dummyLastSpace = " ";
        }
    }

    private final void processQuotationMark() {
        block32: {
            block29: {
                String smartQuote;
                String quote;
                block30: {
                    if (!LatexAnnotatedTextBuilder.Companion.isTextMode(this.curMode)) break block29;
                    quote = "";
                    smartQuote = "";
                    if (this.getPos() + 1 >= this.getCode().length()) break block30;
                    String string = this.getCode().substring(this.getPos(), this.getPos() + 2);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    switch (quote = string) {
                        case "``": 
                        case "\"'": {
                            smartQuote = "\u201c";
                            break;
                        }
                        case "''": {
                            smartQuote = "\u201d";
                            break;
                        }
                        case "\"`": {
                            smartQuote = "\u201e";
                            break;
                        }
                        case "\"\"": 
                        case "\"|": 
                        case "\"-": {
                            smartQuote = "";
                            break;
                        }
                        case "\"=": 
                        case "\"~": {
                            smartQuote = "-";
                            break;
                        }
                        default: {
                            quote = "";
                        }
                    }
                }
                if (((CharSequence)quote).length() == 0) {
                    this.addText(this.getCurString());
                } else {
                    this.addMarkup(quote, smartQuote);
                }
                break block32;
            }
            this.addMarkup(this.getCurString());
        }
    }

    private final void processDefaultCharacter() {
        String rsweaveBegin;
        char c = this.getCurChar();
        if (c == '-') {
            String emDash = LatexAnnotatedTextBuilder.matchFromPositionAsString$default(this, EM_DASH_REGEX, 0, 2, null);
            if (LatexAnnotatedTextBuilder.Companion.isTextMode(this.curMode)) {
                if (((CharSequence)emDash).length() > 0) {
                    this.addMarkup(emDash, "\u2014");
                    return;
                }
                String enDash = LatexAnnotatedTextBuilder.matchFromPositionAsString$default(this, EN_DASH_REGEX, 0, 2, null);
                if (((CharSequence)enDash).length() > 0) {
                    this.addMarkup(enDash, "\u2013");
                    return;
                }
            }
        } else if (c == '[') {
            String length = LatexAnnotatedTextBuilder.matchFromPositionAsString$default(this, LENGTH_IN_BRACKET_REGEX, 0, 2, null);
            if (((CharSequence)length).length() > 0) {
                this.isMathCharTrivial = true;
                this.preserveDummyLast = true;
                this.addMarkup(length);
                return;
            }
        } else if (c == '<' && Intrinsics.areEqual((Object)this.getCodeLanguageId(), (Object)"rsweave") && ((CharSequence)(rsweaveBegin = LatexAnnotatedTextBuilder.matchFromPositionAsString$default(this, RSWEAVE_BEGIN_REGEX, 0, 2, null))).length() > 0) {
            this.modeStack.addLast((Object)Mode.Rsweave);
            this.addMarkup(rsweaveBegin);
            return;
        }
        if (LatexAnnotatedTextBuilder.Companion.isTextMode(this.curMode)) {
            this.addText(this.getCurString());
            if (LatexAnnotatedTextBuilder.Companion.isPunctuation(this.getCurChar())) {
                this.lastPunctuation = this.getCurString();
            }
        } else {
            this.addMarkup(this.getCurString());
            if (LatexAnnotatedTextBuilder.Companion.isPunctuation(this.getCurChar())) {
                this.dummyLastPunctuation = this.getCurString();
            }
            if (this.mathVowelState == MathVowelState.Undecided) {
                this.mathVowelState = LatexAnnotatedTextBuilder.Companion.isVowel(this.getCurChar()) ? MathVowelState.StartsWithVowel : MathVowelState.StartsWithConsonant;
            }
        }
    }

    private final String matchFromPositionAsString(Regex regex, int pos) {
        Object object = this.matchFromPosition(regex, pos);
        if (object == null || (object = object.getValue()) == null) {
            object = "";
        }
        return object;
    }

    static /* synthetic */ String matchFromPositionAsString$default(LatexAnnotatedTextBuilder latexAnnotatedTextBuilder, Regex regex, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = latexAnnotatedTextBuilder.getPos();
        }
        return latexAnnotatedTextBuilder.matchFromPositionAsString(regex, n);
    }

    @Override
    @NotNull
    protected String generateDummy() {
        return this.generateDummy(this.getDummyGenerator());
    }

    private final String generateDummy(DummyGenerator dummyGenerator) {
        Object object;
        int n;
        boolean startsWithVowel;
        boolean bl = startsWithVowel = this.mathVowelState == MathVowelState.StartsWithVowel;
        if (LatexAnnotatedTextBuilder.Companion.isTextMode(this.curMode)) {
            String string = this.getLanguage();
            n = this.getDummyCounter();
            this.setDummyCounter(n + 1);
            object = dummyGenerator.generate(string, n, startsWithVowel);
        } else if (this.isMathEmpty) {
            object = this.curMode == Mode.DisplayMath ? (((CharSequence)this.lastSpace).length() == 0 ? " " : "") : "";
        } else if (this.curMode == Mode.DisplayMath) {
            String string = ((CharSequence)this.lastSpace).length() == 0 ? " " : "";
            String string2 = this.getLanguage();
            n = this.getDummyCounter();
            this.setDummyCounter(n + 1);
            object = string + DummyGenerator.generate$default(dummyGenerator, string2, n, false, 4, null) + this.dummyLastPunctuation + (this.modeStack.lastOrNull() == Mode.InlineText ? this.dummyLastSpace : " ");
        } else {
            String string = this.getLanguage();
            n = this.getDummyCounter();
            this.setDummyCounter(n + 1);
            object = dummyGenerator.generate(string, n, startsWithVowel) + this.dummyLastPunctuation + this.dummyLastSpace;
        }
        String dummy = object;
        this.dummyLastSpace = "";
        this.dummyLastPunctuation = "";
        this.mathVowelState = MathVowelState.Undecided;
        return dummy;
    }

    private final void textAdded(String text) {
        if (((CharSequence)text).length() == 0) {
            return;
        }
        char lastChar = text.charAt(text.length() - 1);
        char c = lastChar;
        this.lastSpace = ((c == ' ' ? true : c == '\n') ? true : c == '\r') ? " " : "";
        this.lastPunctuation = LatexAnnotatedTextBuilder.Companion.isPunctuation(lastChar) ? " " : "";
    }

    private final void popMode() {
        this.modeStack.removeLastOrNull();
        if (this.modeStack.isEmpty()) {
            this.modeStack.addLast((Object)Mode.ParagraphText);
        }
    }

    private final void enterDisplayMath() {
        this.modeStack.addLast((Object)Mode.DisplayMath);
        this.isMathEmpty = true;
        this.mathVowelState = MathVowelState.Undecided;
        this.canInsertSpaceBeforeDummy = true;
    }

    private final void enterInlineMath() {
        this.modeStack.addLast((Object)Mode.InlineMath);
        this.isMathEmpty = true;
        this.mathVowelState = MathVowelState.Undecided;
        this.canInsertSpaceBeforeDummy = true;
        this.isMathCharTrivial = true;
    }

    private final String convertAccentCommandToUnicode(String accentCommand, String letter) {
        String string = letter;
        Object unicode = Intrinsics.areEqual((Object)string, (Object)"\\i") ? "\u0131" : (Intrinsics.areEqual((Object)string, (Object)"\\j") ? "\u0237" : letter);
        char c = accentCommand.charAt(1);
        unicode = (String)unicode + (c == '`' ? "\u0300" : (c == '\'' ? "\u0301" : (c == '^' ? "\u0302" : (c == '~' ? "\u0303" : (c == '\"' ? "\u0308" : (c == '=' ? "\u0304" : (c == '.' ? "\u0307" : (c == 'H' ? "\u030b" : (c == 'b' ? "\u0331" : (c == 'c' ? "\u0327" : (c == 'd' ? "\u0323" : (c == 'k' ? "\u0328" : (c == 'r' ? "\u030a" : (c == 'u' ? "\u0306" : (c == 'v' ? "\u030c" : "")))))))))))))));
        String string2 = Normalizer.normalize((CharSequence)unicode, Normalizer.Form.NFC);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"normalize(unicode, Normalizer.Form.NFC)");
        unicode = string2;
        return unicode;
    }

    private final void processEnvironmentArguments() {
        while (this.getPos() < this.getCode().length()) {
            String environmentArgument = LatexCommandSignature.Companion.matchArgumentFromPosition(this.getCode(), this.getPos(), LatexCommandSignature.ArgumentType.Brace);
            if (((CharSequence)environmentArgument).length() > 0) {
                this.addMarkup(environmentArgument);
                continue;
            }
            environmentArgument = LatexCommandSignature.Companion.matchArgumentFromPosition(this.getCode(), this.getPos(), LatexCommandSignature.ArgumentType.Bracket);
            if (((CharSequence)environmentArgument).length() > 0) {
                this.addMarkup(environmentArgument);
                continue;
            }
            environmentArgument = LatexCommandSignature.Companion.matchArgumentFromPosition(this.getCode(), this.getPos(), LatexCommandSignature.ArgumentType.Parenthesis);
            if (!(((CharSequence)environmentArgument).length() > 0)) break;
            this.addMarkup(environmentArgument);
        }
    }

    static {
        Object[] objectArray = new String[]{"align", "align*", "alignat", "alignat*", "displaymath", "eqnarray", "eqnarray*", "equation", "equation*", "flalign", "flalign*", "formula", "gather", "gather*", "math", "multline", "multline*"};
        MATH_ENVIRONMENTS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0007H\u0002J2\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001f0\u00150\u001e\"\b\b\u0000\u0010\u001f*\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001f0\u0015H\u0002J\u0012\u0010\"\u001a\u00020\u001b2\b\u0010#\u001a\u0004\u0018\u00010$H\u0002J\u0012\u0010%\u001a\u00020\u001b2\b\u0010#\u001a\u0004\u0018\u00010$H\u0002J\u0010\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020(H\u0002J\u0012\u0010)\u001a\u00020\u001b2\b\u0010#\u001a\u0004\u0018\u00010$H\u0002J\u0012\u0010*\u001a\u00020\u001b2\b\u0010#\u001a\u0004\u0018\u00010$H\u0002J\u0010\u0010+\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020(H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/bsplines/ltexls/parsing/latex/LatexAnnotatedTextBuilder$Companion;", "", "()V", "ACCENT_IN_BRACE_REGEX", "Lkotlin/text/Regex;", "ACCENT_REGEX", "ACCENT_REGEX_STRING", "", "ARGUMENT_REGEX", "COMMAND_REGEX", "COMMENT_REGEX", "DISPLAY_MATH_REGEX", "EM_DASH_REGEX", "EN_DASH_REGEX", "LENGTH_IN_BRACE_REGEX", "LENGTH_IN_BRACKET_REGEX", "LENGTH_OF_START_PREFIX", "", "LENGTH_OF_STOP_PREFIX", "LENGTH_REGEX_STRING", "MATH_ENVIRONMENTS", "", "RSWEAVE_BEGIN_REGEX", "RSWEAVE_END_REGEX", "VERB_COMMAND_REGEX", "WHITESPACE_REGEX", "containsTwoEndsOfLine", "", "text", "createCommandSignatureMap", "", "T", "Lorg/bsplines/ltexls/parsing/latex/LatexCommandSignature;", "commandSignatures", "isIgnoreEnvironmentMode", "mode", "Lorg/bsplines/ltexls/parsing/latex/LatexAnnotatedTextBuilder$Mode;", "isMathMode", "isPunctuation", "ch", "", "isRsweaveMode", "isTextMode", "isVowel", "ltexls"})
    public static final class Companion {
        private Companion() {
        }

        private final <T extends LatexCommandSignature> Map<String, List<T>> createCommandSignatureMap(List<? extends T> commandSignatures) {
            HashMap map = new HashMap();
            for (LatexCommandSignature commandSignature : commandSignatures) {
                List list;
                String commandPrefix = commandSignature.getPrefix();
                ArrayList arrayList = (ArrayList)map.get(commandPrefix);
                if (arrayList == null) {
                    Companion $this$createCommandSignatureMap_u24lambda_u240 = this;
                    boolean bl = false;
                    ArrayList list2 = new ArrayList();
                    ((Map)map).put(commandPrefix, list2);
                    list = list2;
                } else {
                    list = arrayList;
                }
                List list3 = list;
                list3.add(commandSignature);
            }
            return map;
        }

        private final boolean isPunctuation(char ch) {
            char c = ch;
            return (((c == '.' ? true : c == ',') ? true : c == ':') ? true : c == ';') ? true : c == '\u2026';
        }

        private final boolean isVowel(char ch) {
            char c = Character.toLowerCase(ch);
            return ((((((((((c == 'a' ? true : c == 'e') ? true : c == 'f') ? true : c == 'h') ? true : c == 'i') ? true : c == 'l') ? true : c == 'm') ? true : c == 'n') ? true : c == 'o') ? true : c == 'r') ? true : c == 's') ? true : c == 'x';
        }

        private final boolean isMathMode(Mode mode) {
            return mode == Mode.InlineMath || mode == Mode.DisplayMath;
        }

        private final boolean isIgnoreEnvironmentMode(Mode mode) {
            return mode == Mode.IgnoreEnvironment;
        }

        private final boolean isRsweaveMode(Mode mode) {
            return mode == Mode.Rsweave;
        }

        private final boolean isTextMode(Mode mode) {
            return !this.isMathMode(mode) && !this.isIgnoreEnvironmentMode(mode);
        }

        private final boolean containsTwoEndsOfLine(String text) {
            return StringsKt.contains$default((CharSequence)text, (CharSequence)"\n\n", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)text, (CharSequence)"\r\n\r\n", (boolean)false, (int)2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/bsplines/ltexls/parsing/latex/LatexAnnotatedTextBuilder$MathVowelState;", "", "(Ljava/lang/String;I)V", "Undecided", "StartsWithVowel", "StartsWithConsonant", "ltexls"})
    private static final class MathVowelState
    extends Enum<MathVowelState> {
        public static final /* enum */ MathVowelState Undecided = new MathVowelState();
        public static final /* enum */ MathVowelState StartsWithVowel = new MathVowelState();
        public static final /* enum */ MathVowelState StartsWithConsonant = new MathVowelState();
        private static final /* synthetic */ MathVowelState[] $VALUES;

        public static MathVowelState[] values() {
            return (MathVowelState[])$VALUES.clone();
        }

        public static MathVowelState valueOf(String value) {
            return Enum.valueOf(MathVowelState.class, value);
        }

        static {
            $VALUES = mathVowelStateArray = new MathVowelState[]{MathVowelState.Undecided, MathVowelState.StartsWithVowel, MathVowelState.StartsWithConsonant};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/bsplines/ltexls/parsing/latex/LatexAnnotatedTextBuilder$Mode;", "", "(Ljava/lang/String;I)V", "ParagraphText", "InlineText", "Heading", "InlineMath", "DisplayMath", "IgnoreEnvironment", "Rsweave", "ltexls"})
    private static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode ParagraphText = new Mode();
        public static final /* enum */ Mode InlineText = new Mode();
        public static final /* enum */ Mode Heading = new Mode();
        public static final /* enum */ Mode InlineMath = new Mode();
        public static final /* enum */ Mode DisplayMath = new Mode();
        public static final /* enum */ Mode IgnoreEnvironment = new Mode();
        public static final /* enum */ Mode Rsweave = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.ParagraphText, Mode.InlineText, Mode.Heading, Mode.InlineMath, Mode.DisplayMath, Mode.IgnoreEnvironment, Mode.Rsweave};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LatexCommandSignature.Action.values().length];
            try {
                nArray[LatexCommandSignature.Action.Ignore.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LatexCommandSignature.Action.Dummy.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

