/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.ltexls.parsing.bibtex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bsplines.ltexls.parsing.CodeFragment;
import org.bsplines.ltexls.parsing.CodeFragmentizer;
import org.bsplines.ltexls.parsing.DummyGenerator;
import org.bsplines.ltexls.parsing.bibtex.BibtexFragmentizerDefaults;
import org.bsplines.ltexls.parsing.latex.LatexCommandSignature;
import org.bsplines.ltexls.parsing.latex.LatexCommandSignatureMatch;
import org.bsplines.ltexls.parsing.latex.LatexCommandSignatureMatcher;
import org.bsplines.ltexls.parsing.latex.LatexFragmentizer;
import org.bsplines.ltexls.parsing.latex.LatexPackageOption;
import org.bsplines.ltexls.parsing.latex.LatexPackageOptionsParser;
import org.bsplines.ltexls.settings.Settings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002JP\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u00122\u0006\u0010\u0013\u001a\u00020\f2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/bsplines/ltexls/parsing/bibtex/BibtexFragmentizer;", "Lorg/bsplines/ltexls/parsing/CodeFragmentizer;", "codeLanguageId", "", "(Ljava/lang/String;)V", "latexFragmentizer", "Lorg/bsplines/ltexls/parsing/latex/LatexFragmentizer;", "fragmentize", "", "Lorg/bsplines/ltexls/parsing/CodeFragment;", "code", "originalSettings", "Lorg/bsplines/ltexls/settings/Settings;", "fragmentizeBibtexFields", "fragments", "processKeyValuePairs", "", "newFragments", "", "newFragmentSettings", "bibtexFields", "", "", "fromPos", "", "argumentContentsFromPos", "keyValuePairs", "Lorg/bsplines/ltexls/parsing/latex/LatexPackageOption;", "Companion", "ltexls"})
public final class BibtexFragmentizer
extends CodeFragmentizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LatexFragmentizer latexFragmentizer;
    @NotNull
    private static final LatexCommandSignature BIBTEX_ENTRY_COMMAND_SIGNATURE = new LatexCommandSignature("@[A-Za-z]+{}", LatexCommandSignature.Action.Ignore, DummyGenerator.Companion.getInstance$default(DummyGenerator.Companion, false, false, 3, null), false);
    @NotNull
    private static final LatexCommandSignatureMatcher BIBTEX_ENTRY_COMMAND_SIGNATURE_MATCHER = new LatexCommandSignatureMatcher(CollectionsKt.listOf((Object)BIBTEX_ENTRY_COMMAND_SIGNATURE), false);

    public BibtexFragmentizer(@NotNull String codeLanguageId) {
        Intrinsics.checkNotNullParameter((Object)codeLanguageId, (String)"codeLanguageId");
        super(codeLanguageId);
        this.latexFragmentizer = new LatexFragmentizer(codeLanguageId);
    }

    @Override
    @NotNull
    public List<CodeFragment> fragmentize(@NotNull String code, @NotNull Settings originalSettings) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)originalSettings, (String)"originalSettings");
        List<CodeFragment> fragments = CollectionsKt.listOf((Object)new CodeFragment(this.getCodeLanguageId(), code, 0, originalSettings, null, 16, null));
        fragments = this.latexFragmentizer.fragmentize(fragments);
        fragments = this.fragmentizeBibtexFields(fragments);
        return fragments;
    }

    private final List<CodeFragment> fragmentizeBibtexFields(List<CodeFragment> fragments) {
        ArrayList newFragments = new ArrayList();
        for (CodeFragment codeFragment : fragments) {
            String oldFragmentCode = codeFragment.component2();
            int fromPos = codeFragment.component3();
            Settings oldFragmentSettings = codeFragment.component4();
            HashSet<String> newFragmentDisabledRules = new HashSet<String>((Collection)oldFragmentSettings.getDisabledRules());
            newFragmentDisabledRules.add("UPPERCASE_SENTENCE_START");
            Settings newFragmentSettings = Settings.copy$default(oldFragmentSettings, null, null, null, oldFragmentSettings.getModifiedDisabledRules((Set<String>)newFragmentDisabledRules), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0x3FFFF7, null);
            BIBTEX_ENTRY_COMMAND_SIGNATURE_MATCHER.startMatching(oldFragmentCode, SetsKt.emptySet());
            Map bibtexFields = null;
            while (BIBTEX_ENTRY_COMMAND_SIGNATURE_MATCHER.findNextMatch() != null) {
                LatexCommandSignatureMatch match;
                if (bibtexFields == null) {
                    bibtexFields = new HashMap<String, Boolean>(BibtexFragmentizerDefaults.INSTANCE.getDEFAULT_BIBTEX_FIELDS());
                    ((HashMap)bibtexFields).putAll(oldFragmentSettings.getBibtexFields());
                }
                String argumentContents = match.getArgumentContents(match.getArgumentsSize() - 1);
                int argumentContentsFromPos = match.getArgumentContentsFromPos(match.getArgumentsSize() - 1);
                List<LatexPackageOption> keyValuePairs = LatexPackageOptionsParser.INSTANCE.parse(argumentContents);
                this.processKeyValuePairs(newFragments, newFragmentSettings, bibtexFields, fromPos, argumentContentsFromPos, keyValuePairs);
            }
        }
        return newFragments;
    }

    private final void processKeyValuePairs(List<CodeFragment> newFragments, Settings newFragmentSettings, Map<String, Boolean> bibtexFields, int fromPos, int argumentContentsFromPos, List<LatexPackageOption> keyValuePairs) {
        for (LatexPackageOption keyValuePair : keyValuePairs) {
            String fieldName = keyValuePair.getKeyInfo().getPlainText();
            Boolean inBibtexFields = bibtexFields.get(fieldName);
            if (keyValuePair.getValueInfo().getFromPos() == -1 || inBibtexFields != null && !inBibtexFields.booleanValue()) continue;
            newFragments.add(new CodeFragment("latex", keyValuePair.getValue(), fromPos + argumentContentsFromPos + keyValuePair.getValueInfo().getFromPos(), newFragmentSettings, null, 16, null));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/bsplines/ltexls/parsing/bibtex/BibtexFragmentizer$Companion;", "", "()V", "BIBTEX_ENTRY_COMMAND_SIGNATURE", "Lorg/bsplines/ltexls/parsing/latex/LatexCommandSignature;", "BIBTEX_ENTRY_COMMAND_SIGNATURE_MATCHER", "Lorg/bsplines/ltexls/parsing/latex/LatexCommandSignatureMatcher;", "ltexls"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

