/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.ltexls.parsing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.bsplines.ltexls.parsing.CodeFragment;
import org.bsplines.ltexls.parsing.CodeFragmentizer;
import org.bsplines.ltexls.settings.Settings;
import org.bsplines.ltexls.tools.I18n;
import org.bsplines.ltexls.tools.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/bsplines/ltexls/parsing/RegexCodeFragmentizer;", "Lorg/bsplines/ltexls/parsing/CodeFragmentizer;", "codeLanguageId", "", "regex", "Lkotlin/text/Regex;", "(Ljava/lang/String;Lkotlin/text/Regex;)V", "getRegex", "()Lkotlin/text/Regex;", "fragmentize", "", "Lorg/bsplines/ltexls/parsing/CodeFragment;", "code", "originalSettings", "Lorg/bsplines/ltexls/settings/Settings;", "Companion", "ltexls"})
public class RegexCodeFragmentizer
extends CodeFragmentizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Regex regex;
    @NotNull
    private static final Regex SPLIT_SETTINGS_REGEX = new Regex("[ \t]+");

    public RegexCodeFragmentizer(@NotNull String codeLanguageId, @NotNull Regex regex) {
        Intrinsics.checkNotNullParameter((Object)codeLanguageId, (String)"codeLanguageId");
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        super(codeLanguageId);
        this.regex = regex;
    }

    @NotNull
    public final Regex getRegex() {
        return this.regex;
    }

    @Override
    @NotNull
    public List<CodeFragment> fragmentize(@NotNull String code, @NotNull Settings originalSettings) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)originalSettings, (String)"originalSettings");
        ArrayList<CodeFragment> codeFragments = new ArrayList<CodeFragment>();
        Settings curSettings = originalSettings;
        int curPos = 0;
        for (MatchResult matchResult : Regex.findAll$default((Regex)this.regex, (CharSequence)code, (int)0, (int)2, null)) {
            String lastCode;
            int lastPos = curPos;
            curPos = matchResult.getRange().getFirst();
            Intrinsics.checkNotNullExpressionValue((Object)code.substring(lastPos, curPos), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            Settings lastSettings = curSettings;
            codeFragments.add(new CodeFragment(this.getCodeLanguageId(), lastCode, lastPos, lastSettings, null, 16, null));
            String settingsLine = null;
            int n = matchResult.getGroups().size();
            for (int groupIndex = 1; groupIndex < n; ++groupIndex) {
                if (matchResult.getGroups().get(groupIndex) == null) continue;
                settingsLine = (String)matchResult.getGroupValues().get(groupIndex);
                break;
            }
            if (settingsLine == null) {
                Logging.INSTANCE.getLOGGER().warning(I18n.INSTANCE.format("couldNotFindSettingsInMatch", new Object[0]));
                continue;
            }
            Map settingsMap = RegexCodeFragmentizer.Companion.parseSettings(settingsLine);
            for (Map.Entry entry : settingsMap.entrySet()) {
                String settingKey = (String)entry.getKey();
                String settingValue = (String)entry.getValue();
                if (StringsKt.equals((String)settingKey, (String)"enabled", (boolean)true)) {
                    curSettings = Settings.copy$default(curSettings, Intrinsics.areEqual((Object)settingValue, (Object)"true") ? Settings.Companion.getDEFAULT_ENABLED() : SetsKt.emptySet(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0x3FFFFE, null);
                    continue;
                }
                if (StringsKt.equals((String)settingKey, (String)"language", (boolean)true)) {
                    curSettings = Settings.copy$default(curSettings, null, settingValue, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0x3FFFFD, null);
                    continue;
                }
                Object[] objectArray = new Object[]{settingKey, settingValue};
                Logging.INSTANCE.getLOGGER().warning(I18n.INSTANCE.format("ignoringUnknownInlineSetting", objectArray));
            }
            lastPos = curPos;
            curPos = matchResult.getRange().getLast() + 1;
            String string = code.substring(lastPos, curPos);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            lastCode = string;
            lastSettings = curSettings;
            codeFragments.add(new CodeFragment("nop", lastCode, lastPos, lastSettings, null, 16, null));
        }
        String string = this.getCodeLanguageId();
        String string2 = code.substring(curPos);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        codeFragments.add(new CodeFragment(string, string2, curPos, curSettings, null, 16, null));
        return codeFragments;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/bsplines/ltexls/parsing/RegexCodeFragmentizer$Companion;", "", "()V", "SPLIT_SETTINGS_REGEX", "Lkotlin/text/Regex;", "parseSettings", "", "", "settingsLine", "ltexls"})
    public static final class Companion {
        private Companion() {
        }

        private final Map<String, String> parseSettings(String settingsLine) {
            HashMap settingsMap = new HashMap();
            CharSequence charSequence = ((Object)StringsKt.trim((CharSequence)settingsLine)).toString();
            Regex regex = SPLIT_SETTINGS_REGEX;
            int n = 0;
            for (String settingsChange : regex.split(charSequence, n)) {
                int settingKeyLength = StringsKt.indexOf$default((CharSequence)settingsChange, (char)'=', (int)0, (boolean)false, (int)6, null);
                if (settingKeyLength == -1) {
                    Object[] objectArray = new Object[]{settingsChange};
                    Logging.INSTANCE.getLOGGER().warning(I18n.INSTANCE.format("ignoringMalformedInlineSetting", objectArray));
                    continue;
                }
                String string = settingsChange.substring(0, settingKeyLength);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String settingKey = ((Object)StringsKt.trim((CharSequence)string)).toString();
                String string2 = settingsChange.substring(settingKeyLength + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                String settingValue = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                ((Map)settingsMap).put(settingKey, settingValue);
            }
            return settingsMap;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

