/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.ltexls.parsing;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bsplines.ltexls.parsing.gitcommit.GitCommitAnnotatedTextBuilder;
import org.bsplines.ltexls.parsing.html.HtmlAnnotatedTextBuilder;
import org.bsplines.ltexls.parsing.latex.LatexAnnotatedTextBuilder;
import org.bsplines.ltexls.parsing.markdown.MarkdownAnnotatedTextBuilder;
import org.bsplines.ltexls.parsing.nop.NopAnnotatedTextBuilder;
import org.bsplines.ltexls.parsing.org.OrgAnnotatedTextBuilder;
import org.bsplines.ltexls.parsing.plaintext.PlaintextAnnotatedTextBuilder;
import org.bsplines.ltexls.parsing.program.ProgramAnnotatedTextBuilder;
import org.bsplines.ltexls.parsing.program.ProgramCommentRegexs;
import org.bsplines.ltexls.parsing.restructuredtext.RestructuredtextAnnotatedTextBuilder;
import org.bsplines.ltexls.settings.Settings;
import org.bsplines.ltexls.tools.I18n;
import org.bsplines.ltexls.tools.Logging;
import org.jetbrains.annotations.NotNull;
import org.languagetool.markup.AnnotatedTextBuilder;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0003H&J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lorg/bsplines/ltexls/parsing/CodeAnnotatedTextBuilder;", "Lorg/languagetool/markup/AnnotatedTextBuilder;", "codeLanguageId", "", "(Ljava/lang/String;)V", "getCodeLanguageId", "()Ljava/lang/String;", "addCode", "code", "setSettings", "", "settings", "Lorg/bsplines/ltexls/settings/Settings;", "Companion", "ltexls"})
public abstract class CodeAnnotatedTextBuilder
extends AnnotatedTextBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String codeLanguageId;

    public CodeAnnotatedTextBuilder(@NotNull String codeLanguageId) {
        Intrinsics.checkNotNullParameter((Object)codeLanguageId, (String)"codeLanguageId");
        this.codeLanguageId = codeLanguageId;
    }

    @NotNull
    public final String getCodeLanguageId() {
        return this.codeLanguageId;
    }

    @NotNull
    public abstract CodeAnnotatedTextBuilder addCode(@NotNull String var1);

    public void setSettings(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/bsplines/ltexls/parsing/CodeAnnotatedTextBuilder$Companion;", "", "()V", "create", "Lorg/bsplines/ltexls/parsing/CodeAnnotatedTextBuilder;", "codeLanguageId", "", "ltexls"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CodeAnnotatedTextBuilder create(@NotNull String codeLanguageId) {
            CodeAnnotatedTextBuilder codeAnnotatedTextBuilder;
            Intrinsics.checkNotNullParameter((Object)codeLanguageId, (String)"codeLanguageId");
            switch (codeLanguageId) {
                case "bib": 
                case "bibtex": {
                    codeAnnotatedTextBuilder = new LatexAnnotatedTextBuilder(codeLanguageId);
                    break;
                }
                case "git-commit": 
                case "gitcommit": {
                    codeAnnotatedTextBuilder = new GitCommitAnnotatedTextBuilder(codeLanguageId);
                    break;
                }
                case "xhtml": 
                case "html": {
                    codeAnnotatedTextBuilder = new HtmlAnnotatedTextBuilder(codeLanguageId);
                    break;
                }
                case "rsweave": 
                case "context.tex": 
                case "tex": 
                case "latex": 
                case "context": 
                case "plaintex": {
                    codeAnnotatedTextBuilder = new LatexAnnotatedTextBuilder(codeLanguageId);
                    break;
                }
                case "quarto": 
                case "rmd": 
                case "markdown": {
                    codeAnnotatedTextBuilder = new MarkdownAnnotatedTextBuilder(codeLanguageId);
                    break;
                }
                case "nop": {
                    codeAnnotatedTextBuilder = new NopAnnotatedTextBuilder(codeLanguageId);
                    break;
                }
                case "org": {
                    codeAnnotatedTextBuilder = new OrgAnnotatedTextBuilder(codeLanguageId);
                    break;
                }
                case "plaintext": {
                    codeAnnotatedTextBuilder = new PlaintextAnnotatedTextBuilder(codeLanguageId);
                    break;
                }
                case "restructuredtext": {
                    codeAnnotatedTextBuilder = new RestructuredtextAnnotatedTextBuilder(codeLanguageId);
                    break;
                }
                default: {
                    if (ProgramCommentRegexs.Companion.isSupportedCodeLanguageId(codeLanguageId)) {
                        codeAnnotatedTextBuilder = new ProgramAnnotatedTextBuilder(codeLanguageId);
                        break;
                    }
                    Object[] objectArray = new Object[]{codeLanguageId};
                    Logging.INSTANCE.getLOGGER().warning(I18n.INSTANCE.format("unsupportedCodeLanguageId", objectArray));
                    codeAnnotatedTextBuilder = new PlaintextAnnotatedTextBuilder("plaintext");
                }
            }
            return codeAnnotatedTextBuilder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

