/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.ltexls.parsing;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.bsplines.ltexls.parsing.CodeAnnotatedTextBuilder;
import org.bsplines.ltexls.parsing.DummyGenerator;
import org.bsplines.ltexls.settings.Settings;
import org.bsplines.ltexls.tools.I18n;
import org.bsplines.ltexls.tools.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\f\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010+\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0003H\u0016J\u0012\u0010,\u001a\u00020\u00002\b\u0010-\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010,\u001a\u00020\u00002\b\u0010-\u001a\u0004\u0018\u00010\u00032\b\u0010.\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010/\u001a\u00020\u00002\b\u00100\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u00101\u001a\u00020\u0003H\u0014J\u001c\u00102\u001a\u0004\u0018\u0001032\u0006\u00104\u001a\u0002052\b\b\u0002\u0010(\u001a\u00020\u0013H\u0004J\b\u00106\u001a\u000207H$J\u0010\u00108\u001a\u0002072\u0006\u00109\u001a\u00020:H\u0016R\u001a\u0010\u0005\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0004R\u001a\u0010\t\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0007\"\u0004\b\u0011\u0010\u0004R\u001a\u0010\u0012\u001a\u00020\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020\u001fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010 \"\u0004\b$\u0010\"R\u001a\u0010%\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0007\"\u0004\b'\u0010\u0004R\u001a\u0010(\u001a\u00020\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0015\"\u0004\b*\u0010\u0017\u00a8\u0006;"}, d2={"Lorg/bsplines/ltexls/parsing/CharacterBasedCodeAnnotatedTextBuilder;", "Lorg/bsplines/ltexls/parsing/CodeAnnotatedTextBuilder;", "codeLanguageId", "", "(Ljava/lang/String;)V", "code", "getCode", "()Ljava/lang/String;", "setCode", "curChar", "", "getCurChar", "()C", "setCurChar", "(C)V", "curString", "getCurString", "setCurString", "dummyCounter", "", "getDummyCounter", "()I", "setDummyCounter", "(I)V", "dummyGenerator", "Lorg/bsplines/ltexls/parsing/DummyGenerator;", "getDummyGenerator", "()Lorg/bsplines/ltexls/parsing/DummyGenerator;", "setDummyGenerator", "(Lorg/bsplines/ltexls/parsing/DummyGenerator;)V", "isPreventingInfiniteLoops", "", "()Z", "setPreventingInfiniteLoops", "(Z)V", "isStartOfLine", "setStartOfLine", "language", "getLanguage", "setLanguage", "pos", "getPos", "setPos", "addCode", "addMarkup", "markup", "interpretAs", "addText", "text", "generateDummy", "matchFromPosition", "Lkotlin/text/MatchResult;", "regex", "Lkotlin/text/Regex;", "processCharacter", "", "setSettings", "settings", "Lorg/bsplines/ltexls/settings/Settings;", "ltexls"})
public abstract class CharacterBasedCodeAnnotatedTextBuilder
extends CodeAnnotatedTextBuilder {
    @NotNull
    private String code;
    private int pos;
    private char curChar;
    @NotNull
    private String curString;
    private boolean isStartOfLine;
    @NotNull
    private DummyGenerator dummyGenerator;
    private int dummyCounter;
    @NotNull
    private String language;
    private boolean isPreventingInfiniteLoops;

    public CharacterBasedCodeAnnotatedTextBuilder(@NotNull String codeLanguageId) {
        Intrinsics.checkNotNullParameter((Object)codeLanguageId, (String)"codeLanguageId");
        super(codeLanguageId);
        this.code = "";
        this.curString = "";
        this.dummyGenerator = DummyGenerator.Companion.getInstance$default(DummyGenerator.Companion, false, false, 3, null);
        this.language = "en-US";
    }

    @NotNull
    protected final String getCode() {
        return this.code;
    }

    protected final void setCode(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.code = string;
    }

    protected final int getPos() {
        return this.pos;
    }

    protected final void setPos(int n) {
        this.pos = n;
    }

    protected final char getCurChar() {
        return this.curChar;
    }

    protected final void setCurChar(char c) {
        this.curChar = c;
    }

    @NotNull
    protected final String getCurString() {
        return this.curString;
    }

    protected final void setCurString(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.curString = string;
    }

    protected final boolean isStartOfLine() {
        return this.isStartOfLine;
    }

    protected final void setStartOfLine(boolean bl) {
        this.isStartOfLine = bl;
    }

    @NotNull
    protected final DummyGenerator getDummyGenerator() {
        return this.dummyGenerator;
    }

    protected final void setDummyGenerator(@NotNull DummyGenerator dummyGenerator) {
        Intrinsics.checkNotNullParameter((Object)dummyGenerator, (String)"<set-?>");
        this.dummyGenerator = dummyGenerator;
    }

    protected final int getDummyCounter() {
        return this.dummyCounter;
    }

    protected final void setDummyCounter(int n) {
        this.dummyCounter = n;
    }

    @NotNull
    protected final String getLanguage() {
        return this.language;
    }

    protected final void setLanguage(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.language = string;
    }

    public final boolean isPreventingInfiniteLoops() {
        return this.isPreventingInfiniteLoops;
    }

    public final void setPreventingInfiniteLoops(boolean bl) {
        this.isPreventingInfiniteLoops = bl;
    }

    @Override
    public void setSettings(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super.setSettings(settings);
        this.language = settings.getLanguageShortCode();
    }

    @NotNull
    public CharacterBasedCodeAnnotatedTextBuilder addText(@Nullable String text) {
        String string = text;
        boolean bl = string != null ? ((CharSequence)string).length() > 0 : false;
        if (bl) {
            super.addText(text);
            this.pos += text.length();
        }
        return this;
    }

    @NotNull
    public CharacterBasedCodeAnnotatedTextBuilder addMarkup(@Nullable String markup) {
        String string = markup;
        boolean bl = string != null ? ((CharSequence)string).length() > 0 : false;
        if (bl) {
            super.addMarkup(markup);
            this.pos += markup.length();
        }
        return this;
    }

    @NotNull
    public CharacterBasedCodeAnnotatedTextBuilder addMarkup(@Nullable String markup, @Nullable String interpretAs) {
        String string = interpretAs;
        boolean bl = string != null ? ((CharSequence)string).length() > 0 : false;
        if (bl) {
            String string2 = markup;
            if (string2 == null) {
                string2 = "";
            }
            super.addMarkup(string2, interpretAs);
            String string3 = markup;
            this.pos += string3 != null ? string3.length() : 0;
        } else {
            this.addMarkup(markup);
        }
        return this;
    }

    @Override
    @NotNull
    public CharacterBasedCodeAnnotatedTextBuilder addCode(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        this.pos = this.code.length();
        this.code = this.code + code;
        while (this.pos < this.code.length()) {
            int lastPos = this.pos;
            this.curChar = this.code.charAt(this.pos);
            this.curString = String.valueOf(this.curChar);
            this.isStartOfLine = this.pos == 0 || this.code.charAt(this.pos - 1) == '\n';
            this.processCharacter();
            if (this.pos > lastPos) continue;
            if (this.isPreventingInfiniteLoops) {
                throw new IllegalStateException(I18n.INSTANCE.format("characterBasedCodeAnnotatedTextBuilderInfiniteLoop", new Object[0]));
            }
            Logging.INSTANCE.getLOGGER().warning(I18n.INSTANCE.format("characterBasedCodeAnnotatedTextBuilderPreventedInfiniteLoop", new Object[0]));
            int n = this.pos;
            this.pos = n + 1;
        }
        return this;
    }

    protected abstract void processCharacter();

    @Nullable
    protected final MatchResult matchFromPosition(@NotNull Regex regex, int pos) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        String string = this.code.substring(pos);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)string, (int)0, (int)2, null);
        return matchResult != null && ((CharSequence)matchResult.getValue()).length() > 0 ? matchResult : null;
    }

    public static /* synthetic */ MatchResult matchFromPosition$default(CharacterBasedCodeAnnotatedTextBuilder characterBasedCodeAnnotatedTextBuilder, Regex regex, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: matchFromPosition");
        }
        if ((n2 & 2) != 0) {
            n = characterBasedCodeAnnotatedTextBuilder.pos;
        }
        return characterBasedCodeAnnotatedTextBuilder.matchFromPosition(regex, n);
    }

    @NotNull
    protected String generateDummy() {
        int n = this.dummyCounter;
        this.dummyCounter = n + 1;
        return DummyGenerator.generate$default(this.dummyGenerator, this.language, n, false, 4, null);
    }
}

